/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.importation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.importation.ImportationEngine;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.File;
import java.text.ParseException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.RelativePath;

public class ImportationEngineCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ImportationEngine";
    public static final String TYPE_PARAMNAME = "type";
    public static final String ROOT_PARAMNAME = "root";
    public static final String PATH_PARAMNAME = "path";
    public static final String TMP_ROOT_PARAMVALUE = "tmp";
    public static final String RUN_ROOT_PARAMVALUE = "run";
    private File source;
    private String engineType;

    public ImportationEngineCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("importation", "ImportationEngine/" + this.engineType);){
            ImportationEngine.run(session, this.requestHandler, this.engineType, this.source);
        }
        this.setDone("_ done.importation.engine", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        RelativePath relativePath;
        this.checkFichothequeAdmin();
        this.engineType = this.getMandatory(TYPE_PARAMNAME);
        if (!ImportationEngine.isValidEngineType(this.engineType)) {
            throw BdfErrors.wrongParameterValue(TYPE_PARAMNAME, this.engineType);
        }
        String root = this.checkRoot();
        String path = this.getMandatory(PATH_PARAMNAME).trim();
        try {
            relativePath = RelativePath.parse(path);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(PATH_PARAMNAME, path);
        }
        if (relativePath.isEmpty()) {
            throw BdfErrors.emptyMandatoryParameter(PATH_PARAMNAME);
        }
        this.source = this.getSource(root, relativePath);
    }

    private String checkRoot() throws ErrorMessageException {
        String root;
        switch (root = this.getMandatory(ROOT_PARAMNAME)) {
            case "tmp": {
                return TMP_ROOT_PARAMVALUE;
            }
            case "run": {
                return RUN_ROOT_PARAMVALUE;
            }
        }
        throw BdfErrors.unknownParameterValue(ROOT_PARAMNAME, root);
    }

    private File getSource(String root, RelativePath relativePath) throws ErrorMessageException {
        File rootDir;
        switch (root) {
            case "tmp": {
                rootDir = ConfigurationUtils.getTmpDirectory(this.bdfServer);
                break;
            }
            case "run": {
                rootDir = this.bdfServer.getBdfServerDirs().getDir("var.run");
                break;
            }
            default: {
                throw new ShouldNotOccurException("Check done before");
            }
        }
        File src = new File(rootDir, relativePath.toString());
        if (!src.exists()) {
            throw BdfErrors.unknownParameterValue(PATH_PARAMNAME, relativePath.toString());
        }
        return src;
    }
}

