/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.table.TableExportDescription;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class TableExportCopyCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TableExportCopy";
    public static final String COMMANDKEY = "_ EXP-18";
    public static final String NEWTABLEEXPORT_PARAMNAME = "newtableexport";
    private String tableExportName;
    private String newTableExportName;

    public TableExportCopyCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TableExportManager tableExportManager = this.bdfServer.getTableExportManager();
        TableExportDescription newTableExportDescription = tableExportManager.copyTableExport(this.tableExportName, this.newTableExportName, editOrigin);
        if (newTableExportDescription != null) {
            this.putResultObject("obj.tableexportdescription", newTableExportDescription);
            this.setDone("_ done.exportation.tableexportcopy", this.tableExportName, this.newTableExportName);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TableExportDescription tableExportDescription = this.requestHandler.getMandatoryTableExportDescription();
        this.tableExportName = tableExportDescription.getName();
        this.newTableExportName = this.getMandatory(NEWTABLEEXPORT_PARAMNAME).trim();
        if (this.newTableExportName.length() == 0) {
            throw BdfErrors.error("_ error.empty.exportname");
        }
        if (!StringUtils.isTechnicalName(this.newTableExportName, true)) {
            throw BdfErrors.error("_ error.wrong.exportname", this.newTableExportName);
        }
        if (this.bdfServer.getTableExportManager().containsTableExport(this.newTableExportName)) {
            throw BdfErrors.error("_ error.existing.tableexport", this.newTableExportName);
        }
    }
}

