/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.edition;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadEngine;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;

public class FilesUploadCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FilesUpload";
    public static final String FILES_PARAMNAME = "files";
    public static final String MODE_PARAMNAME = "mode";
    private String mode;

    public FilesUploadCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FileValue[] files = this.requestHandler.getRequestMap().getFileValues(FILES_PARAMNAME);
        if (files == null || files.length == 0) {
            throw BdfErrors.emptyMandatoryParameter(FILES_PARAMNAME);
        }
        FilesUploadEngine engine = FilesUploadEngine.newInstance(this.bdfServer, this.mode);
        for (FileValue fileValue : files) {
            try {
                engine.addFileUpload(fileValue);
            }
            catch (IOException ioe) {
                throw BdfErrors.error("_ error.exception.io", ioe.getMessage());
            }
        }
        this.putResultObject("obj.filesuploadresult", engine.getResult());
        this.setDone("_ done.edition.filesupload", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String mode = this.requestHandler.getMandatoryParameter(MODE_PARAMNAME);
        try {
            this.mode = FilesUploadEngine.checkMode(mode);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(MODE_PARAMNAME, mode);
        }
    }
}

