/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import java.text.ParseException;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class SubsetIncludeCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SubsetIncludeCreation";
    public static final String COMMANDKEY = "_ CRP-12";
    public static final String SUBSET_PARAMNAME = "subset";
    public static final String MASTERINCLUDE_PARAMNAME = "masterinclude";
    public static final String WEIGHTFILTER_PARAMNAME = "weightfilter";
    public static final String MODE_PARAMNAME = "mode";
    public static final String NO_WEIGHTFILTER_PARAMVALUE = "0";
    public static final String YES_WEIGHTFILTER_PARAMVALUE = "1";
    public static final String WEIGHTFILTERVALUE_PARAMNAME = "weightfiltervalue";
    private Corpus corpus;
    private UiComponents uiComponents;
    private Subset subset;
    private ExtendedIncludeKey includeKey;

    public SubsetIncludeCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = session.getBdfServerEditor().putComponentUi(this.uiComponents, this.buildIncludeUi());
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.subsetincludecreation", this.includeKey);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String mode;
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        String subsetString = this.getMandatory(SUBSET_PARAMNAME);
        SubsetKey subsetKey = null;
        try {
            subsetKey = SubsetKey.parse(subsetString);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(SUBSET_PARAMNAME, subsetString);
        }
        this.subset = this.bdfServer.getFichotheque().getSubset(subsetKey);
        if (this.subset == null) {
            throw BdfErrors.unknownParameterValue(SUBSET_PARAMNAME, subsetString);
        }
        String weightFilterString = this.getMandatory(WEIGHTFILTER_PARAMNAME);
        int weightFilter = -1;
        if (weightFilterString.equals(YES_WEIGHTFILTER_PARAMVALUE)) {
            String weightFilterValue = this.getMandatory(WEIGHTFILTERVALUE_PARAMNAME);
            boolean error = false;
            try {
                weightFilter = Integer.parseInt(weightFilterValue);
                if (weightFilter < 1) {
                    error = true;
                }
            }
            catch (NumberFormatException nfe) {
                error = true;
            }
            if (error) {
                throw BdfErrors.error("_ error.wrong.weight", weightFilterValue);
            }
        } else if (!weightFilterString.equals(NO_WEIGHTFILTER_PARAMVALUE)) {
            throw BdfErrors.unknownParameterValue(WEIGHTFILTER_PARAMNAME, weightFilterString);
        }
        if (!(mode = this.requestHandler.getTrimedParameter(MODE_PARAMNAME)).isEmpty()) {
            try {
                StringUtils.checkTechnicalName(mode, false);
            }
            catch (ParseException pe) {
                throw BdfErrors.error("_ error.wrong.mode", mode);
            }
        }
        boolean master = false;
        Subset masterSubset = this.corpus.getMasterSubset();
        if (masterSubset != null) {
            master = this.requestHandler.isTrue(MASTERINCLUDE_PARAMNAME);
        }
        try {
            this.includeKey = ExtendedIncludeKey.newInstance(IncludeKey.newInstance(subsetKey, mode, weightFilter), master);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue(SUBSET_PARAMNAME, subsetString);
        }
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        if (this.uiComponents.contains(this.includeKey.getKeyString())) {
            throw BdfErrors.error("_ error.existing.include", this.includeKey.getKeyString());
        }
    }

    private IncludeUi buildIncludeUi() {
        String type;
        DynamicEditPolicy policy;
        Thesaurus thesaurus;
        IncludeUiBuilder includeUiBuilder = IncludeUiBuilder.initSubset(this.includeKey);
        if (this.subset instanceof Thesaurus && (thesaurus = (Thesaurus)this.subset).isBabelienType() && (policy = this.bdfServer.getPolicyManager().getPolicyProvider().getDynamicEditPolicy(thesaurus)).getType().equals("external") && (type = ((DynamicEditPolicy.External)policy).getExternalSourceDef().getType()).equals("fichothequecorpus")) {
            includeUiBuilder.putOption("inputType", "fichestyle");
        }
        return includeUiBuilder.toIncludeUi();
    }
}

