/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import fr.exemole.bdfserver.tools.ui.components.CommentUiBuilder;
import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CommentChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "CommentChange";
    public static final String COMMANDKEY = "_ CRP-16";
    public static final String NAME_PARAMNAME = "name";
    public static final String LOCATION_PARAMNAME = "location";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    public static final String COMMENT_PREFIX = "comment/";
    public static final String LOCATION_FORM_PARAMVALUE = "form";
    public static final String LOCATION_TEMPLATE_PARAMVALUE = "template";
    public static final String LOCATION_BOTH_PARAMVALUE = "both";
    private Corpus corpus;
    private UiComponents uiComponents;
    private CommentUi commentUi;
    private int location;
    private String attributes;

    public CommentChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = this.updateCommentUi(session.getBdfServerEditor(), this.commentUi);
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.commentchange", this.commentUi.getCommentName());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        String name = this.getMandatory(NAME_PARAMNAME);
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(this.corpus);
        this.commentUi = (CommentUi)this.uiComponents.getUiComponent(CommentUi.toComponentName(name));
        if (this.commentUi == null) {
            throw BdfErrors.unknownParameterValue(NAME_PARAMNAME, name);
        }
        this.location = CommentChangeCommand.getLocation(this.requestHandler, LOCATION_PARAMNAME);
        this.attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
    }

    private boolean updateCommentUi(BdfServerEditor bdfServerEditor, CommentUi commentUi) throws ErrorMessageException {
        CommentUiBuilder commentUiBuilder = CommentUiBuilder.init(this.bdfServer.getUiManager().getHtmlCleaner(), commentUi).setLocation(this.location);
        AttributeParser.parse(commentUiBuilder.getAttributeChangeBuilder(), this.attributes);
        CommentChangeCommand.putHtmlString(commentUiBuilder, this.requestHandler, COMMENT_PREFIX);
        return bdfServerEditor.putComponentUi(this.uiComponents, commentUiBuilder.toCommentUi());
    }

    public static int getLocation(RequestHandler requestHandler, String paramName) throws ErrorMessageException {
        String positionString = requestHandler.getMandatoryParameter(paramName);
        if (positionString.equals(LOCATION_FORM_PARAMVALUE)) {
            return 1;
        }
        if (positionString.equals(LOCATION_TEMPLATE_PARAMVALUE)) {
            return 2;
        }
        if (positionString.equals(LOCATION_BOTH_PARAMVALUE)) {
            return 3;
        }
        throw BdfErrors.unknownParameterValue(paramName, positionString);
    }

    public static void putHtmlString(CommentUiBuilder commentUiBuilder, RequestHandler requestHandler, String paramPrefix) throws ErrorMessageException {
        int prefixLength = paramPrefix.length();
        for (String paramName : requestHandler.getParameterNameSet()) {
            if (!paramName.startsWith(paramPrefix)) continue;
            try {
                Lang currentLang = Lang.parse(paramName.substring(prefixLength));
                String value = requestHandler.getMandatoryParameter(paramName);
                commentUiBuilder.putHtml(currentLang, value);
            }
            catch (ParseException parseException) {}
        }
    }
}

