/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.addenda;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.tools.parsers.DocumentChangeInfo;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.FileLength;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.FileName;

public class DocumentFileUploadCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DocumentFileUpload";
    public static final String FILE_PARAMNAME = "file";
    private Addenda addenda;

    public DocumentFileUploadCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        File tmpFile;
        FileName fileName;
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue == null) {
            throw BdfErrors.emptyMandatoryParameter(FILE_PARAMNAME);
        }
        if (fileValue.length() < 2L) {
            fileValue.free();
            throw BdfErrors.error("_ error.empty.file");
        }
        String originalName = fileValue.getName();
        try {
            fileName = FileName.parse(originalName);
        }
        catch (ParseException pe) {
            fileName = null;
        }
        if (fileName == null || !AddendaUtils.testExtension(fileName.getExtension().toLowerCase())) {
            fileValue.free();
            throw BdfErrors.error("_ error.wrong.extension", originalName);
        }
        String basename = AddendaUtils.checkBasename(fileName.getBasename(), this.addenda);
        String extension = fileName.getExtension().toLowerCase();
        try {
            tmpFile = FilesUploadUtils.saveTmpFile(this.bdfServer, fileValue, extension);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.io", ioe.getMessage());
        }
        finally {
            fileValue.free();
        }
        this.setDone("_ done.addenda.documentfileupload", new Object[0]);
        DocumentChangeInfo documentChangeInfo = DocumentChangeInfo.parse("bn=" + basename + ",tf=" + tmpFile.getName());
        this.putResultObject("obj.documentchangeinfo", documentChangeInfo);
        this.putResultObject("obj.string", fileName.getBasename());
        this.putResultObject("obj.filelength", new FileLength(tmpFile.length()));
        this.putResultObject("obj.addenda", this.addenda);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.addenda = this.requestHandler.getMandatoryAddenda();
    }
}

