/* global Bdf,$$,Illustration */

Illustration.UploadConfirm = {};

Illustration.UploadConfirm.ARGS = {
    clientId: "",
    callKey: "",
    tmpFileName: "",
    imagePath: ""
};

Illustration.UploadConfirm.init = function (args) {
    var genId = Bdf.generateId();
    $$(args.clientId).html(Bdf.render("illustration:client-uploadconfirm", {
        args: args,
        genId: genId
    }));
    $$(genId, "cancel").click(function () {
        _close(false);
    });
    $$(genId, "confirm").click(function () {
        _close(true);
    });
    
    
    function _close(validate) {
        let tmpFileName;
        if (validate) {
            tmpFileName = args.tmpFileName;
        }
        let callerWindow;
        if (window.opener) {
            callerWindow = window.opener;
        } else {
            callerWindow = window.parent;
        }
        let callback = callerWindow.Bdf.getCallback(args.callKey);
        if (callback) {
            callback(tmpFileName);
        }
        if (window.opener) {
            window.close();
        }
    }
    
};

$(function () {
    Bdf.initTemplates();
    Illustration.UploadConfirm.init(Illustration.UploadConfirm.ARGS);
});