/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.util.SortedMap;
import java.util.TreeMap;
import net.scrutari.dataexport.api.FicheExport;
import net.scrutari.dataexport.xml.XmlAttributeExport;
import net.scrutari.dataexport.xml.XmlWriter;

public class XmlFicheExport
extends XmlAttributeExport
implements FicheExport {
    private final SortedMap<Integer, String> complementMap = new TreeMap<Integer, String>();
    private String ficheId;
    private String titre;
    private String soustitre;
    private String date;
    private String lang;
    private String href;
    private String ficheIcon;
    private String latitude;
    private String longitude;

    public void reinit(String ficheId) {
        this.ficheId = ficheId;
        this.titre = null;
        this.soustitre = null;
        this.date = null;
        this.lang = null;
        this.href = null;
        this.ficheIcon = null;
        this.latitude = null;
        this.longitude = null;
        this.complementMap.clear();
        super.clear();
    }

    @Override
    public void setTitre(String titre) {
        this.titre = titre;
    }

    @Override
    public void setSoustitre(String soustitre) {
        this.soustitre = soustitre;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public void setFicheIcon(String ficheIcon) {
        this.ficheIcon = ficheIcon;
    }

    @Override
    public void setGeoloc(String latitude, String longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Override
    public void addComplement(int complementNumber, String complementValue) {
        if (complementNumber < 1) {
            return;
        }
        this.complementMap.put(complementNumber, complementValue);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) {
        xmlWriter.openTagWithAttribute("fiche", "fiche-id", this.ficheId);
        xmlWriter.addSimpleElement("titre", this.titre);
        xmlWriter.addSimpleElement("soustitre", this.soustitre);
        xmlWriter.addSimpleElement("date", this.date);
        xmlWriter.addSimpleElement("lang", this.lang);
        xmlWriter.addSimpleElement("href", this.href);
        xmlWriter.addSimpleElement("fiche-icon", this.ficheIcon);
        if (this.latitude != null && this.longitude != null) {
            xmlWriter.openTag("geoloc");
            xmlWriter.addSimpleElement("lat", this.latitude);
            xmlWriter.addSimpleElement("lon", this.longitude);
            xmlWriter.closeTag("geoloc");
        }
        if (this.complementMap.size() > 0) {
            int max = this.complementMap.lastKey();
            for (int i = 1; i <= max; ++i) {
                String s = (String)this.complementMap.get(i);
                if (s == null || s.length() == 0) {
                    xmlWriter.addEmptyElement("complement", null, null);
                    continue;
                }
                xmlWriter.addSimpleElement("complement", s);
            }
        }
        this.writeAttributes(xmlWriter);
        xmlWriter.closeTag("fiche");
    }
}

