/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.mapeadores.util.primitives.io.PrimitivesReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class PrimitivesSAXReader
implements XMLReader {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final Attributes EMPTY_ATTRIBUTES = new EmptyAttributes();
    private Map<String, Boolean> featureMap = new HashMap<String, Boolean>();
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private ContentHandler contentHandler;
    private PrimitivesReader primitivesReader;
    private Stack<String> elementNameStack = new Stack();

    public PrimitivesSAXReader(PrimitivesReader primitivesReader) {
        this.featureMap.put("http://xml.org/sax/features/namespaces", true);
        this.featureMap.put("http://xml.org/sax/features/namespace-prefixes", false);
        this.primitivesReader = primitivesReader;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.featureMap.containsKey(name)) {
            return this.featureMap.get(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.read(this.primitivesReader, this.contentHandler);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.featureMap.containsKey(name)) {
            this.featureMap.put(name, value);
            return;
        }
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    private void read(PrimitivesReader primitivesReader, ContentHandler contentHandler) throws IOException, SAXException {
        byte b = primitivesReader.readByte();
        if (b != 1) {
            throw new IllegalStateException("fist byte != PrimitivesXMLWriter.ELEMENT_START");
        }
        contentHandler.startDocument();
        this.startElement(primitivesReader, contentHandler);
        while (true) {
            boolean documentEnd;
            if ((b = primitivesReader.readByte()) == 1) {
                this.startElement(primitivesReader, contentHandler);
                continue;
            }
            if (b == 3) {
                this.addText(primitivesReader, contentHandler);
                continue;
            }
            if (b == 2 && (documentEnd = this.endElement(contentHandler))) break;
        }
    }

    private void startElement(PrimitivesReader primitivesReader, ContentHandler contentHandler) throws IOException, SAXException {
        String elementName = primitivesReader.readString();
        this.elementNameStack.push(elementName);
        int length = primitivesReader.readInt();
        if (length == 0) {
            contentHandler.startElement("", elementName, elementName, EMPTY_ATTRIBUTES);
        } else {
            ArrayAttributes arrayAttributes = new ArrayAttributes(length);
            for (int i = 0; i < length; ++i) {
                String name = primitivesReader.readString();
                String value = primitivesReader.readString();
                arrayAttributes.set(i, name, value);
            }
            contentHandler.startElement("", elementName, elementName, arrayAttributes);
        }
    }

    private void addText(PrimitivesReader primitivesReader, ContentHandler contentHandler) throws IOException, SAXException {
        int length = primitivesReader.readInt();
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = primitivesReader.readChar();
        }
        contentHandler.characters(array, 0, length);
    }

    private boolean endElement(ContentHandler contentHandler) throws IOException, SAXException {
        String elementName = this.elementNameStack.pop();
        contentHandler.endElement("", elementName, elementName);
        if (this.elementNameStack.empty()) {
            contentHandler.endDocument();
            return true;
        }
        return false;
    }

    private static class ArrayAttributes
    implements Attributes {
        private int length;
        private String[] qnameArray;
        private String[] valueArray;
        private boolean[] xmlNamespaceArray;

        private ArrayAttributes(int length) {
            this.length = length;
            this.qnameArray = new String[length];
            this.valueArray = new String[length];
            this.xmlNamespaceArray = new boolean[length];
        }

        private void set(int i, String name, String value) {
            this.qnameArray[i] = name;
            this.valueArray[i] = value;
            this.xmlNamespaceArray[i] = name.startsWith("xml:");
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (uri.equals(PrimitivesSAXReader.XML_NAMESPACE)) {
                return this.getIndex("xml:" + localName);
            }
            if (uri.length() != 0) {
                return -1;
            }
            return this.getIndex(localName);
        }

        @Override
        public int getIndex(String qName) {
            for (int i = 0; i < this.length; ++i) {
                if (!this.qnameArray[i].equals(qName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public String getLocalName(int index) {
            if (!this.testIndex(index)) {
                return null;
            }
            String qname = this.qnameArray[index];
            if (this.xmlNamespaceArray[index]) {
                return qname.substring(4);
            }
            return qname;
        }

        @Override
        public String getQName(int index) {
            if (!this.testIndex(index)) {
                return null;
            }
            return this.qnameArray[index];
        }

        @Override
        public String getType(int index) {
            if (!this.testIndex(index)) {
                return null;
            }
            return "CDATA";
        }

        @Override
        public String getType(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (index == -1) {
                return null;
            }
            return "CDATA";
        }

        @Override
        public String getType(String qName) {
            int index = this.getIndex(qName);
            if (index == -1) {
                return null;
            }
            return "CDATA";
        }

        @Override
        public String getURI(int index) {
            if (!this.testIndex(index)) {
                return null;
            }
            if (this.xmlNamespaceArray[index]) {
                return PrimitivesSAXReader.XML_NAMESPACE;
            }
            return "";
        }

        @Override
        public String getValue(int index) {
            if (!this.testIndex(index)) {
                return null;
            }
            return this.valueArray[index];
        }

        @Override
        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (index == -1) {
                return null;
            }
            return this.valueArray[index];
        }

        @Override
        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (index == -1) {
                return null;
            }
            return this.valueArray[index];
        }

        private boolean testIndex(int index) {
            return index >= 0 && index < this.length;
        }
    }

    private static class EmptyAttributes
    implements Attributes {
        private EmptyAttributes() {
        }

        @Override
        public int getIndex(String uri, String localName) {
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            return -1;
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public String getLocalName(int index) {
            return null;
        }

        @Override
        public String getQName(int index) {
            return null;
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getType(String uri, String localName) {
            return null;
        }

        @Override
        public String getType(String qName) {
            return null;
        }

        @Override
        public String getURI(int index) {
            return null;
        }

        @Override
        public String getValue(int index) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            return null;
        }

        @Override
        public String getValue(String qName) {
            return null;
        }
    }
}

