/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.uml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.text.StringUtils;

public class UmlClass {
    private static final String INDENT = "  ";
    private final String name;
    private final List<Item> fieldList = new ArrayList<Item>();
    private String title = "";
    private char circleLetter = '\u0000';
    private String circleColor;

    public UmlClass(String name) {
        this.name = name;
    }

    public UmlClass title(String title) {
        this.title = title == null ? "" : title;
        return this;
    }

    public UmlClass circle(char circleLetter, String circleColor) {
        this.circleLetter = circleLetter;
        this.circleColor = circleColor == null ? "" : circleColor;
        return this;
    }

    public UmlClass addField(String field) {
        this.fieldList.add(new Field(field));
        return this;
    }

    public UmlClass addSeparator(String title) {
        this.fieldList.add(new Separator(title));
        return this;
    }

    public void write(Appendable appendable, int indentValue) throws IOException {
        UmlClass.indent(appendable, indentValue);
        appendable.append("class ");
        if (this.title.length() > 0) {
            appendable.append('\"');
            StringUtils.escapeDoubleQuote(this.title, appendable);
            appendable.append('\"');
            appendable.append(" as ");
            appendable.append(this.name);
        } else {
            appendable.append(this.name);
        }
        if (this.circleLetter != '\u0000') {
            appendable.append(" << (");
            appendable.append(this.circleLetter);
            if (this.circleColor.length() > 0) {
                appendable.append(',');
                appendable.append(this.circleColor);
            }
            appendable.append(" )>>");
        }
        if (!this.fieldList.isEmpty()) {
            appendable.append(" {\n");
            for (Item item : this.fieldList) {
                UmlClass.indent(appendable, indentValue + 1);
                item.write(appendable);
            }
            UmlClass.indent(appendable, indentValue);
            appendable.append("}\n");
        } else {
            appendable.append("\n");
        }
    }

    public static UmlClass init(String name) {
        return new UmlClass(name);
    }

    private static void indent(Appendable appendable, int indentValue) throws IOException {
        for (int i = 0; i < indentValue; ++i) {
            appendable.append(INDENT);
        }
    }

    private static class Field
    extends Item {
        private final String value;

        private Field(String value) {
            this.value = value;
        }

        @Override
        public void write(Appendable appendable) throws IOException {
            appendable.append("{field} ");
            appendable.append(this.value);
            appendable.append("\n");
        }
    }

    private static class Separator
    extends Item {
        private final String title;

        private Separator(String title) {
            this.title = title;
        }

        @Override
        public void write(Appendable appendable) throws IOException {
            if (this.title.isEmpty()) {
                appendable.append("..\n");
            } else {
                appendable.append(".. ");
                appendable.append(this.title);
                appendable.append(" ..\n");
            }
        }
    }

    private static abstract class Item {
        private Item() {
        }

        public abstract void write(Appendable var1) throws IOException;
    }
}

