/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.primitives.DecimalLong;
import net.mapeadores.util.primitives.DecimalLongFilter;

public class DecimalLongFilterFactory {
    private static final short EQUALS = 0;
    private static final short MINUS = -1;
    private static final short PLUS = 1;

    private DecimalLongFilterFactory() {
    }

    public static DecimalLongFilter newInstance(long decimalLong) {
        return DecimalLongFilterFactory.newTypeInstance(decimalLong, (short)0);
    }

    private static UniqueDecimalLongFilter newTypeInstance(long decimalLong, short equalityType) {
        return new UniqueDecimalLongFilter(decimalLong, equalityType);
    }

    public static DecimalLongFilter newInstance(long decimalLong1, long decimalLong2) {
        if (decimalLong1 == decimalLong2) {
            return DecimalLongFilterFactory.newInstance(decimalLong1);
        }
        if (decimalLong1 > decimalLong2) {
            return DecimalLongFilterFactory.newInstance(decimalLong2, decimalLong1);
        }
        UniqueDecimalLongFilter decimalLongFilter1 = DecimalLongFilterFactory.newTypeInstance(decimalLong1, (short)1);
        UniqueDecimalLongFilter decimalLongFilter2 = DecimalLongFilterFactory.newTypeInstance(decimalLong2, (short)-1);
        return new DoubleDecimalLongFilter(decimalLongFilter1, decimalLongFilter2);
    }

    public static String toString(DecimalLongFilter decimalLongFilter, char decimalSeparator) {
        if (decimalLongFilter instanceof UniqueDecimalLongFilter) {
            return DecimalLong.toString(((UniqueDecimalLongFilter)decimalLongFilter).filterDecimalLong, decimalSeparator);
        }
        if (decimalLongFilter instanceof DoubleDecimalLongFilter) {
            DoubleDecimalLongFilter doubleDecimalLongFilter = (DoubleDecimalLongFilter)decimalLongFilter;
            return DecimalLong.toString(doubleDecimalLongFilter.decimalLongFilter1.filterDecimalLong, decimalSeparator) + "; " + DecimalLong.toString(doubleDecimalLongFilter.decimalLongFilter2.filterDecimalLong, decimalSeparator);
        }
        return "";
    }

    private static boolean test(short equalityType, long decimalLong, long filterDecimalLong) {
        switch (equalityType) {
            case 0: {
                return decimalLong == filterDecimalLong;
            }
            case 1: {
                return decimalLong >= filterDecimalLong;
            }
            case -1: {
                return decimalLong <= filterDecimalLong;
            }
        }
        throw new SwitchException("Unkonw type: " + equalityType);
    }

    private static class UniqueDecimalLongFilter
    implements DecimalLongFilter {
        private long filterDecimalLong;
        private short equalityType;

        private UniqueDecimalLongFilter(long filterDecimalLong, short equalityType) {
            this.filterDecimalLong = filterDecimalLong;
            this.equalityType = equalityType;
        }

        @Override
        public boolean containsDecimalLong(long decimalLong) {
            return DecimalLongFilterFactory.test(this.equalityType, decimalLong, this.filterDecimalLong);
        }
    }

    private static class DoubleDecimalLongFilter
    implements DecimalLongFilter {
        private UniqueDecimalLongFilter decimalLongFilter1;
        private UniqueDecimalLongFilter decimalLongFilter2;

        private DoubleDecimalLongFilter(UniqueDecimalLongFilter decimalLongFilter1, UniqueDecimalLongFilter decimalLongFilter2) {
            this.decimalLongFilter1 = decimalLongFilter1;
            this.decimalLongFilter2 = decimalLongFilter2;
        }

        @Override
        public boolean containsDecimalLong(long decimalLong) {
            return this.decimalLongFilter1.containsDecimalLong(decimalLong) && this.decimalLongFilter2.containsDecimalLong(decimalLong);
        }
    }
}

