/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import net.mapeadores.util.json.JSONString;
import net.mapeadores.util.text.StringUtils;

public final class Decimal
implements Serializable,
JSONString {
    private static final long serialVersionUID = 1L;
    private final long partieEntiere;
    private final int partieDecimale;
    private final byte zeroLength;

    public Decimal(long partieEntiere, byte zeroLength, int partieDecimale) {
        if (partieEntiere < 0L) {
            if (partieDecimale > 0) {
                partieDecimale = -partieDecimale;
            }
        } else if (partieEntiere > 0L && partieDecimale < 0) {
            partieDecimale = -partieDecimale;
        }
        if (zeroLength < 0) {
            zeroLength = -zeroLength;
        }
        this.partieEntiere = partieEntiere;
        this.zeroLength = zeroLength;
        this.partieDecimale = partieDecimale;
    }

    public Decimal(double d) {
        this.partieEntiere = (long)d;
        double d2 = Math.abs(d - (double)this.partieEntiere);
        if (d2 == 0.0) {
            this.partieDecimale = 0;
            this.zeroLength = 0;
        } else {
            int pe2;
            double d3;
            int zl = 0;
            while (!((d3 = d2 * 10.0) >= 1.0)) {
                d2 = d3;
                ++zl;
            }
            this.zeroLength = (byte)zl;
            int partE = (int)Math.round(d2 * 1000000.0);
            if (partE == 1000000) {
                partE = 999999;
            }
            while ((pe2 = partE / 10) * 10 == partE) {
                partE = pe2;
            }
            if (this.partieEntiere < 0L) {
                partE = -partE;
            }
            this.partieDecimale = partE;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Decimal other = (Decimal)obj;
        if (other.partieEntiere != this.partieEntiere) {
            return false;
        }
        if (other.partieDecimale != this.partieDecimale) {
            return false;
        }
        return other.zeroLength == this.zeroLength;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public long getPartieEntiere() {
        return this.partieEntiere;
    }

    public double toDouble() {
        return Double.parseDouble(this.toString());
    }

    public float toFloat() {
        return Float.parseFloat(this.toString());
    }

    public int getPartieDecimale() {
        return this.partieDecimale;
    }

    public String toString() {
        return Decimal.toString(this.partieEntiere, this.zeroLength, this.partieDecimale);
    }

    @Override
    public String toJSONString() {
        return Decimal.toString(this.partieEntiere, this.zeroLength, this.partieDecimale);
    }

    public String toString(DecimalFormatSymbols symbols) {
        return this.toString(symbols.getDecimalSeparator(), symbols.getGroupingSeparator());
    }

    public String toString(char decimalSeparator, char groupingSeparator) {
        StringBuilder buf = new StringBuilder();
        Decimal.append(buf, this.partieEntiere, groupingSeparator, false, this.partieDecimale);
        if (this.partieDecimale != 0 || this.zeroLength != 0) {
            buf.append(decimalSeparator);
            Decimal.appendDecimal(buf, this.zeroLength, this.partieDecimale);
        }
        return buf.toString();
    }

    public String toStringWithBlank(char decimalSeparator) {
        StringBuilder buf = new StringBuilder();
        Decimal.append(buf, this.partieEntiere, ' ', true, this.partieDecimale);
        if (this.partieDecimale != 0 || this.zeroLength != 0) {
            buf.append(decimalSeparator);
            Decimal.appendDecimal(buf, this.zeroLength, this.partieDecimale);
            buf.append(' ');
        }
        return buf.toString();
    }

    public byte getZeroLength() {
        return this.zeroLength;
    }

    public String getPartieEntiereString() {
        if (this.partieEntiere == 0L) {
            if (this.partieDecimale < 0) {
                return "-0";
            }
            return "0";
        }
        return Long.toString(this.partieEntiere);
    }

    public String getPartieDecimaleString() {
        return Decimal.getPartieDecimaleString(this.zeroLength, this.partieDecimale);
    }

    private static void append(StringBuilder buf, long l, char groupingSeparator, boolean atLast, int partieDecimale) {
        if (l == Long.MIN_VALUE) {
            buf.append("- 9 223 372 036 854 775 808");
            return;
        }
        if (l < 0L) {
            l = -l;
            buf.append("- ");
        } else if (l == 0L && partieDecimale < 0) {
            buf.append("- ");
        }
        String s = Long.toString(l);
        int length = s.length();
        if (length <= 3) {
            buf.append(s);
            if (atLast) {
                buf.append(groupingSeparator);
            }
            return;
        }
        int reste = length % 3;
        if (reste > 0) {
            buf.append(s.charAt(0));
            if (reste > 1) {
                buf.append(s.charAt(1));
            }
            buf.append(groupingSeparator);
        }
        int p = 0;
        for (int i = reste; i < length; ++i) {
            buf.append(s.charAt(i));
            if (++p != 3) continue;
            if (i < length - 1 || atLast) {
                buf.append(groupingSeparator);
            }
            p = 0;
        }
    }

    public static String toString(long partieEntiere, byte zeroLength, int partieDecimale) {
        if (partieDecimale == 0 && zeroLength == 0) {
            return Long.toString(partieEntiere);
        }
        StringBuilder buf = new StringBuilder();
        if (partieEntiere == 0L && partieDecimale < 0) {
            buf.append("-0");
        } else {
            buf.append(Long.toString(partieEntiere));
        }
        buf.append('.');
        Decimal.appendDecimal(buf, zeroLength, partieDecimale);
        return buf.toString();
    }

    public static String getPartieDecimaleString(byte zeroLength, int partieDecimale) {
        StringBuilder buf = new StringBuilder();
        Decimal.appendDecimal(buf, zeroLength, partieDecimale);
        return buf.toString();
    }

    public static float toFloat(byte zeroLength, int partieDecimale) {
        StringBuilder buf = new StringBuilder();
        buf.append("0.");
        Decimal.appendDecimal(buf, zeroLength, partieDecimale);
        return Float.parseFloat(buf.toString());
    }

    private static void appendDecimal(StringBuilder buf, byte zeroLength, int partieDecimale) {
        for (int i = 0; i < zeroLength; ++i) {
            buf.append('0');
        }
        if (partieDecimale != 0) {
            buf.append(Integer.toString(Math.abs(partieDecimale)));
        }
    }

    public Decimal abs() {
        if (this.partieEntiere < 0L || this.partieDecimale < 0) {
            return new Decimal(-this.partieEntiere, this.zeroLength, -this.partieDecimale);
        }
        return this;
    }

    public boolean isZero() {
        return this.partieEntiere == 0L && this.partieDecimale == 0;
    }

    public boolean isPositif() {
        return this.partieEntiere >= 0L && this.partieDecimale >= 0;
    }

    public Decimal getOpposite() {
        return new Decimal(-this.partieEntiere, this.zeroLength, -this.partieDecimale);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toString());
    }

    public static Decimal fromBigDecimal(BigDecimal bigDecimal) {
        return StringUtils.parseDecimal(bigDecimal.toPlainString());
    }
}

