/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.misc;

import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static Object move(Object[] tab, int i, int j) {
        Object value = tab[i];
        if (i == j) {
            return value;
        }
        if (i < j) {
            System.arraycopy(tab, i + 1, tab, i, j - i);
        } else {
            System.arraycopy(tab, j, tab, j + 1, i - j);
        }
        tab[j] = value;
        return value;
    }

    public static int move(int[] tab, int i, int j) {
        int value = tab[i];
        if (i == j) {
            return value;
        }
        if (i < j) {
            System.arraycopy(tab, i + 1, tab, i, j - i);
        } else {
            System.arraycopy(tab, j, tab, j + 1, i - j);
        }
        tab[j] = value;
        return value;
    }

    public static Object remove(Object[] tab, int i, int clearindex) {
        if (clearindex < i) {
            clearindex = tab.length - 1;
        }
        Object value = tab[i];
        int length = clearindex - i;
        if (length > 0) {
            System.arraycopy(tab, i + 1, tab, i, length);
        }
        tab[clearindex] = null;
        return value;
    }

    public static int remove(int[] tab, int i, int maxindex) {
        if (maxindex < i) {
            maxindex = tab.length - 1;
        }
        int value = tab[i];
        int lg = maxindex - i;
        if (lg > 0) {
            System.arraycopy(tab, i + 1, tab, i, lg);
        }
        tab[maxindex] = 0;
        return value;
    }

    public static Object[] addUnique(Object[] origine, Object object, Object[] destination) {
        int length = origine.length;
        for (int i = 0; i < length; ++i) {
            if (!origine[i].equals(object)) continue;
            return origine;
        }
        System.arraycopy(origine, 0, destination, 0, length);
        destination[length] = object;
        return destination;
    }

    public static Object[] removeUnique(Object[] origine, Object object, Object[] destination) {
        int length = origine.length;
        int rmvIndex = -1;
        for (int i = 0; i < length; ++i) {
            if (!origine[i].equals(object)) continue;
            rmvIndex = i;
            break;
        }
        if (rmvIndex == -1) {
            return origine;
        }
        if (rmvIndex == 0) {
            System.arraycopy(origine, 1, destination, 0, length - 1);
        } else if (rmvIndex == length - 1) {
            System.arraycopy(origine, 0, destination, 0, length - 1);
        } else {
            System.arraycopy(origine, 0, destination, 0, rmvIndex);
            System.arraycopy(origine, rmvIndex + 1, destination, rmvIndex, length - 1 - rmvIndex);
        }
        return destination;
    }

    public static int indexOf(Object[] objs, Object obj) {
        if (obj == null) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null || !obj.equals(objs[i])) continue;
            return i;
        }
        return -1;
    }

    public static int[] cleanCopy(int[] array) {
        int length = array.length;
        int[] result = new int[length];
        int p = 0;
        for (int i = 0; i < length; ++i) {
            int val = array[i];
            if (i < length - 1) {
                boolean doublon = false;
                for (int j = i + 1; j < length; ++j) {
                    if (val != array[j]) continue;
                    doublon = true;
                    break;
                }
                if (doublon) continue;
            }
            result[p] = val;
            ++p;
        }
        if (p == length) {
            return result;
        }
        int[] nv = new int[p];
        System.arraycopy(result, 0, nv, 0, p);
        return nv;
    }

    public static boolean containsBetweenIndexes(int[] array, int value, int index1, int index2) {
        for (int i = index1; i < index2; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean compare(int[] array1, int[] array2) {
        int length = array1.length;
        if (length != array2.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] checkIntArray(int[] array, int p) {
        if (p == array.length) {
            return array;
        }
        int[] result = new int[p];
        System.arraycopy(array, 0, result, 0, p);
        return result;
    }

    public static int[] merge(int[] array1, int[] array2) {
        int ln1 = array1.length;
        int ln2 = array2.length;
        int[] result = new int[ln1 + ln2];
        System.arraycopy(array1, 0, result, 0, ln1);
        System.arraycopy(array2, 0, result, ln1, ln2);
        return result;
    }

    public static Object[] toObjectArray(Object val1, Object val2) {
        Object[] array = new Object[]{val1, val2};
        return array;
    }

    public static Object[] toObjectArray(Object val1, Object val2, Object val3) {
        Object[] array = new Object[]{val1, val2, val3};
        return array;
    }

    public static Object[] toObjectArray(Object val1, Object val2, Object val3, Object val4) {
        Object[] array = new Object[]{val1, val2, val3, val4};
        return array;
    }

    public static List<Object> wrap(Object[] array) {
        return new ObjectList(array);
    }

    private static class ObjectList
    extends AbstractList<Object>
    implements RandomAccess {
        private final Object[] array;

        private ObjectList(Object[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }
    }
}

