/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.json;

import java.io.IOException;
import net.mapeadores.util.json.JSONException;
import net.mapeadores.util.json.JSONObject;

public class JSONWriter {
    private static final int maxdepth = 20;
    private boolean comma = false;
    protected char mode = (char)105;
    private final JSONObject[] stack = new JSONObject[20];
    private int top = 0;
    protected Appendable appendable;

    public JSONWriter(Appendable a) {
        this.appendable = a;
    }

    private JSONWriter append(String s) throws IOException {
        if (s == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            if (this.comma && this.mode == 'a') {
                this.appendable.append(',');
            }
            this.appendable.append(s);
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONWriter array() throws IOException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push(null);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    private JSONWriter end(char m, char c) throws IOException {
        if (this.mode != m) {
            throw new JSONException(m == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        this.appendable.append(c);
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() throws IOException {
        return this.end('a', ']');
    }

    public JSONWriter endObject() throws IOException {
        return this.end('k', '}');
    }

    public JSONWriter key(String s) throws IOException {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            this.stack[this.top - 1].putOnce(s, Boolean.TRUE);
            if (this.comma) {
                this.appendable.append(',');
            }
            this.appendable.append(JSONObject.quote(s));
            this.appendable.append(':');
            this.comma = false;
            this.mode = (char)111;
            return this;
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONWriter object() throws IOException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push(new JSONObject());
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    private void pop(char c) {
        char m;
        if (this.top <= 0) {
            throw new JSONException("Nesting error.");
        }
        char c2 = m = this.stack[this.top - 1] == null ? (char)'a' : 'k';
        if (m != c) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : (this.stack[this.top - 1] == null ? 97 : 107));
    }

    private void push(JSONObject jo) {
        if (this.top >= 20) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = jo;
        this.mode = (char)(jo == null ? 97 : 107);
        ++this.top;
    }

    public JSONWriter value(boolean b) throws IOException {
        return this.append(b ? "true" : "false");
    }

    public JSONWriter value(double d) throws IOException {
        return this.value((Object)d);
    }

    public JSONWriter value(long l) throws IOException {
        return this.append(Long.toString(l));
    }

    public JSONWriter value(Object o) throws IOException {
        return this.append(JSONObject.valueToString(o));
    }
}

