/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.images;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ImagesUtils {
    private ImagesUtils() {
    }

    public static BufferedImage read(InputStream inputStream) throws IOException, ErrorMessageException {
        BufferedImage image = ImageIO.read(inputStream);
        if (image == null) {
            throw new ErrorMessageException("_ error.unsupported.imagetype");
        }
        return image;
    }

    public static BufferedImage read(File file) throws IOException, ErrorMessageException {
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            throw new ErrorMessageException("_ error.unsupported.imagetype");
        }
        return image;
    }

    public static void write(BufferedImage image, String format, OutputStream outputStream) throws IOException, ErrorMessageException {
        boolean done = ImageIO.write((RenderedImage)image, format, outputStream);
        if (!done) {
            throw new ErrorMessageException("_ error.unsupported.imagetype");
        }
    }

    public static void write(BufferedImage image, String format, File file) throws IOException, ErrorMessageException {
        boolean done = ImageIO.write((RenderedImage)image, format, file);
        if (!done) {
            throw new ErrorMessageException("_ error.unsupported.imagetype");
        }
    }

    public static void convert(InputStream input, String destinationFormatName, File destination) throws IOException, ErrorMessageException {
        BufferedImage bufferedImage = ImagesUtils.read(input);
        ImagesUtils.write(bufferedImage, destinationFormatName, destination);
    }

    public static void cropImage(InputStream inputStream, String format, OutputStream outputStream, int x, int y, int width, int height) throws IOException, ErrorMessageException {
        BufferedImage srcImg = ImagesUtils.read(inputStream);
        int type = srcImg.getTransparency() == 1 ? 1 : 2;
        BufferedImage destImg = new BufferedImage(width, height, type);
        Graphics g = destImg.getGraphics();
        g.drawImage(srcImg, 0, 0, width, height, x, y, x + width, y + height, null);
        g.dispose();
        ImagesUtils.write(destImg, format, outputStream);
    }

    public static boolean testImage(File file) {
        boolean bl;
        FileInputStream is = new FileInputStream(file);
        try {
            bl = ImagesUtils.testImage(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        is.close();
        return bl;
    }

    public static boolean testImage(InputStream inputStream) {
        try {
            BufferedImage srcImg = ImagesUtils.read(inputStream);
            return true;
        }
        catch (IOException | ErrorMessageException e) {
            return false;
        }
    }
}

