/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.conditions;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.List;
import net.mapeadores.util.conditions.CollatedStringTestUnit;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextTest;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.collation.CollationUnit;

public class TextTestEngine {
    private final RuleBasedCollator collator;
    private final boolean andMode;
    private final Tester tester;
    private final Lang lang;
    private final CollatedStringTestUnit[] excludingTestUnitArray;
    private final CollatedStringTestUnit[] includingTestUnitArray;

    private TextTestEngine(TextCondition condition, Lang lang) {
        List<TextTest> includingList;
        int includingLength;
        this.lang = lang;
        this.collator = (RuleBasedCollator)Collator.getInstance(lang.toLocale());
        this.collator.setStrength(0);
        List<TextTest> excludingList = condition.getExcludingTextTestList();
        int excludingLength = excludingList.size();
        if (excludingLength > 0) {
            this.excludingTestUnitArray = new CollatedStringTestUnit[excludingLength];
            for (int i = 0; i < excludingLength; ++i) {
                this.excludingTestUnitArray[i] = CollatedStringTestUnit.newInstance(excludingList.get(i), this.collator);
            }
        } else {
            this.excludingTestUnitArray = null;
        }
        if ((includingLength = (includingList = condition.getIncludingTextTestList()).size()) > 0) {
            this.includingTestUnitArray = new CollatedStringTestUnit[includingLength];
            for (int i = 0; i < includingLength; ++i) {
                this.includingTestUnitArray[i] = CollatedStringTestUnit.newInstance(includingList.get(i), this.collator);
            }
        } else {
            this.includingTestUnitArray = null;
        }
        this.andMode = condition.isAndOperator();
        this.tester = this.andMode ? new AndTester() : new OrTester();
    }

    public Lang getLang() {
        return this.lang;
    }

    public void start() {
        this.tester.clear();
    }

    public boolean canStop() {
        return this.tester.canStop();
    }

    public boolean addString(String s) {
        String collatedString = CollationUnit.collate(s, this.collator);
        this.tester.addString(collatedString);
        return this.tester.canStop();
    }

    public boolean getResult() {
        return this.tester.getResult();
    }

    public boolean isSelected(String s) {
        String collatedString = s == null || s.length() == 0 ? "" : CollationUnit.collate(s, this.collator);
        if (this.andMode) {
            return this.isAndAccepted(collatedString);
        }
        return this.isOrAccepted(collatedString);
    }

    private boolean isAndAccepted(String collatedString) {
        if (this.includingTestUnitArray != null) {
            for (CollatedStringTestUnit testUnit : this.includingTestUnitArray) {
                if (testUnit.accept(collatedString)) continue;
                return false;
            }
        }
        if (this.excludingTestUnitArray != null) {
            for (CollatedStringTestUnit testUnit : this.excludingTestUnitArray) {
                if (testUnit.accept(collatedString)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isOrAccepted(String collatedString) {
        if (this.includingTestUnitArray != null) {
            for (CollatedStringTestUnit testUnit : this.includingTestUnitArray) {
                if (!testUnit.accept(collatedString)) continue;
                return true;
            }
        }
        if (this.excludingTestUnitArray != null) {
            for (CollatedStringTestUnit testUnit : this.excludingTestUnitArray) {
                if (!testUnit.accept(collatedString)) continue;
                return true;
            }
        }
        return false;
    }

    public static TextTestEngine newInstance(TextCondition condition, Lang lang) {
        if (condition == null) {
            throw new IllegalArgumentException("condition is null");
        }
        if (lang == null) {
            throw new IllegalArgumentException("lang is null");
        }
        return new TextTestEngine(condition, lang);
    }

    private class AndTester
    extends Tester {
        private boolean failure;
        private final int length;
        private final boolean[] successIncludeArray;
        private int successCount;

        AndTester() {
            this.successCount = 0;
            this.length = TextTestEngine.this.includingTestUnitArray != null ? TextTestEngine.this.includingTestUnitArray.length : 0;
            this.successIncludeArray = new boolean[this.length];
        }

        @Override
        void addString(String collatedString) {
            if (this.failure) {
                return;
            }
            if (this.doInclude) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.successIncludeArray[i] || !TextTestEngine.this.includingTestUnitArray[i].accept(collatedString)) continue;
                    this.successIncludeArray[i] = true;
                    ++this.successCount;
                    if (this.successCount != this.length) continue;
                    this.doInclude = false;
                }
            }
            if (this.doExclude) {
                int excludeLength = TextTestEngine.this.excludingTestUnitArray.length;
                for (int i = 0; i < excludeLength; ++i) {
                    if (TextTestEngine.this.excludingTestUnitArray[i].accept(collatedString)) continue;
                    this.failure = true;
                    return;
                }
            }
        }

        @Override
        boolean canStop() {
            return this.failure;
        }

        @Override
        boolean getResult() {
            if (this.failure) {
                return false;
            }
            if (TextTestEngine.this.includingTestUnitArray == null) {
                return true;
            }
            return this.successCount == this.length;
        }

        @Override
        void clear() {
            this.init();
            this.failure = false;
            this.successCount = 0;
            for (int i = 0; i < this.length; ++i) {
                this.successIncludeArray[i] = false;
            }
        }
    }

    private abstract class Tester {
        protected boolean doExclude;
        protected boolean doInclude;

        Tester() {
            this.init();
        }

        void init() {
            this.doExclude = TextTestEngine.this.excludingTestUnitArray != null;
            this.doInclude = TextTestEngine.this.includingTestUnitArray != null;
        }

        abstract void addString(String var1);

        abstract boolean canStop();

        abstract boolean getResult();

        abstract void clear();
    }

    private class OrTester
    extends Tester {
        private boolean success = false;
        private final int length;
        private final boolean[] failExcludeArray;
        private int failCount = 0;

        OrTester() {
            this.length = TextTestEngine.this.excludingTestUnitArray != null ? TextTestEngine.this.excludingTestUnitArray.length : 0;
            this.failExcludeArray = new boolean[this.length];
        }

        @Override
        public void addString(String collatedString) {
            if (this.success) {
                return;
            }
            if (this.doInclude) {
                int includeLength = TextTestEngine.this.includingTestUnitArray.length;
                for (int i = 0; i < includeLength; ++i) {
                    if (!TextTestEngine.this.includingTestUnitArray[i].accept(collatedString)) continue;
                    this.success = true;
                    return;
                }
            }
            if (this.doExclude) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.failExcludeArray[i] || TextTestEngine.this.excludingTestUnitArray[i].accept(collatedString)) continue;
                    this.failExcludeArray[i] = true;
                    ++this.failCount;
                    if (this.failCount != this.length) continue;
                    this.doExclude = false;
                }
            }
        }

        @Override
        boolean canStop() {
            return this.success;
        }

        @Override
        boolean getResult() {
            if (this.success) {
                return true;
            }
            if (TextTestEngine.this.excludingTestUnitArray == null) {
                return false;
            }
            return this.failCount != this.length;
        }

        @Override
        void clear() {
            this.init();
            this.success = false;
            this.failCount = 0;
            for (int i = 0; i < this.length; ++i) {
                this.failExcludeArray[i] = false;
            }
        }
    }
}

