/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.span;

import java.text.ParseException;
import net.fichotheque.tools.parsers.AttsParser;

class RefTest {
    public static short EMPTY = 1;
    public static short ONLY_REF = (short)2;
    public static short BOTH = (short)3;
    public static short NO_REF = (short)4;
    private static final short WAITING_FOR = 1;
    private static final short UNDETERMINED = 2;
    private static final short ON_REF = 3;
    private static final short ON_QUOTE = 4;
    private static final short WAITING_FOR_SEPARATOR = 5;
    private short state = 1;
    private short resultType;
    private int currentIndex;
    private int closeIndex;
    private boolean escaped;
    private StringBuilder refBuf = new StringBuilder();

    private RefTest() {
    }

    short getResultType() {
        return this.resultType;
    }

    String getRef() {
        if (this.resultType == ONLY_REF || this.resultType == BOTH) {
            return this.refBuf.toString();
        }
        return "";
    }

    boolean hasAtts() {
        return this.resultType == NO_REF || this.resultType == BOTH;
    }

    int getCloseIndex() {
        return this.closeIndex;
    }

    static RefTest parse(String source, int startIndex) throws ParseException {
        RefTest refTest = new RefTest();
        int length = source.length();
        boolean continueParsing = true;
        int lastIndex = -1;
        for (int i = startIndex; i < length; ++i) {
            refTest.currentIndex = i;
            char carac = source.charAt(i);
            continueParsing = refTest.checkChar(carac);
            if (continueParsing) continue;
            lastIndex = i;
            break;
        }
        if (continueParsing) {
            throw new ParseException("Missing closing )", refTest.currentIndex);
        }
        refTest.closeIndex = refTest.resultType == NO_REF ? startIndex - 1 : lastIndex;
        return refTest;
    }

    private boolean checkChar(char carac) throws ParseException {
        boolean continueParsing = true;
        switch (this.state) {
            case 1: {
                continueParsing = this.checkWaitingFor(carac);
                break;
            }
            case 3: {
                continueParsing = this.checkOnRef(carac);
                break;
            }
            case 2: {
                continueParsing = this.checkUndetermined(carac);
                break;
            }
            case 4: {
                continueParsing = this.checkOnQuote(carac);
                break;
            }
            case 5: {
                continueParsing = this.waitingForSeparator(carac);
            }
        }
        return continueParsing;
    }

    private boolean checkWaitingFor(char carac) throws ParseException {
        if (carac == ')') {
            this.resultType = EMPTY;
            return false;
        }
        if (carac == ' ') {
            return true;
        }
        if (carac == '\"') {
            this.state = (short)4;
            return true;
        }
        this.state = AttsParser.isValideFisrtNameChar(carac) ? (short)2 : (short)3;
        this.refBuf.append(carac);
        return true;
    }

    private boolean checkOnRef(char carac) throws ParseException {
        if (carac == ')') {
            this.resultType = ONLY_REF;
            return false;
        }
        if (carac == ' ') {
            this.resultType = BOTH;
            return false;
        }
        if (carac == '\"') {
            throw new ParseException("\" character inside ref", this.currentIndex);
        }
        this.refBuf.append(carac);
        return true;
    }

    private boolean checkUndetermined(char carac) throws ParseException {
        if (carac == ')') {
            this.resultType = ONLY_REF;
            return false;
        }
        if (carac == ' ') {
            this.resultType = BOTH;
            return false;
        }
        if (carac == '=') {
            this.resultType = NO_REF;
            return false;
        }
        if (carac == '\"') {
            throw new ParseException("\" character inside ref", this.currentIndex);
        }
        if (!AttsParser.isValidNameChar(carac)) {
            this.state = (short)3;
        }
        this.refBuf.append(carac);
        return true;
    }

    private boolean checkOnQuote(char carac) {
        if (carac == '\"') {
            if (this.escaped) {
                this.escaped = false;
                this.refBuf.append('\"');
            } else {
                this.state = (short)5;
            }
            return true;
        }
        if (carac == '\\') {
            if (this.escaped) {
                this.escaped = false;
                this.refBuf.append('\\');
            } else {
                this.escaped = true;
            }
            return true;
        }
        if (this.escaped) {
            this.escaped = false;
            this.refBuf.append('\\');
        }
        this.refBuf.append(carac);
        return true;
    }

    private boolean waitingForSeparator(char carac) throws ParseException {
        if (carac == ')') {
            this.resultType = ONLY_REF;
            return false;
        }
        if (carac == ' ') {
            this.resultType = BOTH;
            return false;
        }
        throw new ParseException("character " + carac + " following quote end", this.currentIndex);
    }
}

