/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.thesaurus;

import net.fichotheque.FichothequeConstants;
import net.fichotheque.importation.ParentChange;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.handlers.HandlerUtils;
import net.fichotheque.tools.importation.parsers.handlers.IdalphaHandler;
import net.fichotheque.tools.importation.parsers.thesaurus.ThesaurusColumns;
import net.fichotheque.tools.importation.parsers.thesaurus.ThesaurusRowParser;
import net.fichotheque.tools.importation.thesaurus.EditMotcleImportBuilder;
import net.fichotheque.tools.importation.thesaurus.EditThesaurusImportBuilder;
import net.fichotheque.utils.ParentChangeUtils;
import net.mapeadores.util.logging.ErrorMessageException;

class ChangeRowParser
extends ThesaurusRowParser {
    private final EditThesaurusImportBuilder editThesaurusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;
    private final ThesaurusColumns thesaurusColumns;
    private final ImportationParseContext parseContext;

    ChangeRowParser(EditThesaurusImportBuilder editThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, ThesaurusColumns thesaurusColumns, ImportationParseContext parseContext) {
        this.editThesaurusImportBuilder = editThesaurusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.thesaurusColumns = thesaurusColumns;
        this.parseContext = parseContext;
    }

    @Override
    public EditThesaurusImportBuilder getThesaurusImportBuilder() {
        return this.editThesaurusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        String statusString;
        ParentChange parentChange;
        String newIdalpha;
        EditMotcleImportBuilder motcleImportBuilder;
        Thesaurus thesaurus;
        block39: {
            thesaurus = this.editThesaurusImportBuilder.getThesaurus();
            int columnCount = row.getColumnCount();
            int idIndex = this.thesaurusColumns.getIdIndex();
            IdalphaHandler idalphaHandler = this.thesaurusColumns.getIdalphaHandler();
            Motcle motcle = null;
            if (idIndex != -1) {
                if (columnCount <= idIndex) {
                    this.parseResultBuilder.missingIdColumn(rowNumber);
                    return;
                }
                String idString = row.getColumnValue(idIndex).trim();
                try {
                    int id = Integer.parseInt(idString);
                    motcle = thesaurus.getMotcleById(id);
                    if (motcle == null) {
                        this.parseResultBuilder.unknownId(rowNumber, idString);
                    }
                }
                catch (NumberFormatException nfe) {
                    this.parseResultBuilder.notIntegerId(rowNumber, idString);
                }
            } else {
                try {
                    String idalpha = idalphaHandler.getIdalpha(row, true);
                    motcle = thesaurus.getMotcleByIdalpha(idalpha);
                    if (motcle == null) {
                        this.parseResultBuilder.unknownIdalpha(rowNumber, idalpha);
                    }
                }
                catch (ErrorMessageException eme) {
                    this.parseResultBuilder.addParseErrorMessage(rowNumber, eme.getErrorMessage());
                }
            }
            if (motcle == null) {
                return;
            }
            motcleImportBuilder = this.editThesaurusImportBuilder.getEditMotcleImportBuilder(motcle);
            newIdalpha = null;
            if (idIndex != -1 && idalphaHandler != null) {
                try {
                    newIdalpha = idalphaHandler.getIdalpha(row, false);
                    if (newIdalpha != null && thesaurus.getMotcleByIdalpha(newIdalpha) != null) {
                        newIdalpha = null;
                        this.parseResultBuilder.existingIdalpha(rowNumber, newIdalpha);
                    }
                }
                catch (ErrorMessageException eme) {
                    this.parseResultBuilder.addParseErrorMessage(rowNumber, eme.getErrorMessage());
                }
            }
            parentChange = null;
            int parentIdIndex = this.thesaurusColumns.getParentIdIndex();
            IdalphaHandler parentIdalphaHandler = this.thesaurusColumns.getParentIdalphaHandler();
            if (parentIdIndex != -1) {
                if (parentIdIndex < columnCount) {
                    String parentIdString = row.getColumnValue(parentIdIndex).trim();
                    if (parentIdString.length() == 0) {
                        parentChange = ParentChangeUtils.THESAURUS;
                    } else {
                        try {
                            int parentId = Integer.parseInt(parentIdString);
                            if (parentId < 1) {
                                parentChange = ParentChangeUtils.THESAURUS;
                                break block39;
                            }
                            Motcle parentMotcle = thesaurus.getMotcleById(parentId);
                            if (parentMotcle == null) {
                                this.parseResultBuilder.unknownId(rowNumber, parentIdString);
                                break block39;
                            }
                            parentChange = ParentChangeUtils.toIdParentChange(parentMotcle.getId());
                        }
                        catch (NumberFormatException nfe) {
                            this.parseResultBuilder.notIntegerId(rowNumber, parentIdString);
                        }
                    }
                } else {
                    parentChange = ParentChangeUtils.THESAURUS;
                }
            } else if (parentIdalphaHandler != null) {
                try {
                    String parentIdalpha = parentIdalphaHandler.getIdalpha(row, false);
                    if (parentIdalpha == null) {
                        parentChange = ParentChangeUtils.THESAURUS;
                    } else {
                        Motcle parentMotcle = thesaurus.getMotcleByIdalpha(parentIdalpha);
                        if (parentMotcle == null) {
                            this.parseResultBuilder.existingIdalpha(rowNumber, newIdalpha);
                        } else {
                            parentChange = ParentChangeUtils.toIdParentChange(parentMotcle.getId());
                        }
                    }
                }
                catch (ErrorMessageException eme) {
                    String key = eme.getErrorMessage().getMessageKey();
                    if (key.equals("_ error.wrong.idalpha")) {
                        this.parseResultBuilder.addParseErrorMessage(rowNumber, eme.getErrorMessage());
                    }
                    parentChange = ParentChangeUtils.THESAURUS;
                }
            }
        }
        int statusIndex = this.thesaurusColumns.getStatusIndex();
        if (statusIndex != -1 && !(statusString = row.getColumnValue(statusIndex).trim()).isEmpty()) {
            try {
                motcleImportBuilder.setNewStatus(FichothequeConstants.checkMotcleStatus(statusString));
            }
            catch (IllegalArgumentException iae) {
                this.parseResultBuilder.unknownStatus(rowNumber, statusString);
            }
        }
        motcleImportBuilder.setNewIdalpha(newIdalpha).setParent(parentChange);
        if (this.thesaurusColumns.hasLabelHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getLabelChangeBuilder(), this.thesaurusColumns.getLabelHandlerArray(), row, this.parseResultBuilder, rowNumber);
        }
        if (this.thesaurusColumns.hasAttributeHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getAttributeChangeBuilder(), this.thesaurusColumns.getAttributeHandlerArray(), row);
        }
        if (this.thesaurusColumns.hasJunctionHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getTiesImportBuilder(), this.thesaurusColumns.getJunctionHandlers(), row, thesaurus, this.parseContext);
        }
    }

    static ChangeRowParser newInstance(String[] fieldArray, EditThesaurusImportBuilder editThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, ImportationParseContext parseContext) {
        ThesaurusColumns thesaurusColumns = ThesaurusColumns.parse(fieldArray, editThesaurusImportBuilder, parseResultBuilder);
        if (thesaurusColumns.getIdIndex() == -1 && thesaurusColumns.getIdalphaHandler() == null) {
            parseResultBuilder.missingColumn(ThesaurusFieldKey.ID.toString());
            return null;
        }
        return new ChangeRowParser(editThesaurusImportBuilder, parseResultBuilder, thesaurusColumns, parseContext);
    }
}

