/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.extraction.FilterParameters;
import net.fichotheque.extraction.def.AddendaExtractDef;
import net.fichotheque.extraction.def.AlbumExtractDef;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.ThesaurusExtractDef;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.selection.DocumentCondition;
import net.fichotheque.selection.DocumentQuery;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.IllustrationCondition;
import net.fichotheque.selection.IllustrationQuery;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.tools.extraction.builders.AddendaExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.AlbumExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.CorpusExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.DocumentFilterBuilder;
import net.fichotheque.tools.extraction.builders.ExtractionBuilderUtils;
import net.fichotheque.tools.extraction.builders.ExtractionDefBuilder;
import net.fichotheque.tools.extraction.builders.FicheFilterBuilder;
import net.fichotheque.tools.extraction.builders.FilterParametersBuilder;
import net.fichotheque.tools.extraction.builders.GroupClauseBuilder;
import net.fichotheque.tools.extraction.builders.IllustrationFilterBuilder;
import net.fichotheque.tools.extraction.builders.MotcleFilterBuilder;
import net.fichotheque.tools.extraction.builders.ThesaurusExtractDefBuilder;
import net.fichotheque.tools.extraction.dom.ExtractionDOMUtils;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.FilterUnitCatalog;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.instruction.InstructionUtils;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DocumentFragmentHolder;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ExtractionDOMReader {
    private final Fichotheque fichotheque;

    public ExtractionDOMReader(Fichotheque fichotheque) {
        this.fichotheque = fichotheque;
    }

    public ExtractionDef readExtraction(Element element, DocumentFragmentHolder includeCatalog) {
        NodeList includeList = element.getElementsByTagName("include");
        int includeCount = includeList.getLength();
        if (includeCount > 0) {
            int i;
            Element[] includeArray = new Element[includeCount];
            for (i = 0; i < includeCount; ++i) {
                includeArray[i] = (Element)includeList.item(i);
            }
            for (i = 0; i < includeCount; ++i) {
                DocumentFragment documentFragment;
                String fragmentKey;
                Element includeElement = includeArray[i];
                if (includeElement.getElementsByTagName("include").getLength() > 0 || (fragmentKey = includeElement.getAttribute("fragment-key")).length() <= 0 || (documentFragment = includeCatalog.getFragment(fragmentKey)) == null) continue;
                DocumentFragment importDocumentFragment = (DocumentFragment)includeElement.getOwnerDocument().importNode(documentFragment, true);
                Node parentNode = includeElement.getParentNode();
                parentNode.replaceChild(importDocumentFragment, includeElement);
            }
        }
        ExtractionDefBuilder extractionDefBuilder = ExtractionDefBuilder.init().setTagNameInfo(ExtractionDOMUtils.getTagNameInfo(element));
        DOMUtils.readChildren(element, new RootConsumer(extractionDefBuilder));
        return extractionDefBuilder.toExtractionDef();
    }

    private AddendaExtractDef readAddendaExtractDef(Element element) {
        DocumentQuery attributeQuery;
        String addendaAttribute;
        String name = ExtractionDOMUtils.getExtractName(element);
        TagNameInfo tagNameInfo = ExtractionDOMUtils.getTagNameInfo(element);
        DocumentFilterBuilder documentFilterBuilder = new DocumentFilterBuilder();
        ArrayList<DocumentCondition.Entry> entryList = new ArrayList<DocumentCondition.Entry>();
        DOMUtils.readChildren(element, new AddendaExtractConsumer(entryList, documentFilterBuilder));
        if (entryList.isEmpty() && (addendaAttribute = element.getAttribute("addenda")).length() > 0 && (attributeQuery = ExtractionDOMUtils.getDocumentQuery(addendaAttribute)) != null) {
            entryList.add(SelectionUtils.toDocumentConditionEntry(attributeQuery));
        }
        return AddendaExtractDefBuilder.init(documentFilterBuilder.toDocumentFilter()).setName(name).setTagNameInfo(tagNameInfo).setEntryList(entryList).toAddendaExtractDef();
    }

    private AlbumExtractDef readAlbumExtractDef(Element element) {
        IllustrationQuery attributeQuery;
        String albumAttribute;
        String name = ExtractionDOMUtils.getExtractName(element);
        TagNameInfo tagNameInfo = ExtractionDOMUtils.getTagNameInfo(element);
        IllustrationFilterBuilder illustrationFilterBuilder = new IllustrationFilterBuilder();
        ArrayList<IllustrationCondition.Entry> entryList = new ArrayList<IllustrationCondition.Entry>();
        DOMUtils.readChildren(element, new AlbumExtractConsumer(entryList, illustrationFilterBuilder));
        if (entryList.isEmpty() && (albumAttribute = element.getAttribute("album")).length() > 0 && (attributeQuery = ExtractionDOMUtils.getIllustrationQuery(albumAttribute)) != null) {
            entryList.add(SelectionUtils.toIllustrationConditionEntry(attributeQuery));
        }
        return AlbumExtractDefBuilder.init(illustrationFilterBuilder.toIllustrationFilter()).setName(name).setTagNameInfo(tagNameInfo).setEntryList(entryList).toAlbumExtractDef();
    }

    private CorpusExtractDef readCorpusExtractDef(Element element) {
        String sortAttribute;
        FicheQuery attributeQuery;
        String corpusAttribute;
        String axisAttribute;
        CorpusExtractDefBuilder builder = CorpusExtractDefBuilder.init().setName(ExtractionDOMUtils.getExtractName(element)).setTagNameInfo(ExtractionDOMUtils.getTagNameInfo(element));
        String sourceAttribute = element.getAttribute("source");
        if (sourceAttribute.equals("master")) {
            builder.setBoolean("master", true);
        }
        if ((axisAttribute = element.getAttribute("axis")).equals("descendant")) {
            builder.setBoolean("descendantaxis", true);
        }
        ArrayList<FicheCondition.Entry> entryList = new ArrayList<FicheCondition.Entry>();
        CorpusExtractConsumer consumer = new CorpusExtractConsumer(builder, entryList);
        DOMUtils.readChildren(element, consumer);
        if (entryList.isEmpty() && (corpusAttribute = element.getAttribute("corpus")).length() > 0 && (attributeQuery = ExtractionDOMUtils.getFicheQuery(corpusAttribute)) != null) {
            entryList.add(SelectionUtils.toFicheConditionEntry(attributeQuery));
        }
        builder.setEntryList(entryList);
        if (!consumer.isGroupClauseDone() && (sortAttribute = element.getAttribute("sort")).length() > 0) {
            builder.setClause("group", GroupClauseBuilder.getGroupClause(sortAttribute, true));
        }
        if (!consumer.isFicheFilterDone()) {
            builder.setFicheFilter(ExtractionXMLUtils.TITLE_FICHEFILTER);
        }
        return builder.toCorpusExtractDef();
    }

    private ThesaurusExtractDef readThesaurusExtractDef(Element element) {
        MotcleQuery attributeQuery;
        String thesaurusAttribute;
        ThesaurusExtractDefBuilder builder = ThesaurusExtractDefBuilder.init().setName(ExtractionDOMUtils.getExtractName(element)).setTagNameInfo(ExtractionDOMUtils.getTagNameInfo(element));
        String sourceAttribute = element.getAttribute("source");
        if (sourceAttribute.equals("master")) {
            builder.setBoolean("master", true);
        }
        ArrayList<MotcleCondition.Entry> entryList = new ArrayList<MotcleCondition.Entry>();
        ThesaurusExtractConsumer thesaurusExtractConsumer = new ThesaurusExtractConsumer(builder, entryList);
        DOMUtils.readChildren(element, thesaurusExtractConsumer);
        if (entryList.isEmpty() && (thesaurusAttribute = element.getAttribute("thesaurus")).length() > 0 && (attributeQuery = ExtractionDOMUtils.getMotcleQuery(thesaurusAttribute)) != null) {
            entryList.add(SelectionUtils.toMotcleConditionEntry(attributeQuery));
        }
        if (!thesaurusExtractConsumer.isMotcleFilterDone()) {
            builder.setMotcleFilter(ExtractionXMLUtils.NONE_MOTCLEFILTER);
        }
        builder.setEntryList(entryList);
        return builder.toThesaurusExtractDef();
    }

    private FicheFilter readFicheFilter(Element element) {
        FicheFilterBuilder builder = FicheFilterBuilder.init().setTagNameInfo(ExtractionDOMUtils.getTagNameInfo(element));
        ArrayList list = new ArrayList();
        this.readFicheFilter(element, new FilterUnitConsumer(list));
        for (FilterUnit filterUnit : list) {
            builder.add(filterUnit);
        }
        return builder.toFicheFilter();
    }

    private Set<SubsetKey> readCorpusKeySet(Element element) {
        Set<SubsetKey> corpusKeySet = FichothequeUtils.EMPTY_SUBSETKEYSET;
        String corpusAttribute = element.getAttribute("corpus");
        if (corpusAttribute.length() > 0) {
            corpusKeySet = FichothequeUtils.toSubsetKeySet((short)1, corpusAttribute);
        }
        return corpusKeySet;
    }

    private void readMotcleFilter(MotcleFilterBuilder motcleFilterBuilder, Element element) {
        TagNameInfo tagNameInfo = ExtractionDOMUtils.getTagNameInfo(element);
        motcleFilterBuilder.setTagNameInfo(tagNameInfo);
        if (StringUtils.isTrue(element.getAttribute("recursive"))) {
            motcleFilterBuilder.setRecursive();
        }
        DOMUtils.readChildren(element, new MotcleFilterConsumer(motcleFilterBuilder));
    }

    private void readFicheFilter(Element parentElement, FilterUnitConsumer filterUnitConsumer) {
        NodeList nodeList = parentElement.getChildNodes();
        int length = nodeList.getLength();
        block4: for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    filterUnitConsumer.accept((Element)node);
                    continue block4;
                }
                case 3: 
                case 4: {
                    String text = ((Text)node).getData();
                    if (text == null) continue block4;
                    filterUnitConsumer.parse(text);
                }
            }
        }
    }

    private static FilterParameters readFilterParameters(Element element) {
        FilterParametersBuilder filterParametersBuilder = new FilterParametersBuilder();
        String paramsString = element.getAttribute("params");
        if (paramsString.length() > 0) {
            paramsString = paramsString.replace("libtype", "labeltype");
            ExtractionDOMReader.parseInstruction(filterParametersBuilder, paramsString, null);
        }
        DOMUtils.readChildren(element, new FilterParametersConsumer(filterParametersBuilder));
        return filterParametersBuilder.toFilterParameters();
    }

    private static void parseInstruction(FilterParametersBuilder attributeBuffer, String s, InstructionErrorHandler errorHandler) {
        Instruction instruction;
        if (errorHandler == null) {
            errorHandler = InstructionUtils.DEFAULT_ERROR_HANDLER;
        }
        if ((instruction = InstructionParser.parse(s, errorHandler)) == null) {
            return;
        }
        for (Argument argument : instruction) {
            attributeBuffer.appendValue(argument.getKey(), argument.getNotNullValue());
        }
    }

    private class FilterUnitConsumer
    implements Consumer<Element> {
        private final List<FilterUnit> list;

        private FilterUnitConsumer(List<FilterUnit> list) {
            this.list = list;
        }

        private void parse(String text) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens(text, true)) {
                this.parseToken(token);
            }
        }

        private void parseToken(String token) {
            String dataName;
            String phraseName;
            if (token.equals("chrono")) {
                this.list.add(FilterUnitCatalog.CHRONO);
                return;
            }
            if (token.startsWith("phrase_") && !(phraseName = token.substring("phrase_".length())).isEmpty()) {
                this.list.add(FilterUnitCatalog.phrase(phraseName));
            }
            if (token.startsWith("data_") && !(dataName = token.substring("data_".length())).isEmpty()) {
                this.list.add(FilterUnitCatalog.data(dataName, ExtractionUtils.EMPTY_FILTERPARAMETERS));
            }
            try {
                FieldKey fieldKey = FieldKey.parse(token);
                this.list.add(FilterUnitCatalog.fieldKey(fieldKey, ExtractionUtils.EMPTY_FILTERPARAMETERS));
            }
            catch (ParseException pe) {
                try {
                    ExtendedIncludeKey extendedIncludeKey = ExtendedIncludeKey.parse(token);
                    this.list.add(ExtractionBuilderUtils.getDefaultFilterUnit(extendedIncludeKey, ExtractionDOMReader.this.fichotheque));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void accept(Element element) {
            String tagname;
            FilterParameters filterParameters = ExtractionDOMReader.readFilterParameters(element);
            switch (tagname = element.getTagName()) {
                case "head": 
                case "entete": {
                    this.list.add(FilterUnitCatalog.HEAD);
                    break;
                }
                case "body": 
                case "corpsdefiche": {
                    this.list.add(FilterUnitCatalog.BODY);
                    break;
                }
                case "title": 
                case "titre": {
                    this.list.add(FilterUnitCatalog.fieldKey(FieldKey.TITLE, filterParameters));
                    break;
                }
                case "subtitle": 
                case "soustitre": {
                    this.list.add(FilterUnitCatalog.fieldKey(FieldKey.SUBTITLE, filterParameters));
                    break;
                }
                case "owners": 
                case "redacteurs": {
                    this.list.add(FilterUnitCatalog.fieldKey(FieldKey.OWNERS, filterParameters));
                    break;
                }
                case "lang": {
                    this.list.add(FilterUnitCatalog.fieldKey(FieldKey.LANG, filterParameters));
                    break;
                }
                case "prop": 
                case "propriete": {
                    String fieldName = this.getFieldName(element);
                    if (fieldName.length() <= 0) break;
                    this.addFieldNameFilter((short)1, fieldName, filterParameters);
                    break;
                }
                case "info": 
                case "information": {
                    String fieldName = this.getFieldName(element);
                    if (fieldName.length() <= 0) break;
                    this.addFieldNameFilter((short)2, fieldName, filterParameters);
                    break;
                }
                case "section": {
                    String fieldName = this.getFieldName(element);
                    if (fieldName.length() <= 0) break;
                    this.addFieldNameFilter((short)3, fieldName, filterParameters);
                    break;
                }
                case "lot": {
                    TagNameInfo tagNameInfo = ExtractionDOMUtils.getTagNameInfo(element);
                    ArrayList<FilterUnit> lotList = new ArrayList<FilterUnit>();
                    ExtractionDOMReader.this.readFicheFilter(element, new FilterUnitConsumer(lotList));
                    if (lotList.isEmpty()) break;
                    this.list.add(FilterUnitCatalog.lot(tagNameInfo, lotList));
                    break;
                }
                case "chrono": {
                    this.list.add(FilterUnitCatalog.chrono(filterParameters));
                    break;
                }
                case "intitule": {
                    this.list.add(FilterUnitCatalog.FICHEPHRASE);
                    break;
                }
                case "phrase": {
                    String phraseName = element.getAttribute("name");
                    if (phraseName.isEmpty()) break;
                    this.list.add(FilterUnitCatalog.phrase(phraseName));
                    break;
                }
                case "extraitaddenda": 
                case "documents": {
                    AddendaExtractDef addendaExtractDef = ExtractionDOMReader.this.readAddendaExtractDef(element);
                    this.list.add(FilterUnitCatalog.addendaExtract(addendaExtractDef, filterParameters));
                    break;
                }
                case "extraitcorpus": 
                case "fiches": {
                    CorpusExtractDef corpusExtractDef = ExtractionDOMReader.this.readCorpusExtractDef(element);
                    this.list.add(FilterUnitCatalog.corpusExtract(corpusExtractDef, filterParameters));
                    break;
                }
                case "extraitthesaurus": 
                case "motcles": {
                    ThesaurusExtractDef thesaurusExtractDef = ExtractionDOMReader.this.readThesaurusExtractDef(element);
                    this.list.add(FilterUnitCatalog.thesaurusExtract(thesaurusExtractDef, filterParameters));
                    break;
                }
                case "extraitalbum": 
                case "illustrations": {
                    AlbumExtractDef albumExtractDef = ExtractionDOMReader.this.readAlbumExtractDef(element);
                    this.list.add(FilterUnitCatalog.albumExtract(albumExtractDef, filterParameters));
                    break;
                }
                case "fiche": {
                    this.list.add(FilterUnitCatalog.ficheParentage(ExtractionDOMReader.this.readFicheFilter(element), filterParameters, ExtractionDOMReader.this.readCorpusKeySet(element)));
                    break;
                }
                case "motcle": {
                    MotcleFilterBuilder filterBuilder = new MotcleFilterBuilder(1);
                    ExtractionDOMReader.this.readMotcleFilter(filterBuilder, element);
                    this.list.add(FilterUnitCatalog.masterMotcle(filterBuilder.toMotcleFilter(), filterParameters));
                    break;
                }
                case "data": {
                    String dataName = element.getAttribute("name");
                    if (dataName.isEmpty()) break;
                    this.list.add(FilterUnitCatalog.data(dataName, filterParameters));
                    break;
                }
            }
        }

        private String getFieldName(Element element) {
            String fieldName = element.getAttribute("name");
            if (fieldName.isEmpty()) {
                fieldName = element.getAttribute("type");
            }
            return fieldName;
        }

        private void addFieldNameFilter(short category, String fieldName, FilterParameters filterParameters) {
            if (fieldName.endsWith("*")) {
                int length = fieldName.length();
                if (length == 1) {
                    return;
                }
                String prefix = fieldName.substring(0, length - 1);
                this.list.add(FilterUnitCatalog.fieldNamePrefix(category, prefix, filterParameters));
            } else {
                try {
                    FieldKey fieldKey = FieldKey.parse(category, fieldName);
                    this.list.add(FilterUnitCatalog.fieldKey(fieldKey, filterParameters));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final ExtractionDefBuilder extractionDefBuilder;
        private boolean dynamicFicheDone = false;
        private boolean dynamicMotcleDone = false;

        private RootConsumer(ExtractionDefBuilder extractionDefBuilder) {
            this.extractionDefBuilder = extractionDefBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagname;
            switch (tagname = element.getTagName()) {
                case "static": {
                    this.extractionDefBuilder.setStaticTagNameInfo(ExtractionDOMUtils.getTagNameInfo(element));
                    DOMUtils.readChildren(element, new StaticConsumer(this.extractionDefBuilder));
                    break;
                }
                case "extraitcorpus": 
                case "fiches": {
                    if (this.dynamicFicheDone) break;
                    this.extractionDefBuilder.setDynamicCorpusExtractDef(ExtractionDOMReader.this.readCorpusExtractDef(element));
                    this.dynamicFicheDone = true;
                    break;
                }
                case "extraitthesaurus": 
                case "motcles": {
                    if (this.dynamicMotcleDone) break;
                    this.extractionDefBuilder.setDynamicThesaurusExtractDef(ExtractionDOMReader.this.readThesaurusExtractDef(element));
                    this.dynamicMotcleDone = true;
                    break;
                }
                case "fiche": {
                    if (this.dynamicFicheDone) break;
                    FicheFilter ficheFilter = ExtractionDOMReader.this.readFicheFilter(element);
                    this.extractionDefBuilder.setDynamicCorpusExtractDef(CorpusExtractDefBuilder.init(ficheFilter).setTagNameInfo(TagNameInfo.NULL).toCorpusExtractDef());
                    this.dynamicFicheDone = true;
                }
            }
        }
    }

    private class AddendaExtractConsumer
    implements Consumer<Element> {
        private final DocumentFilterBuilder documentFilterBuilder;
        private final List<DocumentCondition.Entry> entryList;

        private AddendaExtractConsumer(List<DocumentCondition.Entry> entryList, DocumentFilterBuilder documentFilterBuilder) {
            this.entryList = entryList;
            this.documentFilterBuilder = documentFilterBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagname;
            switch (tagname = element.getTagName()) {
                case "document-query": 
                case "document-select": {
                    this.entryList.add(SelectionDOMUtils.getDocumentConditionEntry(element));
                    break;
                }
                case "document": {
                    TagNameInfo tagNameInfo = ExtractionDOMUtils.getTagNameInfo(element);
                    this.documentFilterBuilder.setTagNameInfo(tagNameInfo);
                }
            }
        }
    }

    private class AlbumExtractConsumer
    implements Consumer<Element> {
        private final List<IllustrationCondition.Entry> entryList;
        private final IllustrationFilterBuilder illustrationFilterBuilder;

        private AlbumExtractConsumer(List<IllustrationCondition.Entry> entryList, IllustrationFilterBuilder illustrationFilterBuilder) {
            this.entryList = entryList;
            this.illustrationFilterBuilder = illustrationFilterBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagname;
            switch (tagname = element.getTagName()) {
                case "illustration-query": 
                case "illustration-select": {
                    this.entryList.add(SelectionDOMUtils.getIllustrationConditionEntry(element));
                    break;
                }
                case "illustration": {
                    TagNameInfo tagNameInfo = ExtractionDOMUtils.getTagNameInfo(element);
                    this.illustrationFilterBuilder.setTagNameInfo(tagNameInfo);
                }
            }
        }
    }

    private class CorpusExtractConsumer
    implements Consumer<Element> {
        private final CorpusExtractDefBuilder builder;
        private final List<FicheCondition.Entry> entryList;
        private boolean groupClauseDone;
        private boolean ficheFilterDone;

        private CorpusExtractConsumer(CorpusExtractDefBuilder builder, List<FicheCondition.Entry> entryList) {
            this.builder = builder;
            this.entryList = entryList;
        }

        @Override
        public void accept(Element element) {
            String tagname;
            switch (tagname = element.getTagName()) {
                case "fiche-query": 
                case "fiche-select": {
                    this.entryList.add(SelectionDOMUtils.getFicheConditionEntry(ExtractionDOMReader.this.fichotheque, element));
                    break;
                }
                case "group": {
                    this.builder.setClause("group", ExtractionDOMUtils.readGroupClause(element));
                    this.groupClauseDone = true;
                    break;
                }
                case "title": 
                case "intitule": {
                    this.builder.setClause("title", ExtractionDOMUtils.readTitleClause(element));
                    break;
                }
                case "pack": {
                    this.builder.setClause("pack", ExtractionDOMUtils.readPackClause(element));
                    break;
                }
                case "fiche": {
                    if (this.ficheFilterDone) break;
                    this.ficheFilterDone = true;
                    this.builder.setFicheFilter(ExtractionDOMReader.this.readFicheFilter(element));
                }
            }
        }

        public boolean isGroupClauseDone() {
            return this.groupClauseDone;
        }

        public boolean isFicheFilterDone() {
            return this.ficheFilterDone;
        }
    }

    private class ThesaurusExtractConsumer
    implements Consumer<Element> {
        private final ThesaurusExtractDefBuilder builder;
        private final List<MotcleCondition.Entry> entryList;
        private boolean motcleFilterDone;

        private ThesaurusExtractConsumer(ThesaurusExtractDefBuilder builder, List<MotcleCondition.Entry> entryList) {
            this.builder = builder;
            this.entryList = entryList;
        }

        @Override
        public void accept(Element element) {
            String tagname;
            switch (tagname = element.getTagName()) {
                case "motcle-query": 
                case "motcle-select": {
                    this.entryList.add(SelectionDOMUtils.getMotcleConditionEntry(ExtractionDOMReader.this.fichotheque, element));
                    break;
                }
                case "motcle": {
                    if (this.motcleFilterDone) break;
                    MotcleFilterBuilder motcleFilterBuilder = new MotcleFilterBuilder(1);
                    ExtractionDOMReader.this.readMotcleFilter(motcleFilterBuilder, element);
                    this.builder.setMotcleFilter(motcleFilterBuilder.toMotcleFilter());
                    this.motcleFilterDone = true;
                    break;
                }
                case "title": 
                case "intitule": {
                    this.builder.setBoolean("withthesaurustitle", true);
                }
            }
        }

        public boolean isMotcleFilterDone() {
            return this.motcleFilterDone;
        }
    }

    private class MotcleFilterConsumer
    implements Consumer<Element> {
        private final MotcleFilterBuilder motcleFilterBuilder;

        private MotcleFilterConsumer(MotcleFilterBuilder motcleFilterBuilder) {
            this.motcleFilterBuilder = motcleFilterBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagname;
            switch (tagname = element.getTagName()) {
                case "icon": {
                    this.motcleFilterBuilder.setWithIcon(true);
                    break;
                }
                case "labels": 
                case "lib": {
                    this.motcleFilterBuilder.setWithLabels(true);
                    break;
                }
                case "level": {
                    this.motcleFilterBuilder.setWithLevel(true);
                    break;
                }
                case "intitule": {
                    this.motcleFilterBuilder.setWithFicheStylePhrase(true);
                    break;
                }
                case "phrase": {
                    if (!element.getAttribute("name").equals("fichestyle")) break;
                    this.motcleFilterBuilder.setWithFicheStylePhrase(true);
                    break;
                }
                case "next": {
                    MotcleFilterBuilder nextFilterBuilder = new MotcleFilterBuilder(4);
                    ExtractionDOMReader.this.readMotcleFilter(nextFilterBuilder, element);
                    this.motcleFilterBuilder.setNextFilter(nextFilterBuilder.toMotcleFilter());
                    break;
                }
                case "previous": {
                    MotcleFilterBuilder previousFilterBuilder = new MotcleFilterBuilder(3);
                    ExtractionDOMReader.this.readMotcleFilter(previousFilterBuilder, element);
                    this.motcleFilterBuilder.setPreviousFilter(previousFilterBuilder.toMotcleFilter());
                    break;
                }
                case "motcle": {
                    MotcleFilterBuilder childrenFilterBuilder = new MotcleFilterBuilder(1);
                    ExtractionDOMReader.this.readMotcleFilter(childrenFilterBuilder, element);
                    this.motcleFilterBuilder.setChildrenFilter(childrenFilterBuilder.toMotcleFilter());
                    break;
                }
                case "parent": {
                    MotcleFilterBuilder parentFilterBuilder = new MotcleFilterBuilder(2);
                    ExtractionDOMReader.this.readMotcleFilter(parentFilterBuilder, element);
                    this.motcleFilterBuilder.setParentFilter(parentFilterBuilder.toMotcleFilter());
                    break;
                }
                case "fiche": {
                    this.motcleFilterBuilder.add(FilterUnitCatalog.ficheParentage(ExtractionDOMReader.this.readFicheFilter(element), ExtractionDOMReader.readFilterParameters(element), ExtractionDOMReader.this.readCorpusKeySet(element)));
                    break;
                }
                case "extraitcorpus": 
                case "fiches": {
                    CorpusExtractDef corpusExtractDef = ExtractionDOMReader.this.readCorpusExtractDef(element);
                    this.motcleFilterBuilder.add(FilterUnitCatalog.corpusExtract(corpusExtractDef, ExtractionDOMReader.readFilterParameters(element)));
                }
            }
        }
    }

    private static class FilterParametersConsumer
    implements Consumer<Element> {
        private final FilterParametersBuilder filterParametersBuilder;

        private FilterParametersConsumer(FilterParametersBuilder filterParametersBuilder) {
            this.filterParametersBuilder = filterParametersBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "attr": {
                    String name = element.getAttribute("key");
                    if (name.isEmpty()) break;
                    DOMUtils.readChildren(element, new ValConsumer(this.filterParametersBuilder, name));
                    break;
                }
                case "hide-empty": {
                    this.filterParametersBuilder.appendValue("hide", "empty");
                    break;
                }
                case "hide": {
                    String hideValue = DOMUtils.readSimpleElement(element);
                    if (hideValue.isEmpty()) break;
                    this.filterParametersBuilder.appendValue("hide", hideValue);
                    break;
                }
                case "groups": {
                    String groupsValue = DOMUtils.readSimpleElement(element);
                    if (groupsValue.isEmpty()) break;
                    this.filterParametersBuilder.appendValue("groups", groupsValue);
                    break;
                }
                case "cell": {
                    String format;
                    String order = element.getAttribute("order");
                    if (!order.isEmpty()) {
                        try {
                            int val = Integer.parseInt(order);
                            this.filterParametersBuilder.appendValue("cell-order", String.valueOf(val));
                        }
                        catch (NumberFormatException val) {
                            // empty catch block
                        }
                    }
                    if ((format = element.getAttribute("format")).isEmpty()) break;
                    this.filterParametersBuilder.appendValue("cell-format", format);
                    break;
                }
                case "param": {
                    String paramName = element.getAttribute("name");
                    String paramValue = DOMUtils.readSimpleElement(element);
                    if (paramName.isEmpty() || paramValue.isEmpty()) break;
                    this.filterParametersBuilder.appendValue(paramName, paramValue);
                    break;
                }
            }
        }
    }

    private static class ValConsumer
    implements Consumer<Element> {
        private final FilterParametersBuilder filterParametersBuilder;
        private final String name;

        private ValConsumer(FilterParametersBuilder attributeBuilder, String name) {
            this.filterParametersBuilder = attributeBuilder;
            this.name = name;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "val": {
                    String value = DOMUtils.readSimpleElement(element);
                    if (value.isEmpty()) break;
                    this.filterParametersBuilder.appendValue(this.name, value);
                }
            }
        }
    }

    private class StaticConsumer
    implements Consumer<Element> {
        private final ExtractionDefBuilder extractionDefBuilder;

        private StaticConsumer(ExtractionDefBuilder extractionDefBuilder) {
            this.extractionDefBuilder = extractionDefBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagname;
            switch (tagname = element.getTagName()) {
                case "extraitcorpus": 
                case "fiches": {
                    this.extractionDefBuilder.addStatic(ExtractionDOMReader.this.readCorpusExtractDef(element));
                    break;
                }
                case "extraitthesaurus": 
                case "motcles": {
                    this.extractionDefBuilder.addStatic(ExtractionDOMReader.this.readThesaurusExtractDef(element));
                }
            }
        }
    }
}

