/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import java.util.ArrayList;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Info;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.ConversionUtils;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.logging.MultiMessageHandler;

class FicheItemFieldToFicheBlockField
extends FieldToFieldConverter {
    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    FicheItemFieldToFicheBlockField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        FicheBlocks list = this.sourceKey.isProp() ? this.getPropFicheBlocks(fiche) : this.getInfoFicheBlocks(fiche);
        if (list.isEmpty()) {
            return;
        }
        fiche.appendSection(this.destinationKey, list);
        if (removeOldField) {
            if (this.sourceKey.isProp()) {
                fiche.setProp(this.sourceKey, null);
            } else {
                fiche.setInfo(this.sourceKey, null);
            }
        }
    }

    private FicheBlocks getPropFicheBlocks(Fiche fiche) {
        Prop prop = fiche.getProp(this.sourceKey);
        if (prop == null) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        FicheItem ficheItem = prop.getFicheItem();
        if (ficheItem == null) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        return FicheUtils.toFicheBlocks(ConversionUtils.toFicheBlock(ficheItem));
    }

    private FicheBlocks getInfoFicheBlocks(Fiche fiche) {
        Info info = fiche.getInfo(this.sourceKey);
        if (info == null) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        for (FicheItem ficheItem : info) {
            FicheBlock ficheBlock = ConversionUtils.toFicheBlock(ficheItem);
            if (ficheBlock == null) continue;
            list.add(ficheBlock);
        }
        return FicheUtils.toFicheBlocks(list);
    }
}

