/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import net.fichotheque.FichothequeEditor;
import net.fichotheque.FichothequeListener;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.misc.ArrayUtils;

class Listeners {
    private FichothequeListener[] fichothequeListenerArray = new FichothequeListener[0];

    Listeners() {
    }

    void addFichothequeListener(FichothequeListener fichothequeListener) {
        int length = this.fichothequeListenerArray.length;
        this.fichothequeListenerArray = (FichothequeListener[])ArrayUtils.addUnique(this.fichothequeListenerArray, fichothequeListener, new FichothequeListener[length + 1]);
    }

    void removeFichothequeListener(FichothequeListener fichothequeListener) {
        int length = this.fichothequeListenerArray.length;
        if (length > 0) {
            this.fichothequeListenerArray = (FichothequeListener[])ArrayUtils.removeUnique(this.fichothequeListenerArray, fichothequeListener, new FichothequeListener[length - 1]);
        }
    }

    void fireSubsetCreated(FichothequeEditor fichothequeEditor, Subset subset) {
        for (FichothequeListener fichothequeListener : this.fichothequeListenerArray) {
            fichothequeListener.subsetCreated(fichothequeEditor, subset);
        }
    }

    void fireSubsetRemoved(FichothequeEditor fichothequeEditor, SubsetKey corpusKey, Subset masterSubset) {
        for (FichothequeListener fichothequeListener : this.fichothequeListenerArray) {
            fichothequeListener.subsetRemoved(fichothequeEditor, corpusKey, masterSubset);
        }
    }

    void fireCorpusFieldCreated(FichothequeEditor fichothequeEditor, Corpus corpus, CorpusField corpusField) {
        for (FichothequeListener fichothequeListener : this.fichothequeListenerArray) {
            fichothequeListener.corpusFieldCreated(fichothequeEditor, corpus, corpusField);
        }
    }

    void fireCorpusFieldRemoved(FichothequeEditor fichothequeEditor, Corpus corpus, FieldKey fieldKey) {
        for (FichothequeListener fichothequeListener : this.fichothequeListenerArray) {
            fichothequeListener.corpusFieldRemoved(fichothequeEditor, corpus, fieldKey);
        }
    }

    void fireSubsetItemCreated(FichothequeEditor fichothequeEditor, SubsetItem subsetItem) {
        for (FichothequeListener fichothequeListener : this.fichothequeListenerArray) {
            fichothequeListener.subsetItemCreated(fichothequeEditor, subsetItem);
        }
    }

    void fireFicheSaved(FichothequeEditor fichothequeEditor, FicheMeta ficheMeta, FicheAPI fiche) {
        for (FichothequeListener fichothequeListener : this.fichothequeListenerArray) {
            fichothequeListener.ficheSaved(fichothequeEditor, ficheMeta, fiche);
        }
    }

    void fireSubsetItemRemoved(FichothequeEditor fichothequeEditor, Subset subset, int id) {
        for (FichothequeListener fichothequeListener : this.fichothequeListenerArray) {
            fichothequeListener.subsetItemRemoved(fichothequeEditor, subset, id);
        }
    }
}

