/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.tools.subsettree.GroupNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class NodeListBuilder {
    private final List<Object> nodeList = new ArrayList<Object>();

    public void addSubsetNode(SubsetNode subsetNode) {
        this.nodeList.add(subsetNode);
    }

    public void addGroupNode(GroupNode groupNode) {
        this.nodeList.add(groupNode);
    }

    public void addGroupNodeBuilder(GroupNodeBuilder groupNodeBuilder) {
        this.nodeList.add(groupNodeBuilder);
    }

    protected List<SubsetTree.Node> toNodeList(boolean ignoreEmptyGroupNode) {
        int size = this.nodeList.size();
        SubsetTree.Node[] result = new SubsetTree.Node[size];
        int p = 0;
        for (Object obj : this.nodeList) {
            GroupNode groupNode;
            if (obj instanceof SubsetNode) {
                result[p] = (SubsetNode)obj;
                ++p;
                continue;
            }
            if (obj instanceof GroupNode) {
                groupNode = (GroupNode)obj;
                if (ignoreEmptyGroupNode && groupNode.getSubnodeList().isEmpty()) continue;
                result[p] = groupNode;
                ++p;
                continue;
            }
            if (!(obj instanceof GroupNodeBuilder)) continue;
            groupNode = ((GroupNodeBuilder)obj).toGroupNode();
            if (ignoreEmptyGroupNode && groupNode.getSubnodeList().isEmpty()) continue;
            result[p] = groupNode;
            ++p;
        }
        if (p < size) {
            SubsetTree.Node[] tmp = new SubsetTree.Node[p];
            System.arraycopy(result, 0, tmp, 0, p);
            result = tmp;
        }
        return TreeUtils.wrap(result);
    }
}

