/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.apps;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.apps.AppConfUtils;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.RelativePath;

public final class StarterEngine {
    private final BdfServer bdfServer;
    private final EditOrigin editOrigin;
    private final String appName;
    private final String originRoot;
    private final RelativePath destinationRoot;

    private StarterEngine(BdfServer bdfServer, EditOrigin editOrigin, String appName, String originRoot, RelativePath destinationRoot) {
        this.bdfServer = bdfServer;
        this.editOrigin = editOrigin;
        this.appName = appName;
        this.originRoot = originRoot;
        this.destinationRoot = destinationRoot;
    }

    public static void copy(BdfServer bdfServer, EditOrigin editOrigin, String appName, String starterName) throws IOException, ParseException {
        RelativePath destinationRoot = StorageUtils.parseAppResourcePath(appName, "");
        StarterEngine engine = new StarterEngine(bdfServer, editOrigin, appName, "defaultfiles/" + starterName + "/", destinationRoot);
        engine.copyFiles();
    }

    private void copyFiles() throws IOException, ParseException {
        this.copyFile("app.ini");
        this.copyFile("app.html");
        this.createDirectory("css");
        this.createDirectory("js");
        this.createDirectory("l10n");
        this.createDirectory("templates");
        this.copyCustomFile();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(StarterEngine.class.getResourceAsStream(this.originRoot + "list.txt"), "UTF-8"));){
            String ligne;
            while ((ligne = reader.readLine()) != null) {
                if ((ligne = ligne.trim()).length() <= 0) continue;
                this.copyFile(ligne);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Lang lang : this.bdfServer.getLangConfiguration().getWorkingLangs()) {
            InputStream is = IOUtils.toInputStream("#_ l10n.key=", "UTF-8");
            try {
                StorageUtils.saveResource(this.bdfServer, this.destinationRoot.buildChild("l10n/" + lang.toString() + ".ini"), is, this.editOrigin);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private void copyFile(String filePath) throws IOException {
        try (InputStream is = StarterEngine.class.getResourceAsStream(this.originRoot + filePath);){
            StorageUtils.saveResource(this.bdfServer, this.destinationRoot.buildChild(filePath), is, this.editOrigin);
        }
    }

    private void copyCustomFile() throws IOException, ParseException {
        RelativePath customFilePath = AppConfUtils.getCustomIniPath(this.appName);
        try (InputStream is = StarterEngine.class.getResourceAsStream(this.originRoot + "custom.ini");){
            StorageUtils.saveResource(this.bdfServer, customFilePath, is, this.editOrigin);
        }
    }

    private void createDirectory(String name) throws ParseException {
        StorageUtils.createDirectory(this.bdfServer, StorageUtils.parseAppResourcePath(this.appName, name));
    }
}

