/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.jsonproducers.exportation.AccessArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.AccessJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.BalayageArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.BalayageContentJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.BalayageJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.ScrutariExportArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.ScrutariExportJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.ScrutariExportPathsJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.SqlExportArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.SqlExportJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.SqlExportPathsJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.TableExportArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.TableExportContentJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.TableExportJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.TemplateContentJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.TemplateDescriptionJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.TransformationDescriptionJsonProperty;
import fr.exemole.bdfserver.jsonproducers.exportation.TransformationDescriptionsJsonProperty;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageLog;
import fr.exemole.bdfserver.tools.instruction.BdfCommandResultBuilder;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.balayage.BalayageContentDescription;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.tools.exportation.scrutari.ScrutariExportUtils;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.json.JsonUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.text.StringUtils;

public final class ExportationJsonProducerFactory {
    private ExportationJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String json = parameters.getOutput();
        BdfCommandResult bdfCommandResult = parameters.getBdfCommandResult();
        BdfServer bdfServer = parameters.getBdfServer();
        if (bdfCommandResult == null) {
            switch (json) {
                case "scrutariexport": {
                    Map<SubsetKey, LineLogs> lineLogsMap = ScrutariExportUtils.checkFieldGeneration(requestHandler.getScrutariExportDef(), bdfServer.getTableExportContext());
                    if (lineLogsMap.isEmpty()) break;
                    bdfCommandResult = BdfCommandResultBuilder.init().putResultObject("obj.linelogsmap", lineLogsMap).toBdfCommandResult();
                }
            }
        }
        ResultJsonProducer jsonProducer = new ResultJsonProducer(bdfCommandResult, parameters.getMessageLocalisation());
        JsonProperty jsonProperty = ExportationJsonProducerFactory.getJsonProperty(requestHandler, json, bdfCommandResult);
        if (jsonProperty == null) {
            return null;
        }
        jsonProducer.add(jsonProperty);
        return jsonProducer;
    }

    private static JsonProperty getJsonProperty(OutputRequestHandler requestHandler, String name, BdfCommandResult bdfCommandResult) throws ErrorMessageException {
        BdfServer bdfServer = requestHandler.getBdfServer();
        Lang lang = requestHandler.getWorkingLang();
        MessageLocalisation messageLocalisation = requestHandler.getMessageLocalisation();
        switch (name) {
            case "tableexport": {
                return new TableExportJsonProperty(requestHandler.getTableExportDescription(), lang, messageLocalisation);
            }
            case "tableexport-array": {
                bdfServer.getTableExportManager().update();
                return new TableExportArrayJsonProperty(bdfServer, lang, messageLocalisation);
            }
            case "tableexport-content": {
                return new TableExportContentJsonProperty(bdfServer, ExportationJsonProducerFactory.getTableExportContentDescription(requestHandler), messageLocalisation);
            }
            case "scrutariexport": {
                return new ScrutariExportJsonProperty(requestHandler.getScrutariExportDef(), lang);
            }
            case "scrutariexport-array": {
                return new ScrutariExportArrayJsonProperty(bdfServer, lang);
            }
            case "scrutariexport-paths": {
                return new ScrutariExportPathsJsonProperty(requestHandler.getScrutariExportDef(), requestHandler.getPathConfiguration());
            }
            case "transformation-description": {
                return new TransformationDescriptionJsonProperty(requestHandler.getTransformationDescription(), lang, messageLocalisation);
            }
            case "transformation-descriptions": {
                bdfServer.getTransformationManager().update();
                return new TransformationDescriptionsJsonProperty(bdfServer.getTransformationManager(), ExportationJsonProducerFactory.getTransformationKeySet(requestHandler), lang, messageLocalisation);
            }
            case "transformation-templatedescription": {
                return new TemplateDescriptionJsonProperty(requestHandler.getTemplateDescription(), lang, messageLocalisation);
            }
            case "transformation-templatecontent": {
                return new TemplateContentJsonProperty(bdfServer, requestHandler.getTemplateContentDescription(), messageLocalisation);
            }
            case "sqlexport": {
                return new SqlExportJsonProperty(requestHandler.getSqlExportDef(), lang);
            }
            case "sqlexport-array": {
                return new SqlExportArrayJsonProperty(bdfServer, lang);
            }
            case "sqlexport-paths": {
                return new SqlExportPathsJsonProperty(requestHandler.getSqlExportDef(), requestHandler.getPathConfiguration());
            }
            case "access": {
                return new AccessJsonProperty(requestHandler.getAccessDef(), lang);
            }
            case "access-array": {
                return new AccessArrayJsonProperty(bdfServer, lang);
            }
            case "balayage": {
                return new BalayageJsonProperty(requestHandler.getBalayageDescription(), lang, messageLocalisation);
            }
            case "balayage-array": {
                bdfServer.getBalayageManager().update();
                return new BalayageArrayJsonProperty(bdfServer, lang, messageLocalisation);
            }
            case "balayage-content": {
                return new BalayageContentJsonProperty(bdfServer, ExportationJsonProducerFactory.getBalayageContentDescription(requestHandler), messageLocalisation);
            }
            case "balayage-log": {
                BalayageLog balayageLog = (BalayageLog)requestHandler.getResultObject("obj.balayagelog");
                if (balayageLog != null) {
                    return balayageLog;
                }
                return JsonUtils.EMPTY_JSONPROPERTY;
            }
        }
        return null;
    }

    private static BalayageContentDescription getBalayageContentDescription(OutputRequestHandler requestHandler) throws ErrorMessageException {
        BalayageDescription balayageDescription = requestHandler.getMandatoryBalayageDescription();
        return requestHandler.getMandatoryBalayageContentDescription(balayageDescription);
    }

    private static TableExportContentDescription getTableExportContentDescription(OutputRequestHandler requestHandler) throws ErrorMessageException {
        TableExportDescription tableExportDescription = requestHandler.getMandatoryTableExportDescription();
        return requestHandler.getMandatoryTableExportContentDescription(tableExportDescription);
    }

    private static Set<TransformationKey> getTransformationKeySet(OutputRequestHandler requestHandler) throws ErrorMessageException {
        String[] keysArray = requestHandler.getTokens("keys");
        LinkedHashSet<TransformationKey> transformationKeySet = new LinkedHashSet<TransformationKey>();
        for (String keys : keysArray) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens(keys, true)) {
                try {
                    transformationKeySet.add(TransformationKey.parse(token));
                }
                catch (ParseException pe) {
                    throw BdfErrors.unknownParameterValue("keys", token);
                }
            }
        }
        return transformationKeySet;
    }
}

