/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.commands.thesaurus.MotcleMergeCommand;
import fr.exemole.bdfserver.commands.thesaurus.MotcleMoveCommand;
import fr.exemole.bdfserver.commands.thesaurus.ThesaurusCloneCommand;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.consumers.AttributesText;
import fr.exemole.bdfserver.html.consumers.Common;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.LangRows;
import fr.exemole.bdfserver.html.consumers.MetadataPhrases;
import fr.exemole.bdfserver.html.consumers.SubsetTitle;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.consumers.commandbox.Flag;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import fr.exemole.bdfserver.tools.ui.MetadataPhraseDefCatalog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Liaison;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.syntax.FormSyntax;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;

public final class ThesaurusCommandBoxUtils {
    private ThesaurusCommandBoxUtils() {
    }

    public static boolean printThesaurusCreationBox(HtmlPrinter hp, CommandBox commandBox, BdfServer bdfServer) {
        commandBox = commandBox.derive("ThesaurusCreation", "_ THS-01").actionCssClass("action-New").__(Flag.UPDATE_COLLECTIONS).submitLocKey("_ submit.thesaurus.thesauruscreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.thesaurus.newthesaurusname", hp.name("newthesaurus").size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(Grid.choiceSetRow((Object)"_ label.thesaurus.thesaurustype", () -> hp.__(ThesaurusCommandBoxUtils.printRadioType(hp, "multi", true)).__(ThesaurusCommandBoxUtils.printRadioType(hp, "idalpha", false)).__(ThesaurusCommandBoxUtils.printRadioType(hp, "babelien", false)))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printThesaurusPhrasesBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus, BdfServer bdfServer) {
        Langs langs = bdfServer.getLangConfiguration().getWorkingLangs();
        Langs authorizedLangs = bdfServer.getThesaurusLangChecker().getAuthorizedLangs(thesaurus);
        if (authorizedLangs != null) {
            langs = LangsUtils.merge(langs, authorizedLangs);
        }
        ThesaurusMetadata thesaurusMetadata = thesaurus.getThesaurusMetadata();
        MetadataPhrases metadataPhrases = MetadataPhrases.init(thesaurusMetadata, langs, "_ label.thesaurus.title");
        if (ThesaurusCommandBoxUtils.isFicheStyleUsed(thesaurus, bdfServer)) {
            metadataPhrases.addDef(MetadataPhraseDefCatalog.getMetadataPhraseDef("fichestyle"));
        }
        metadataPhrases.populateFromAttributes(thesaurus).addExtensionPhraseDefList(bdfServer);
        commandBox = commandBox.derive("ThesaurusPhrases", "_ THS-02").__(CommandBoxUtils.insert(thesaurus)).actionCssClass("action-Labels").submitLocKey("_ submit.thesaurus.thesaurusphrases");
        hp.__start(commandBox).__(metadataPhrases).__end(commandBox);
        return true;
    }

    public static boolean printThesaurusLangListBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus, BdfServer bdfServer) {
        if (thesaurus.isBabelienType()) {
            return false;
        }
        Langs langs = bdfServer.getThesaurusLangChecker().getAuthorizedLangs(thesaurus);
        commandBox = commandBox.derive("ThesaurusLangList", "_ THS-03").__(CommandBoxUtils.insert(thesaurus)).submitLocKey("_ submit.thesaurus.langlist");
        hp.__start(commandBox).P("global-SubTitle").__localize(ThesaurusHtmlUtils.getThesaurusTypeMessageKey(thesaurus.getThesaurusMetadata().getThesaurusType()))._P().__(Grid.START).__(Grid.textInputRow("_ label.thesaurus.langlist", hp.name("langlist").value(langs.toString(";")).size("15"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printThesaurusRemoveBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus) {
        commandBox = commandBox.derive("ThesaurusRemove", "_ THS-04").__(CommandBoxUtils.insert(thesaurus)).actionCssClass("action-Delete").__(Flag.UPDATE_COLLECTIONS).submitLocKey("_ submit.thesaurus.thesaurusremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printThesaurusCleaningBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus, Lang workingLang) {
        commandBox = commandBox.derive("ThesaurusCleaning", "_ THS-06").__(CommandBoxUtils.insert(thesaurus)).submitLocKey("_ submit.thesaurus.thesauruscleaning");
        hp.__start(commandBox).P().__localize("_ warning.thesaurus.cleaningconfirmation", FichothequeUtils.getTitle(thesaurus, workingLang))._P().__(Common.CLEANING_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printThesaurusCloneBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus, Lang lang) {
        List<Corpus> satelliteCorpusList = thesaurus.getSatelliteCorpusList();
        commandBox = commandBox.derive("ThesaurusClone", "_ THS-15").__(CommandBoxUtils.insert(thesaurus)).actionCssClass("action-Duplicate").submitLocKey("_ submit.thesaurus.thesaurusclone");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.thesaurus.newthesaurusname", hp.name(ThesaurusCloneCommand.NEWTHESAURUS_PARAMNAME).size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(Grid.checkboxRow("_ label.thesaurus.reinitid", hp.name(ThesaurusCloneCommand.REINITID_PARAMNAME).value("1").checked(false))).__(Grid.checkboxRow("_ label.thesaurus.junctioncopy", hp.name(ThesaurusCloneCommand.COPYJUNCTIONS_PARAMNAME).value("1").checked(false)));
        if (!satelliteCorpusList.isEmpty()) {
            String satelliteDetailId = hp.generateId();
            hp.__(Grid.checkboxRow((Object)"_ label.thesaurus.clonesatellite", hp.name(ThesaurusCloneCommand.CLONESATELLITE_PARAMNAME).value("1").checked(false).populate(Deploy.checkbox(satelliteDetailId)), () -> {
                hp.DIV(Grid.detailPanelTable().id(satelliteDetailId).addClass("hidden"));
                for (Corpus corpus : satelliteCorpusList) {
                    ThesaurusCommandBoxUtils.printSatelliteCorpusCheckBox(hp, corpus, lang);
                }
                hp._DIV();
            }));
        }
        hp.__(Grid.END).__end(commandBox);
        return true;
    }

    private static boolean printSatelliteCorpusCheckBox(HtmlPrinter hp, Corpus corpus, Lang lang) {
        String corpusName = corpus.getSubsetName();
        String corpusDetailId = hp.generateId();
        hp.__(Grid.checkboxRow((Object)SubsetTitle.init(corpus, lang).subsetName(true), hp.name(ThesaurusCloneCommand.SATELLITECORPUS_PARAMNAME).value(corpusName).checked(false).populate(Deploy.checkbox(corpusDetailId)), () -> hp.DIV(Grid.detailPanelTable().id(corpusDetailId).addClass("hidden")).__(Grid.textInputRow("_ label.corpus.newcorpusname", hp.name(ThesaurusCloneCommand.NEWCORPUS_PREFIX + corpusName).size("30").populate(InputPattern.TECHNICAL_STRICT))).__(Grid.checkboxRow("_ label.corpus.clonefiches", hp.name(ThesaurusCloneCommand.CLONEFICHES_PREFIX + corpusName).value("1").checked(false)))._DIV()));
        return true;
    }

    public static boolean printChildrenReorderBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus, Motcle motcle) {
        boolean isIdalpha = thesaurus.isIdalphaType();
        List<Motcle> children = motcle != null ? motcle.getChildList() : thesaurus.getFirstLevelList();
        Object insertObject = motcle != null ? motcle : thesaurus;
        commandBox = commandBox.derive("ChildrenReorder", "_ THS-21").__(CommandBoxUtils.insert(insertObject)).submitLocKey("_ submit.thesaurus.childrenreorder");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.thesaurus.children", hp.name("children").classes("command-LargeInput").cols(40).rows(20), () -> {
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    hp.__newLine();
                }
                Motcle child = (Motcle)children.get(i);
                if (isIdalpha) {
                    hp.__escape(child.getIdalpha());
                    continue;
                }
                hp.__append(child.getId());
            }
        })).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printIdalphaSortBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus, Motcle motcle) {
        Object insertObject = motcle != null ? motcle : thesaurus;
        commandBox = commandBox.derive("IdalphaSort", "_ THS-07").__(CommandBoxUtils.insert(insertObject)).submitLocKey("_ submit.thesaurus.idalphasort");
        hp.__start(commandBox).__(Grid.START).__(Grid.checkboxRow("_ label.thesaurus.sort_recursive", hp.name("recursive").value("1"))).__(Grid.checkboxRow("_ label.thesaurus.sort_descending", hp.name("descending").value("1"))).__(Grid.checkboxRow("_ label.thesaurus.sort_ignorecase", hp.name("ignorecase").value("1"))).__(Grid.checkboxRow("_ label.thesaurus.sort_ignorepunctuation", hp.name("ignorepunctuation").value("1"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printMotcleCreationBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus, Motcle parentMotcle, BdfServer bdfServer, Lang lang) {
        commandBox = commandBox.derive("MotcleCreation", "_ THS-08").__(CommandBoxUtils.insert(thesaurus)).actionCssClass("action-New").submitLocKey("_ submit.thesaurus.motclecreation");
        if (parentMotcle != null) {
            commandBox.hidden("parent", String.valueOf(parentMotcle.getId()));
        }
        hp.__start(commandBox);
        if (thesaurus.isIdalphaType()) {
            hp.__(Grid.START).__(Grid.textInputRow("_ label.thesaurus.newidalpha", hp.name("newidalpha").size("30").populate(InputPattern.IDALPHA).required(true))).__(ThesaurusCommandBoxUtils.printParentMotcle(hp, parentMotcle, lang)).__(Grid.END);
        } else if (thesaurus.isBabelienType()) {
            hp.__(Grid.START).__(ThesaurusCommandBoxUtils.printParentMotcle(hp, parentMotcle, lang)).__(Grid.textAreaBlockRow("_ label.thesaurus.label_one", hp.name("babeliennewlabel").cols(60).rows(3))).__(Grid.textInputRow("_ label.thesaurus.babelienlang", hp.name("babeliennewlang").value(lang.toString()).size("3").populate(InputPattern.LANG).required(true))).__(Grid.END);
        } else if (parentMotcle != null) {
            hp.__(Grid.START).__(ThesaurusCommandBoxUtils.printParentMotcle(hp, parentMotcle, lang)).__(Grid.END);
        }
        if (!thesaurus.isBabelienType()) {
            Langs langs = bdfServer.getThesaurusLangChecker().getAuthorizedLangs(thesaurus);
            String messageKey = langs.size() == 1 ? "_ label.thesaurus.label_one" : "_ label.thesaurus.label_many";
            hp.DL("global-DL").__(ThesaurusCommandBoxUtils.printMotcleLabelTable(hp, null, "newlabel/", langs, messageKey))._DL();
        }
        hp.__end(commandBox);
        return true;
    }

    private static boolean printParentMotcle(HtmlPrinter hp, Motcle parentMotcle, Lang lang) {
        if (parentMotcle == null) {
            return false;
        }
        hp.__(Grid.START_ROW).__(Grid.labelCells("_ label.thesaurus.parent")).__(Grid.START_INPUTCELL).__(BdfHtmlUtils.printMotcleTitle(hp, parentMotcle, lang)).__(Grid.END_INPUTCELL).__(Grid.END_ROW);
        return true;
    }

    public static boolean printIdalphaChangeBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle) {
        commandBox = commandBox.derive("IdalphaChange", "_ THS-09").__(CommandBoxUtils.insert(motcle)).submitLocKey("_ submit.thesaurus.idalphachange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.thesaurus.idalpha", hp.name("newidalpha").value(motcle.getIdalpha()).size("30").populate(InputPattern.IDALPHA).required(true))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printParentChangeBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle, Lang lang) {
        boolean withIdalpha = motcle.getThesaurus().isIdalphaType();
        String messageKey = withIdalpha ? "_ label.thesaurus.parent_idalpha" : "_ label.thesaurus.parent_id";
        String parentValue = "";
        Motcle parentMotcle = motcle.getParent();
        if (parentMotcle != null) {
            parentValue = withIdalpha ? parentMotcle.getIdalpha() : String.valueOf(parentMotcle.getId());
        }
        commandBox = commandBox.derive("ParentChange", "_ THS-10").__(CommandBoxUtils.insert(motcle)).submitLocKey("_ submit.thesaurus.parentchange");
        hp.__start(commandBox).__(Grid.START).__(ThesaurusCommandBoxUtils.printParentMotcle(hp, parentMotcle, lang)).__(Grid.textInputRow(messageKey, hp.name("newparent").value(parentValue).size("30"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printLabelChangeBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle, BdfServer bdfServer) {
        Langs langs;
        Thesaurus thesaurus = motcle.getThesaurus();
        boolean isBabelien = thesaurus.isBabelienType();
        boolean manyLang = false;
        if (!isBabelien) {
            langs = bdfServer.getThesaurusLangChecker().getAuthorizedLangs(thesaurus);
            manyLang = langs.size() > 1;
        } else {
            langs = null;
        }
        commandBox = commandBox.derive("LabelChange", "_ THS-11").__(CommandBoxUtils.insert(motcle)).submitLocKey(manyLang ? "_ submit.thesaurus.labelchange_many" : "_ submit.thesaurus.labelchange_one");
        hp.__start(commandBox);
        if (isBabelien) {
            Label label = motcle.getBabelienLabel();
            hp.__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.thesaurus.label_one", hp.name("babelienlabel").cols(60).rows(3), () -> hp.__escape(FormSyntax.escapeString(label.getLabelString())))).__(Grid.textInputRow("_ label.thesaurus.babelienlang", hp.name("babelienlang").value(label.getLang().toString()).size("3"))).__(Grid.END);
        } else {
            String messageKey = manyLang ? "_ label.thesaurus.label_many" : "_ label.thesaurus.label_one";
            hp.DL("global-DL").__(ThesaurusCommandBoxUtils.printMotcleLabelTable(hp, motcle, "label/", langs, messageKey))._DL();
        }
        hp.__end(commandBox);
        return true;
    }

    public static boolean printThesaurusAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Thesaurus thesaurus) {
        commandBox = commandBox.derive("ThesaurusAttributeChange", "_ THS-19").__(CommandBoxUtils.insert(thesaurus)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(thesaurus.getThesaurusMetadata().getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printMotcleStatusBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle) {
        String status = motcle.getStatus();
        commandBox = commandBox.derive("MotcleStatus", "_ THS-16").__(CommandBoxUtils.insert(motcle)).submitLocKey("_ submit.thesaurus.motclestatus");
        hp.__start(commandBox).__(Grid.START).__(ThesaurusCommandBoxUtils.printStatusRow(hp, "active", status)).__(ThesaurusCommandBoxUtils.printStatusRow(hp, "group", status)).__(ThesaurusCommandBoxUtils.printStatusRow(hp, "obsolete", status)).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printMotcleAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle) {
        commandBox = commandBox.derive("MotcleAttributeChange", "_ THS-20").__(CommandBoxUtils.insert(motcle)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(motcle.getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printMotcleRemoveBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle, Lang workingLang, Locale formatLocale) {
        ArrayList<FicheMeta> satelliteList = new ArrayList<FicheMeta>();
        int motcleid = motcle.getId();
        for (Corpus satelliteCorpus : motcle.getThesaurus().getSatelliteCorpusList()) {
            FicheMeta ficheMeta = satelliteCorpus.getFicheMetaById(motcleid);
            if (ficheMeta == null) continue;
            satelliteList.add(ficheMeta);
        }
        commandBox = commandBox.derive("MotcleRemove", "_ THS-12").__(CommandBoxUtils.insert(motcle)).actionCssClass("action-Delete").submitLocKey("_ submit.thesaurus.motcleremove");
        hp.__start(commandBox).__if(!satelliteList.isEmpty(), () -> {
            hp.P("global-Warning").__localize("_ warning.corpus.satelliteremove")._P();
            hp.UL();
            for (FicheMeta satelliteFicheMeta : satelliteList) {
                hp.LI().__escape(CorpusMetadataUtils.getFicheTitle(satelliteFicheMeta, workingLang, formatLocale))._LI();
            }
            hp._UL();
        }).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printMotcleIndexationBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle, Lang workingLang, PermissionSummary permissionSummary) {
        Thesaurus thesaurus = motcle.getThesaurus();
        Fichotheque fichotheque = thesaurus.getFichotheque();
        commandBox = commandBox.derive("MotcleIndexation", "_ THS-13").__(CommandBoxUtils.insert(motcle)).submitLocKey("_ submit.thesaurus.motcleindexation");
        hp.__start(commandBox);
        for (Corpus corpus : fichotheque.getCorpusList()) {
            if (!permissionSummary.hasAccess(corpus)) continue;
            hp.H3().__escape(FichothequeUtils.getTitle(corpus, workingLang))._H3();
            hp.TEXTAREA(hp.name(corpus.getSubsetKeyString()).cols(60).rows(3).classes("command-LargeInput"));
            Collection<Liaison> liaisons = JunctionUtils.sortByWeight(fichotheque.getJunctions(motcle, corpus), "");
            for (Liaison liaison : liaisons) {
                SubsetItem subsetItem = liaison.getSubsetItem();
                hp.__append(subsetItem.getId());
                int weight = liaison.getTie().getWeight();
                if (weight > 1) {
                    hp.__space().__escape('<').__append(weight).__escape('>');
                }
                hp.__escape("; ");
            }
            hp._TEXTAREA();
        }
        hp.__end(commandBox);
        return true;
    }

    public static boolean printMotcleMoveBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle, BdfServer bdfServer, Lang workingLang, SubsetTree adminSubsetTree, SubsetKey selectedSubsetKey) {
        SubsetKey checkedSelectedSubsetKey = ThesaurusCommandBoxUtils.testSubsetKey(adminSubsetTree, selectedSubsetKey);
        if (checkedSelectedSubsetKey == null) {
            return false;
        }
        Thesaurus thesaurus = motcle.getThesaurus();
        commandBox = commandBox.derive("MotcleMove", "_ THS-17").__(CommandBoxUtils.insert(motcle)).actionCssClass("action-Move").submitLocKey("_ submit.thesaurus.motclemove");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.thesaurus.destinationthesaurus", hp.name(MotcleMoveCommand.DESTINATIONTHESAURUS_PARAMNAME), SubsetTreeOptions.init(adminSubsetTree, bdfServer, workingLang).onlyNames(true).withKeys(true).disabledSet(Collections.singleton(thesaurus.getSubsetKey())).selectedSubsetKey(checkedSelectedSubsetKey))).__(Grid.END).__(Common.MOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printMotcleMergeBox(HtmlPrinter hp, CommandBox commandBox, Motcle motcle, BdfServer bdfServer, Lang workingLang, SubsetTree readSubsetTree, SubsetKey selectedSubsetKey) {
        SubsetKey checkedSelectedSubsetKey = ThesaurusCommandBoxUtils.testSubsetKey(readSubsetTree, selectedSubsetKey);
        if (checkedSelectedSubsetKey == null) {
            return false;
        }
        HtmlAttributes inputAttributes = hp.name(MotcleMergeCommand.MERGEMOTCLE_PARAMNAME).size("10").populate(Appelant.motcle().wanted_code_id().limit(1).subsets(checkedSelectedSubsetKey));
        commandBox = commandBox.derive("MotcleMerge", "_ THS-18").__(CommandBoxUtils.insert(motcle)).actionCssClass("action-Merge").submitLocKey("_ submit.thesaurus.motclemerge");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.thesaurus.mergemotcle", inputAttributes)).__(Grid.selectRow((Object)"_ label.thesaurus.mergethesaurus", hp.name(MotcleMergeCommand.MERGETHESAURUS_PARAMNAME).attr("data-appelant-role", "subset-select").attr("data-appelant-target", "#" + inputAttributes.id()), SubsetTreeOptions.init(readSubsetTree, bdfServer, workingLang).onlyNames(true).withKeys(true).selectedSubsetKey(checkedSelectedSubsetKey))).__(Grid.END).__(Common.MERGE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    private static boolean printRadioType(HtmlPrinter hp, String type, boolean checked) {
        hp.__(Grid.radioCell(ThesaurusHtmlUtils.getThesaurusTypeMessageKey(type), hp.name("thesaurustype").value(type).checked(checked)));
        return true;
    }

    private static boolean printMotcleLabelTable(HtmlPrinter hp, @Nullable Motcle motcle, String paramPrefix, Langs langs, String messageKey) {
        Labels labels = motcle != null ? motcle.getLabels() : null;
        hp.DT().__localize(messageKey)._DT().DD().__(Grid.START).__(LangRows.init(paramPrefix, labels, langs).cols(60).rows(3)).__(Grid.END)._DD();
        return true;
    }

    private static SubsetKey testSubsetKey(SubsetTree subsetTree, SubsetKey selectedSubsetKey) {
        SubsetKey firstSubsetKey = TreeUtils.getFirstSubsetKey(subsetTree);
        if (firstSubsetKey == null) {
            return null;
        }
        if (selectedSubsetKey == null) {
            return firstSubsetKey;
        }
        if (TreeUtils.containsSubsetKey(subsetTree, selectedSubsetKey)) {
            return selectedSubsetKey;
        }
        return firstSubsetKey;
    }

    private static boolean isFicheStyleUsed(Thesaurus thesaurus, BdfServer bdfServer) {
        SubsetKey thesaurusKey = thesaurus.getSubsetKey();
        UiManager uiManager = bdfServer.getUiManager();
        for (Corpus corpus : bdfServer.getFichotheque().getCorpusList()) {
            UiComponents uiComponents = uiManager.getMainUiComponents(corpus);
            for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
                SubsetIncludeUi subsetIncludeUi;
                SubsetKey subsetKey;
                if (!(uiComponent instanceof SubsetIncludeUi) || !(subsetKey = (subsetIncludeUi = (SubsetIncludeUi)uiComponent).getSubsetKey()).equals(thesaurusKey) || !subsetIncludeUi.matchInputType("fichestyle")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean printStatusRow(HtmlPrinter hp, String status, String currentStatus) {
        hp.__(Grid.radioRow(ThesaurusCommandBoxUtils.getStatusMessageKey(status), hp.name("status").value(status).checked(currentStatus)));
        return true;
    }

    private static String getStatusMessageKey(String status) {
        switch (status) {
            case "active": {
                return "_ label.thesaurus.status_active";
            }
            case "group": {
                return "_ label.thesaurus.status_group";
            }
            case "obsolete": {
                return "_ label.thesaurus.status_obsolete";
            }
        }
        throw new SwitchException("Unknown status: " + status);
    }
}

