/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadEngine;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.JsObject;

public class FilesUploadFormHtmlProducer
extends BdfServerHtmlProducer {
    private final String mode;
    private final String callKey;

    public FilesUploadFormHtmlProducer(BdfParameters bdfParameters, String mode, String callKey) {
        super(bdfParameters);
        this.mode = FilesUploadFormHtmlProducer.checkMode(mode);
        this.callKey = callKey;
        this.setBodyCssClass("global-body-Transparent");
        this.addJsLib(FicheJsLibs.FILESUPLOAD);
    }

    @Override
    public void printHtml() {
        JsObject args = JsObject.init().put("step", "form").put("callKey", this.callKey);
        String formId = this.generateId();
        ParameterMap parameterMap = ParameterMap.init().command("FilesUpload").page("filesupload-result").errorPage("filesupload-form").param("mode", this.mode).param("callkey", this.callKey);
        HtmlAttributes fileInput = this.name("files").type("file").addClass("global-FileInput filesupload-FileInput").size("70").multiple(true);
        this.start();
        this.SCRIPT().__jsObject("FilesUpload.ARGS", args)._SCRIPT();
        this.FORM_post(HA.id(formId).action("edition").enctype("multipart/form-data")).INPUT_hidden(parameterMap).DIV("filesupload-Page").DIV("filesupload-Header").__(Button.submit("action-Upload", "_ submit.global.upload"))._DIV().DIV("filesupload-Body").INPUT(fileInput)._DIV()._FORM();
        this.end();
    }

    private static String checkMode(String mode) {
        try {
            return FilesUploadEngine.checkMode(mode);
        }
        catch (IllegalArgumentException iae) {
            return "multi";
        }
    }
}

