/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.ficheform.include.ThesaurusEntry;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.forms.FormHandler;
import fr.exemole.bdfserver.html.forms.IncludeFormEntryHtml;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.htmlproducers.edition.EditionHtmlUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.HA;

public class FicheIndexationHtmlProducer
extends BdfServerHtmlProducer {
    private final FichePointeur fichePointeur;
    private final FicheMeta ficheMeta;
    private final FormEntryProvider formEntryProvider;
    private final FormHandler formHandler;

    public FicheIndexationHtmlProducer(BdfParameters bdfParameters, FichePointeur fichePointeur, FormEntryProvider formEntryProvider) {
        super(bdfParameters);
        this.fichePointeur = fichePointeur;
        this.ficheMeta = (FicheMeta)fichePointeur.getCurrentSubsetItem();
        this.formEntryProvider = formEntryProvider;
        this.formHandler = FormHandler.build(bdfParameters);
        this.addJsLib(FicheJsLibs.FORM);
        this.addThemeCss("edition.css");
    }

    @Override
    public void printHtml() {
        String formId = this.generateId();
        this.start();
        this.DIV("edition-Page edition-indexation-Page").__(EditionHtmlUtils.printFicheHeader(this, this.ficheMeta, this.workingLang, this.formatLocale, formId)).__(this.printCommandMessageUnit()).MAIN("edition-Unit").FORM_post(HA.action("edition").id(formId).attr("data-ficheform-role", "form").attr("data-ficheform-corpus", this.ficheMeta.getSubsetName()).attr("data-submit-process", "wait")).INPUT_hidden(ParameterMap.init().command("FicheIndexationChange").page("fiche-indexation").subset(this.ficheMeta.getCorpus()).subsetItem(this.ficheMeta)).__(this.printThesaurusTree()).__(Button.COMMAND, Button.submit("action-Save", "_ link.global.ok").formId(formId).ficheForm(true).shortcutKey("mod+s").shortcutTooltip("MOD+S"))._FORM()._MAIN()._DIV();
        this.end();
    }

    private boolean printThesaurusTree() {
        SubsetTree subsetTree = TreeFilterEngine.read(this.bdfParameters.getPermissionSummary(), this.bdfServer.getTreeManager().getSubsetTree((short)2));
        for (SubsetTree.Node node : subsetTree.getNodeList()) {
            if (node instanceof SubsetNode) {
                this.__(this.printSubsetNode((SubsetNode)node));
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            this.__(this.printGroupNode((GroupNode)node));
        }
        return true;
    }

    private boolean printGroupNode(GroupNode groupNode) {
        this.H2().__escape(TreeUtils.getTitle(this.bdfServer, groupNode, this.workingLang))._H2();
        for (SubsetTree.Node subnode : groupNode.getSubnodeList()) {
            if (subnode instanceof SubsetNode) {
                this.__(this.printSubsetNode((SubsetNode)subnode));
                continue;
            }
            if (!(subnode instanceof GroupNode)) continue;
            this.__(this.printGroupNode((GroupNode)subnode));
        }
        this.P().__doublespace()._P();
        return true;
    }

    private boolean printSubsetNode(SubsetNode subsetNode) {
        Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(subsetNode.getSubsetKey());
        if (thesaurus != null) {
            FormEntry.Include formEntry = this.formEntryProvider.getFormEntry(this.fichePointeur, this.toSubsetIncludeUi(thesaurus));
            this.__(IncludeFormEntryHtml.printTextThesaurus(this, (ThesaurusEntry.Text)formEntry, this.formHandler));
        }
        return true;
    }

    private SubsetIncludeUi toSubsetIncludeUi(Thesaurus thesaurus) {
        ExtendedIncludeKey includeKey = ExtendedIncludeKey.newInstance(IncludeKey.newInstance(thesaurus.getSubsetKey()));
        return (SubsetIncludeUi)IncludeUiBuilder.initSubset(includeKey).toIncludeUi();
    }
}

