/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus.include;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.LangRows;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlUtils;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.Labels;

public abstract class AbstractIncludeHtmlProducer
extends BdfServerHtmlProducer {
    protected final PermissionSummary permissionSummary;
    protected final Corpus corpus;
    protected final String currentPage;

    public AbstractIncludeHtmlProducer(BdfParameters bdfParameters, Corpus corpus, String currentPage) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.corpus = corpus;
        this.currentPage = currentPage;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
        this.addThemeCss("corpus.css");
    }

    public void commonStart() {
        super.start();
        BdfHtmlUtils.printSubsetHeader(this, this.bdfParameters, this.corpus, this.currentPage);
        CorpusHtmlUtils.printCorpusToolbar(this, this.corpus, this.currentPage, this.bdfServer);
        this.printCommandMessageUnit();
    }

    public CommandBox initCommandBox() {
        return CommandBox.init().action("corpus").family("CRP").veil(true).page(this.currentPage);
    }

    public boolean printIncludeChangeDetails(CommandBox commandBox, IncludeUi includeUi) {
        Langs workingLangs = this.bdfServer.getLangConfiguration().getWorkingLangs();
        Labels labels = includeUi.getCustomLabels();
        if (labels == null) {
            this.P("global-SubTitle").__localize("_ info.corpus.defaultlabelusage")._P();
        } else {
            this.__(Grid.START).__(LangRows.init("", labels, workingLangs).displayOnly(true)).__(Grid.END);
        }
        this.DETAILS("command-Details").SUMMARY().__localize("_ link.global.change")._SUMMARY().__(CorpusCommandBoxUtils.printIncludeChangeBox(this, commandBox, this.corpus, includeUi, workingLangs))._DETAILS();
        return true;
    }

    public boolean printComponentRemoveDetails(CommandBox commandBox, UiComponent component) {
        this.DETAILS("command-Details").SUMMARY().__localize("_ link.global.delete")._SUMMARY().__(CorpusCommandBoxUtils.printComponentRemoveBox(this, commandBox, this.corpus, component))._DETAILS();
        return true;
    }
}

