/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusConfHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusCreationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusDiagramHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusPhrasesFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.DuplicationLogHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FicheAddendaHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FicheAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FicheAlbumHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FicheDiscardFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FicheRemoveFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FicheRetrieveFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FieldCreationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FieldOptionsFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.FieldRemoveFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.RemovedListHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.ReponderationLogHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.UiComponentAttributesFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.UiComponentOptionsFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.UiComponentPositionFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.include.AddendaIncludeHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.include.AlbumIncludeHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.include.CommentIncludeHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.include.CorpusIncludeHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.include.ExternalSourceIncludeHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.include.SpecialIncludeHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.corpus.include.ThesaurusIncludeHtmlProducer;
import fr.exemole.bdfserver.tools.ficheform.FicheFormParametersBuilder;
import fr.exemole.bdfserver.tools.ficheform.FormEntryProviderFactory;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.tools.duplication.SubsetMatch;
import net.fichotheque.tools.reponderation.ReponderationLog;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public final class CorpusHtmlProducerFactory {
    private static final int CORPUS_ADMIN = 1;
    private static final int FICHE = 3;

    private CorpusHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String page = parameters.getOutput();
        BdfServer bdfServer = parameters.getBdfServer();
        RequestMap requestMap = parameters.getRequestMap();
        PermissionChecker permissionChecker = requestHandler.getPermissionChecker();
        switch (CorpusHtmlProducerFactory.getPageType(page)) {
            case 1: {
                Corpus corpus = requestHandler.getCorpus();
                permissionChecker.checkSubsetAdmin(corpus);
                switch (page) {
                    case "corpus-conf": {
                        return new CorpusConfHtmlProducer(parameters, corpus);
                    }
                    case "corpus": {
                        return new CorpusHtmlProducer(parameters, corpus);
                    }
                    case "corpus-advancedcommands": {
                        return new CorpusAdvancedCommandsHtmlProducer(parameters, corpus);
                    }
                    case "corpus-diagram": {
                        return new CorpusDiagramHtmlProducer(parameters, corpus);
                    }
                    case "corpus-phrasesform": {
                        return new CorpusPhrasesFormHtmlProducer(parameters, corpus);
                    }
                    case "field-creationform": {
                        return new FieldCreationFormHtmlProducer(parameters, corpus);
                    }
                    case "field-optionsform": {
                        return new FieldOptionsFormHtmlProducer(parameters, corpus);
                    }
                    case "field-removeform": {
                        return new FieldRemoveFormHtmlProducer(parameters, corpus);
                    }
                    case "include-addenda": {
                        return new AddendaIncludeHtmlProducer(parameters, corpus);
                    }
                    case "include-album": {
                        return new AlbumIncludeHtmlProducer(parameters, corpus);
                    }
                    case "include-comment": {
                        return new CommentIncludeHtmlProducer(parameters, corpus);
                    }
                    case "include-corpus": {
                        return new CorpusIncludeHtmlProducer(parameters, corpus);
                    }
                    case "include-externalsource": {
                        return new ExternalSourceIncludeHtmlProducer(parameters, corpus);
                    }
                    case "include-special": {
                        return new SpecialIncludeHtmlProducer(parameters, corpus);
                    }
                    case "include-thesaurus": {
                        return new ThesaurusIncludeHtmlProducer(parameters, corpus);
                    }
                    case "removedlist": {
                        return new RemovedListHtmlProducer(parameters, corpus);
                    }
                    case "ui-componentattributesform": {
                        return new UiComponentAttributesFormHtmlProducer(parameters, corpus);
                    }
                    case "ui-componentoptionsform": {
                        return new UiComponentOptionsFormHtmlProducer(parameters, corpus);
                    }
                    case "ui-componentpositionform": {
                        return new UiComponentPositionFormHtmlProducer(parameters, corpus);
                    }
                }
                return null;
            }
            case 3: {
                FicheMeta ficheMeta = requestHandler.getFicheMeta();
                switch (page) {
                    case "fiche-advancedcommands": {
                        permissionChecker.checkSubsetAdmin(ficheMeta.getCorpus());
                        return new FicheAdvancedCommandsHtmlProducer(parameters, ficheMeta);
                    }
                    case "fiche-removeform": {
                        permissionChecker.checkSubsetAdmin(ficheMeta.getCorpus());
                        return new FicheRemoveFormHtmlProducer(parameters, ficheMeta);
                    }
                    case "fiche-discardform": {
                        permissionChecker.checkWrite(ficheMeta);
                        return new FicheDiscardFormHtmlProducer(parameters, ficheMeta);
                    }
                    case "fiche-retrieveform": {
                        permissionChecker.checkWrite(ficheMeta);
                        return new FicheRetrieveFormHtmlProducer(parameters, ficheMeta);
                    }
                    case "fiche-addenda": {
                        permissionChecker.checkWrite(ficheMeta);
                        FichePointeur fichePointeur = CorpusHtmlProducerFactory.toFichePointeur(ficheMeta);
                        FormEntryProvider formEntryProvider = CorpusHtmlProducerFactory.getFormEntryProvider(parameters);
                        UiComponents uiComponents = CorpusHtmlProducerFactory.getUiComponents(bdfServer, requestMap, ficheMeta.getCorpus());
                        return new FicheAddendaHtmlProducer(parameters, fichePointeur, formEntryProvider, uiComponents);
                    }
                    case "fiche-album": {
                        permissionChecker.checkWrite(ficheMeta);
                        FichePointeur fichePointeur = CorpusHtmlProducerFactory.toFichePointeur(ficheMeta);
                        FormEntryProvider formEntryProvider = CorpusHtmlProducerFactory.getFormEntryProvider(parameters);
                        UiComponents uiComponents = CorpusHtmlProducerFactory.getUiComponents(bdfServer, requestMap, ficheMeta.getCorpus());
                        return new FicheAlbumHtmlProducer(parameters, fichePointeur, formEntryProvider, uiComponents);
                    }
                }
                return null;
            }
        }
        switch (page) {
            case "corpus-creationform": {
                permissionChecker.checkFichothequeAdmin();
                return new CorpusCreationFormHtmlProducer(parameters);
            }
            case "duplicationlog": {
                SubsetMatch subsetMatch = (SubsetMatch)parameters.getResultObject("obj.subsetmatch");
                return new DuplicationLogHtmlProducer(parameters, subsetMatch);
            }
            case "reponderationlog": {
                ReponderationLog reponderationLog = (ReponderationLog)parameters.getResultObject("obj.duplicationlog");
                return new ReponderationLogHtmlProducer(parameters, reponderationLog);
            }
        }
        return null;
    }

    private static int getPageType(String page) {
        switch (page) {
            case "corpus": 
            case "corpus-advancedcommands": 
            case "corpus-conf": 
            case "corpus-diagram": 
            case "corpus-phrasesform": 
            case "field-creationform": 
            case "field-optionsform": 
            case "field-removeform": 
            case "include-addenda": 
            case "include-album": 
            case "include-comment": 
            case "include-corpus": 
            case "include-externalsource": 
            case "include-special": 
            case "include-thesaurus": 
            case "ui-componentattributesform": 
            case "ui-componentoptionsform": 
            case "ui-componentpositionform": 
            case "removedlist": {
                return 1;
            }
            case "fiche-advancedcommands": 
            case "fiche-removeform": 
            case "fiche-discardform": 
            case "fiche-retrieveform": 
            case "fiche-addenda": 
            case "fiche-album": {
                return 3;
            }
        }
        return 0;
    }

    private static UiComponents getUiComponents(BdfServer bdfServer, RequestMap requestMap, Corpus corpus) {
        UiManager uiManager = bdfServer.getUiManager();
        return uiManager.getMainUiComponents(corpus);
    }

    private static FichePointeur toFichePointeur(FicheMeta ficheMeta) {
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur(ficheMeta.getCorpus());
        fichePointeur.setCurrentSubsetItem(ficheMeta);
        return fichePointeur;
    }

    private static FormEntryProvider getFormEntryProvider(BdfParameters bdfParameters) {
        return FormEntryProviderFactory.newInstance(FicheFormParametersBuilder.build(bdfParameters).toFicheFormParameters());
    }
}

