/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.streamproducers.MissingFicheHtmlProducer;
import fr.exemole.bdfserver.get.streamproducers.transformation.TransformationFactory;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.corpus.SortConstants;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.exceptions.BadRequestException;
import net.mapeadores.util.servlets.exceptions.ForbiddenException;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.ResponseHandlerFactory;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;
import net.mapeadores.util.servlets.handlers.XmlResponseHandler;
import net.mapeadores.util.text.FileName;
import net.mapeadores.util.text.ValidExtension;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FichesInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final RequestMap requestMap;
    private final String filePath;

    public FichesInstruction(BdfServer bdfServer, RequestMap requestMap, String filePath) {
        this.bdfServer = bdfServer;
        this.filePath = filePath;
        this.requestMap = requestMap;
    }

    @Override
    public short getBdfUserNeed() {
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        FicheMeta ficheMeta;
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
        PathInfo pathInfo = this.parsePath();
        if (pathInfo == null) {
            return null;
        }
        if (pathInfo.isCompilation()) {
            return this.getCompilationResponseHandler(bdfParameters, pathInfo);
        }
        String ficheIdPart = pathInfo.getFicheIdPart();
        Corpus corpus = pathInfo.getCorpus();
        if (ficheIdPart.equals("test")) {
            if (corpus.size() == 0) {
                throw new BadRequestException("_ error.unsupported.emptycorpus_test", new Object[0]);
            }
            ficheMeta = this.getTestFicheMeta(corpus, bdfUser);
        } else {
            try {
                int id = Integer.parseInt(ficheIdPart);
                if (id < 1) {
                    throw new BadRequestException("_ error.wrong.id", ficheIdPart);
                }
                ficheMeta = corpus.getFicheMetaById(id);
                if (ficheMeta == null) {
                    return this.getMissingFicheMetaResponseHandler(bdfParameters, corpus, id, pathInfo.getExtension());
                }
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("_ error.wrong.id", ficheIdPart);
            }
        }
        return this.getFicheResponseHandler(bdfParameters, ficheMeta, pathInfo);
    }

    private FicheMeta getTestFicheMeta(Corpus corpus, BdfUser bdfUser) {
        List<FicheMeta> ficheMetaList = CorpusUtils.getFicheMetaListByCorpus(bdfUser.getSelectedFiches(), corpus);
        if (!ficheMetaList.isEmpty()) {
            return ficheMetaList.get(0);
        }
        return corpus.getFicheMetaList().get(0);
    }

    private ResponseHandler getFicheResponseHandler(BdfParameters bdfParameters, FicheMeta ficheMeta, PathInfo pathInfo) {
        boolean canRead = bdfParameters.getPermissionSummary().canRead(ficheMeta);
        if (!canRead) {
            if (pathInfo.getExtensionString().equals("html")) {
                return ResponseHandlerFactory.getHtmlErrorInstance(bdfParameters.getMessageLocalisation(), "_ error.permission.readfiche", ficheMeta.getGlobalId());
            }
            throw new ForbiddenException();
        }
        String extraXml = FichesInstruction.getExtraXml(this.requestMap);
        TransformationKey transformationKey = new TransformationKey(ficheMeta.getSubsetKey());
        ExtractionContext extractionContext = bdfParameters.getDefaultExtractionContext();
        TransformationFactory transformationFactory = TransformationFactory.init(bdfParameters).extractionContext(extractionContext).transformationKey(transformationKey).templateName(pathInfo.getTemplateName()).dynamicObject(ficheMeta).extraXml(extraXml);
        switch (pathInfo.getExtensionString()) {
            case "xml": {
                return XmlResponseHandler.init(transformationFactory.getSourceXmlProducer());
            }
            case "html": {
                return StreamResponseHandler.init(transformationFactory.getStreamProducer());
            }
            case "odcontent": {
                return this.extractOdFile(transformationFactory.streamExtension(ValidExtension.ODT).outputProperty("indent", "yes").getStreamProducer(), "content.xml");
            }
            case "odstyles": {
                return this.extractOdFile(transformationFactory.streamExtension(ValidExtension.ODT).getStreamProducer(), "styles.xml");
            }
        }
        return StreamResponseHandler.init(transformationFactory.streamExtension(pathInfo.getExtension()).getStreamProducer());
    }

    private ResponseHandler getCompilationResponseHandler(BdfParameters bdfParameters, PathInfo pathInfo) {
        Fiches fiches;
        BdfUser bdfUser = bdfParameters.getBdfUser();
        TransformationKey transformationKey = TransformationKey.COMPILATION_INSTANCE;
        String extraXml = FichesInstruction.getExtraXml(this.requestMap);
        int limit = FichesInstruction.getLimit(this.requestMap);
        try {
            FicheQuery ficheQuery = FichesInstruction.getFicheQuery(this.requestMap, bdfParameters.getFichotheque());
            if (ficheQuery != null) {
                String sortType = FichesInstruction.getSortType(this.requestMap);
                PermissionSummary permissionSummary = bdfParameters.getPermissionSummary();
                SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(bdfParameters).setSubsetAccessPredicate(permissionSummary.getSubsetAccessPredicate()).setFichePredicate(PermissionUtils.getFichePredicate(permissionSummary)).toSelectionContext();
                FicheSelector ficheSelector = FicheSelectorBuilder.init(selectionContext).add(ficheQuery).toFicheSelector();
                fiches = FichesBuilder.build(sortType, bdfUser.getWorkingLang()).initSubsetKeyOrder(TreeUtils.getCorpusKeyList(this.bdfServer)).populate(ficheSelector).toFiches();
            } else {
                fiches = bdfUser.getSelectedFiches();
            }
        }
        catch (ErrorMessageException eme) {
            return ResponseHandlerFactory.getHtmlInstance(bdfParameters.getMessageLocalisation(), eme.getErrorMessage());
        }
        if (limit > 0) {
            fiches = CorpusUtils.reduce(fiches, limit);
        }
        ExtractionContext extractionContext = bdfParameters.getDefaultExtractionContext();
        TransformationFactory transformationFactory = TransformationFactory.init(bdfParameters).extractionContext(extractionContext).transformationKey(transformationKey).templateName(pathInfo.getTemplateName()).extraXml(extraXml).staticFiches(fiches);
        switch (pathInfo.getExtension().toString()) {
            case "xml": {
                return XmlResponseHandler.init(transformationFactory.getSourceXmlProducer());
            }
            case "html": {
                return StreamResponseHandler.init(transformationFactory.getStreamProducer());
            }
            case "odcontent": {
                return this.extractOdFile(transformationFactory.streamExtension(ValidExtension.ODT).outputProperty("indent", "yes").getStreamProducer(), "content.xml");
            }
            case "odstyles": {
                return this.extractOdFile(transformationFactory.streamExtension(ValidExtension.ODT).getStreamProducer(), "styles.xml");
            }
        }
        return StreamResponseHandler.init(transformationFactory.streamExtension(pathInfo.getExtension()).getStreamProducer());
    }

    private ResponseHandler getMissingFicheMetaResponseHandler(BdfParameters bdfParameters, Corpus corpus, int ficheId, ValidExtension validExtension) {
        if (!validExtension.toString().equals("html")) {
            throw new BadRequestException("_ error.unknown.id", String.valueOf(ficheId));
        }
        SubsetKey corpusKey = corpus.getSubsetKey();
        int level = bdfParameters.getPermissionSummary().getReadLevel(corpusKey);
        if (level == 0) {
            return ResponseHandlerFactory.getHtmlErrorInstance(bdfParameters.getMessageLocalisation(), "_ error.permission.readfiche", FichothequeUtils.toGlobalId(corpusKey, ficheId));
        }
        return HtmlResponseHandler.init(new MissingFicheHtmlProducer(bdfParameters, corpus, ficheId));
    }

    private ResponseHandler extractOdFile(StreamProducer streamProducer, String file) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try {
            streamProducer.writeStream(byteOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String contentString = "";
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(byteOutputStream.toByteArray()));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String name = zipEntry.getName();
                if (!name.equals(file)) continue;
                contentString = IOUtils.toString(zis, "UTF-8");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return XmlResponseHandler.init(XMLUtils.toXmlProducer(contentString));
    }

    private PathInfo parsePath() {
        Corpus corpus;
        ValidExtension validExtension;
        FileName fileName;
        try {
            fileName = FileName.parse(this.filePath);
        }
        catch (ParseException pe) {
            return null;
        }
        String baseName = fileName.getBasename();
        try {
            validExtension = ValidExtension.parse(fileName.getExtension());
        }
        catch (ParseException pe) {
            throw new BadRequestException("_ error.wrong.extension", fileName.getExtension());
        }
        String[] tokens = baseName.split("-");
        int length = tokens.length;
        if (length < 1) {
            return null;
        }
        String firstToken = tokens[0];
        if (FichesInstruction.isCompilation(firstToken, length)) {
            String templateName = "";
            if (length > 1) {
                templateName = tokens[1];
            }
            templateName = this.checkTemplateName(templateName);
            return new PathInfo(validExtension, templateName);
        }
        if (length < 2) {
            return null;
        }
        try {
            SubsetKey corpusKey = SubsetKey.parse((short)1, firstToken);
            corpus = (Corpus)this.bdfServer.getFichotheque().getSubset(corpusKey);
        }
        catch (ParseException pe) {
            throw new BadRequestException("_ error.wrong.corpusname", firstToken);
        }
        if (corpus == null) {
            throw new BadRequestException("_ error.unknown.corpus", firstToken);
        }
        String templateName = "";
        if (length > 2) {
            templateName = tokens[2];
        }
        templateName = this.checkTemplateName(templateName);
        return new PathInfo(corpus, tokens[1], validExtension, templateName);
    }

    private String checkTemplateName(String templateName) {
        String templateParam = this.requestMap.getParameter("template");
        if (templateParam != null) {
            templateName = templateParam;
        }
        return templateName;
    }

    private static String getExtraXml(RequestMap requestMap) {
        String testError;
        String extraXml = requestMap.getParameter("extra-xml");
        if (extraXml != null && (testError = XMLUtils.testXml("<root>" + extraXml + "</root>")) != null) {
            extraXml = "<error>" + XMLUtils.escape(testError) + "<error>";
        }
        return extraXml;
    }

    private static int getLimit(RequestMap requestMap) {
        int limit = 0;
        String limitString = requestMap.getParameter("limit");
        if (limitString != null) {
            try {
                limit = Integer.parseInt(limitString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return limit;
    }

    private static FicheQuery getFicheQuery(RequestMap requestMap, Fichotheque fichotheque) throws ErrorMessageException {
        String queryXml = requestMap.getParameter("query-xml");
        if (queryXml != null) {
            Document document;
            try {
                document = DOMUtils.parseDocument(queryXml);
            }
            catch (SAXException sae) {
                throw new ErrorMessageException("_ error.exception.xml.sax", sae.getMessage());
            }
            Element root = document.getDocumentElement();
            switch (root.getTagName()) {
                case "fiche-query": 
                case "fiche-select": {
                    return SelectionDOMUtils.getFicheConditionEntry(fichotheque, root).getFicheQuery();
                }
            }
            throw new ErrorMessageException("_ error.wrong.xml.root", root.getTagName(), "fiche-query");
        }
        return null;
    }

    private static String getSortType(RequestMap requestMap) throws ErrorMessageException {
        String sorttypeParamValue = requestMap.getParameter("sorttype");
        if (sorttypeParamValue != null) {
            try {
                return SortConstants.checkSortType(sorttypeParamValue);
            }
            catch (IllegalArgumentException iae) {
                throw BdfErrors.unknownParameterValue("sorttype", sorttypeParamValue);
            }
        }
        return "id-asc";
    }

    private static boolean isCompilation(String token, int tokenLength) {
        switch (token) {
            case "compilation": {
                return tokenLength == 1;
            }
            case "_compilation": {
                return true;
            }
        }
        return false;
    }

    private static class PathInfo {
        private final Corpus corpus;
        private final String ficheIdPart;
        private final ValidExtension extension;
        private final String templateName;

        private PathInfo(ValidExtension extension, String templateName) {
            this(null, null, extension, templateName);
        }

        private PathInfo(Corpus corpus, String ficheIdPart, ValidExtension extension, String templateName) {
            this.corpus = corpus;
            this.ficheIdPart = ficheIdPart;
            this.extension = extension;
            this.templateName = templateName;
        }

        public boolean isCompilation() {
            return this.corpus == null;
        }

        public Corpus getCorpus() {
            return this.corpus;
        }

        public String getFicheIdPart() {
            return this.ficheIdPart;
        }

        public String getExtensionString() {
            return this.extension.toString();
        }

        public ValidExtension getExtension() {
            return this.extension;
        }

        public String getTemplateName() {
            return this.templateName;
        }
    }
}

