/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.email.datasource;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.email.datasource.XsltStreamDataSource;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.DefaultExtractionDefFactory;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformerParameters;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import javax.activation.DataSource;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.transformation.NoDefaultTemplateException;
import net.fichotheque.exportation.transformation.StreamTemplate;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.ExtractionSource;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.tools.extraction.ExtractionEngine;
import net.fichotheque.tools.extraction.ExtractionEngineUtils;
import net.mapeadores.util.text.ValidExtension;

public class StreamDataSourceFactory {
    private StreamDataSourceFactory() {
    }

    public static DataSource newFicheInstance(BdfParameters bdfParameters, FicheMeta ficheMeta, ValidExtension extension, String templateName) {
        SubsetKey corpusKey = ficheMeta.getSubsetKey();
        String name = corpusKey.getSubsetName() + "-" + String.valueOf(ficheMeta.getId()) + "." + extension.toString();
        TemplateKey templateKey = StreamDataSourceFactory.getTemplateKey(new TransformationKey(corpusKey), extension, templateName, bdfParameters);
        ExtractionContext extractionContext = bdfParameters.getDefaultExtractionContext();
        StreamTemplate streamTemplate = StreamDataSourceFactory.getStreamTemplate(bdfParameters.getBdfServer(), templateKey);
        if (streamTemplate instanceof StreamTemplate.Xslt) {
            return StreamDataSourceFactory.initXslt((StreamTemplate.Xslt)streamTemplate, bdfParameters, templateKey, name, extractionContext, ficheMeta, null);
        }
        throw new IllegalStateException("unknown streamTemplate Type");
    }

    public static DataSource newCompilationInstance(BdfParameters bdfParameters, Fiches fiches, ValidExtension extension, String templateName) {
        String name = "compilation." + extension.toString();
        ExtractionContext extractionContext = bdfParameters.getDefaultExtractionContext();
        TemplateKey templateKey = StreamDataSourceFactory.getTemplateKey(TransformationKey.COMPILATION_INSTANCE, extension, templateName, bdfParameters);
        StreamTemplate streamTemplate = StreamDataSourceFactory.getStreamTemplate(bdfParameters.getBdfServer(), templateKey);
        if (streamTemplate instanceof StreamTemplate.Xslt) {
            return StreamDataSourceFactory.initXslt((StreamTemplate.Xslt)streamTemplate, bdfParameters, templateKey, name, extractionContext, null, fiches);
        }
        throw new IllegalStateException("unknown streamTemplate Type");
    }

    private static TemplateKey getTemplateKey(TransformationKey transformationKey, ValidExtension extension, String templateName, BdfParameters bdfParameters) {
        TemplateKey templateKey;
        if (templateName == null) {
            return BdfUserUtils.getStreamTemplateKey(bdfParameters, transformationKey, extension);
        }
        try {
            templateKey = TemplateKey.parse(transformationKey, extension, templateName);
        }
        catch (ParseException pe) {
            templateKey = TemplateKey.toDefault(transformationKey, extension);
        }
        return templateKey;
    }

    private static StreamTemplate getStreamTemplate(BdfServer bdfServer, TemplateKey templateKey) {
        StreamTemplate streamTemplate;
        TransformationManager transformationManager = bdfServer.getTransformationManager();
        try {
            streamTemplate = transformationManager.getStreamTemplate(templateKey, true);
        }
        catch (NoDefaultTemplateException ndte) {
            throw new IllegalStateException("Bad streamTemplateName and no default: " + templateKey);
        }
        return streamTemplate;
    }

    private static DataSource initXslt(StreamTemplate.Xslt streamTemplate, BdfParameters bdfParameters, TemplateKey templateKey, String name, ExtractionContext extractionContext, Object dynamicObject, Fiches staticFiches) {
        ExtractionDef extractionDef = streamTemplate.getCustomExtractionDef();
        if (extractionDef == null) {
            extractionDef = DefaultExtractionDefFactory.newInstance(bdfParameters.getBdfServer(), templateKey.getTransformationKey(), streamTemplate.getAttributes());
        }
        ExtractionSource extractionSource = ExtractionEngineUtils.getExtractionSource(dynamicObject, extractionContext, extractionDef, staticFiches);
        ExtractParameters extractParameters = BdfTransformationUtils.buildExtractParameters(extractionContext, streamTemplate.getAttributes(), bdfParameters, null);
        String extractionString = ExtractionEngine.init(extractParameters, extractionDef).run(extractionSource);
        TransformerParameters transformerParameters = TransformerParameters.build(bdfParameters).check(streamTemplate.getAttributes()).put("INCLUDESCRIPTS", "");
        return new XsltStreamDataSource(name, streamTemplate, extractionString, transformerParameters);
    }
}

