/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.sync.SyncEngine;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.fichotheque.namespaces.SyncSpace;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.sync.ThesaurusSync;
import net.fichotheque.tools.thesaurus.sync.ThesaurusSyncResult;
import net.fichotheque.tools.thesaurus.sync.ThesaurusSyncUtils;
import net.mapeadores.util.exceptions.ResponseCodeException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import org.xml.sax.SAXException;

public class ThesaurusSyncCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ThesaurusSync";
    private Thesaurus thesaurus;
    private URL url;

    public ThesaurusSyncCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        ThesaurusSyncResult syncResult;
        ThesaurusSync thesaurusSync;
        try {
            thesaurusSync = ThesaurusSyncUtils.download(this.url, LogUtils.NULL_MESSAGEHANDLER);
        }
        catch (ResponseCodeException rce) {
            throw BdfErrors.error("_ error.exception.url_httpcode", rce.getHttpStatusCode());
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.url_io", this.url);
        }
        catch (SAXException saxe) {
            throw BdfErrors.error("_ error.exception.xml.sax", saxe.getLocalizedMessage());
        }
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            syncResult = SyncEngine.runThesaurusSync(session, this.requestHandler, thesaurusSync, this.thesaurus);
        }
        this.putResultObject("obj.thesaurus", this.thesaurus);
        if (syncResult.isEmpty()) {
            this.setDone("_ done.thesaurus.sync_nochange", new Object[0]);
        } else {
            this.setDone("_ done.thesaurus.sync", syncResult.getChangeCount(), syncResult.getCreationCount(), syncResult.getOrderCount());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.checkSubsetAdmin(this.thesaurus);
        String urlString = ThesaurusSyncUtils.getSyncUrl(this.thesaurus);
        if (urlString == null) {
            throw BdfErrors.error("_ error.empty.attribute", SyncSpace.URL_KEY);
        }
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException mue) {
            throw BdfErrors.error("_ error.wrong.url", urlString);
        }
    }
}

