/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.tools.junction.TieBuffer;
import net.fichotheque.tools.parsers.junction.TieBufferParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class MotcleIndexationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleIndexation";
    public static final String COMMANDKEY = "_ THS-13";
    private Motcle motcle;
    private List<TieByCorpus> tieByCorpusList;

    public MotcleIndexationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            JunctionEditor junctionEditor = session.getFichothequeEditor().getJunctionEditor();
            ArrayList<IncludeKey> scopeList = new ArrayList<IncludeKey>();
            for (TieByCorpus tieByCorpus : this.tieByCorpusList) {
                scopeList.add(IncludeKey.newInstance(tieByCorpus.corpus.getSubsetKey()));
            }
            JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.clearExistingEngine(this.motcle, scopeList);
            for (TieByCorpus tieByCorpus : this.tieByCorpusList) {
                for (TieBuffer tieBuffer : tieByCorpus.tieBufferList) {
                    junctionChangeEngine.addTie(tieBuffer);
                }
            }
            junctionEditor.updateJunctions(this.motcle, junctionChangeEngine.toJunctionChanges());
        }
        this.putResultObject("obj.thesaurus", this.motcle.getThesaurus());
        this.putResultObject("obj.motcle", this.motcle);
        this.setDone("_ done.thesaurus.motcleindexation", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        this.checkSubsetAdmin(this.motcle.getThesaurus());
        PermissionSummary permissionSummary = this.requestHandler.getPermissionSummary();
        this.tieByCorpusList = new ArrayList<TieByCorpus>();
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            String param_value;
            if (!permissionSummary.hasAccess(corpus) || (param_value = this.requestHandler.getTrimedParameter(corpus.getSubsetKeyString())).isEmpty()) continue;
            this.tieByCorpusList.add(this.parse(corpus, param_value));
        }
    }

    private TieByCorpus parse(Corpus corpus, String chaine) {
        String[] tokens = StringUtils.getTechnicalTokens(chaine, false);
        ArrayList<TieBuffer> tieBufferList = new ArrayList<TieBuffer>();
        for (String token : tokens) {
            try {
                TieBuffer tieBuffer = TieBufferParser.parseId(corpus, token, null, -1);
                tieBufferList.add(tieBuffer);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new TieByCorpus(corpus, tieBufferList);
    }

    private static class TieByCorpus {
        private final Corpus corpus;
        private final List<TieBuffer> tieBufferList;

        private TieByCorpus(Corpus corpus, List<TieBuffer> tieBufferList) {
            this.corpus = corpus;
            this.tieBufferList = tieBufferList;
        }
    }
}

