/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.table.FicheTableParameters;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.tools.exportation.table.DefaultTableDefFactory;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.EditOrigin;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TableExportContentCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TableExportContentCreation";
    public static final String CORPUS_COMMANDKEY = "_ EXP-14";
    public static final String THESAURUS_COMMANDKEY = "_ EXP-15";
    private String tableExportName;
    private FicheTableParameters ficheTableParameters;
    private Subset subset;

    public TableExportContentCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        TableExportManager tableExportManager = this.bdfServer.getTableExportManager();
        SubsetKey subsetKey = this.subset.getSubsetKey();
        TableDef tableDef = this.subset instanceof Corpus ? DefaultTableDefFactory.fromUi(this.bdfServer, (Corpus)this.subset, this.ficheTableParameters, this.requestHandler.getPermissionSummary()) : DefaultTableDefFactory.fromThesaurusMetadata((Thesaurus)this.subset, this.bdfServer.getThesaurusLangChecker());
        TableExportDescription tableExportDescription = tableExportManager.putTableDef(this.tableExportName, subsetKey, tableDef, editOrigin);
        this.putResultObject("obj.tableexportdescription", tableExportDescription);
        this.setDone("_ done.exportation.tableexportcontentcreation", this.tableExportName, subsetKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TableExportDescription tableExportDescription = this.requestHandler.getMandatoryTableExportDescription();
        if (!tableExportDescription.isEditable()) {
            throw BdfErrors.unsupportedNotEditableParameterValue("tableexport", tableExportDescription.getName());
        }
        this.tableExportName = tableExportDescription.getName();
        this.subset = this.requestHandler.getMandatorySubset();
        SubsetKey subsetKey = this.subset.getSubsetKey();
        String subsetString = subsetKey.toString();
        if (!subsetKey.isCorpusSubset() && !subsetKey.isThesaurusSubset()) {
            throw BdfErrors.unsupportedParameterValue("subset", subsetString);
        }
        if (TableExportUtils.getTableExportContentDescription(tableExportDescription, subsetString) != null) {
            throw BdfErrors.unsupportedNotEditableParameterValue("subset", subsetString);
        }
        if (this.subset instanceof Corpus) {
            this.ficheTableParameters = this.requestHandler.getFicheTableParameters();
        }
    }
}

