/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.tools.corpus.CorpusTools;
import net.fichotheque.tools.corpus.FieldGenerationEngine;
import net.fichotheque.tools.corpus.PurgeEngine;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ReloadCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Reload";
    public static final String COMMANDKEY = "_ CRP-20";
    public static final String PURGE_PARAMNAME = "purge";
    private Corpus corpus;
    private boolean purge;

    public ReloadCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            CorpusEditor corpusEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus.getSubsetKey());
            FieldGenerationEngine engine = BdfCommandUtils.buildEngine(this.requestHandler, this.corpus);
            PurgeEngine purgeEngine = null;
            if (this.purge) {
                purgeEngine = new PurgeEngine(CorpusMetadataUtils.getFieldKeyPredicate(this.corpus.getCorpusMetadata()));
            }
            for (FicheMeta ficheMeta : this.corpus.getFicheMetaList()) {
                Fiche fiche = this.corpus.getFiche(ficheMeta);
                if (purgeEngine != null) {
                    purgeEngine.purge(fiche);
                }
                CorpusTools.saveFiche(corpusEditor, ficheMeta, fiche, engine, false);
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.setDone("_ done.corpus.reload", this.corpus.getFicheMetaList().size());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.purge = this.requestHandler.isTrue(PURGE_PARAMNAME);
    }
}

