/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.FieldGeneration;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.fichotheque.tools.corpus.FieldGenerationParser;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FieldOptionUtils;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LineLogsBuilder;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.request.RequestMap;

public class FieldOptionsCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FieldOptions";
    public static final String COMMANDKEY = "_ CRP-07";
    public static final String DEFAULTSPHERE_SUFFIX = "|defaultsphere";
    public static final String BLOCKDISPLAY_SUFFIX = "|blockdisplay";
    public static final String SUBFIELDDISPLAY_SUFFIX = "|subfielddisplay";
    public static final String CURRENCIES_SUFFIX = "|currencies";
    public static final String BASEURL_SUFFIX = "|baseurl";
    public static final String FIELDGENERATION_PARAMNAME = "fieldgeneration";
    public static final String ADDRESSFIELDARRAY_SUFFIX = "|addressfieldarray";
    public static final String GEOLOCALISATIONFIELD_PARAMNAME = "geolocalisationfield";
    public static final String LANGSCOPE_SUFFIX = "|langscope";
    public static final String LANGS_SUFFIX = "|langs";
    public static final String ALL_LANGSCOPE = "all";
    public static final String CONFIG_LANGSCOPE = "config";
    public static final String MULTILANG_LANGSCOPE = "mul";
    public static final String NOLINGUISTICCONTENT_LANGSCOPE = "zxx";
    public static final String LIST_LANGSCOPE = "list";
    private static final Lang[] MULTILANG_ARRAY = new Lang[]{Lang.build("mul")};
    private static final Lang[] NOLINGUISTICCONTENT_ARRAY = new Lang[]{Lang.build("zxx")};
    private Corpus corpus;
    private boolean initGeolocalisationField = false;
    private CorpusField geolocalisationField = null;
    private FieldGeneration fieldGeneration;

    public FieldOptionsCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done = false;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            boolean fieldGenerationDone;
            CorpusMetadata corpusMetadata = this.corpus.getCorpusMetadata();
            CorpusMetadataEditor corpusMetadataEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus).getCorpusMetadataEditor();
            if (this.fieldGeneration != null && (fieldGenerationDone = corpusMetadataEditor.setFieldGeneration(this.fieldGeneration))) {
                done = true;
            }
            if (this.initGeolocalisationField) {
                try {
                    boolean geoDone = corpusMetadataEditor.setGeolocalisationField(this.geolocalisationField);
                    if (geoDone) {
                        done = true;
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new ImplementationException(iae);
                }
            }
            for (CorpusField corpusField : corpusMetadata.getPropList()) {
                if (!this.setOptions(corpusMetadataEditor, corpusField)) continue;
                done = true;
            }
            for (CorpusField corpusField : corpusMetadata.getInfoList()) {
                if (!this.setOptions(corpusMetadataEditor, corpusField)) continue;
                done = true;
            }
            CorpusField langCorpusField = corpusMetadata.getCorpusField(FieldKey.LANG);
            boolean langDone = this.setLangOption(corpusMetadataEditor, langCorpusField);
            if (langDone) {
                done = true;
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.fieldoptions", new Object[0]);
            this.bdfServer.getTransformationManager().clearDistTransformer();
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        CorpusMetadata corpusMetadata = this.corpus.getCorpusMetadata();
        if (this.requestHandler.hasParameter(FIELDGENERATION_PARAMNAME)) {
            String fieldGenerationRawString = this.requestHandler.getMandatoryParameter(FIELDGENERATION_PARAMNAME);
            LineLogsBuilder lineLogsBuilder = new LineLogsBuilder();
            this.fieldGeneration = FieldGenerationParser.parse(fieldGenerationRawString, lineLogsBuilder);
            if (lineLogsBuilder.hasMessage()) {
                CommandMessageBuilder commandMessageBuilder = CommandMessageBuilder.init();
                for (LineMessage lineMessage : lineLogsBuilder.toLineMessageList()) {
                    commandMessageBuilder.addMultiError(lineMessage);
                }
                throw BdfErrors.error(commandMessageBuilder, "_ error.list.options");
            }
        }
        if (!this.requestHandler.hasParameter(GEOLOCALISATIONFIELD_PARAMNAME)) {
            this.initGeolocalisationField = false;
        } else {
            this.initGeolocalisationField = true;
            String geolocalisationFieldString = this.requestHandler.getTrimedParameter(GEOLOCALISATIONFIELD_PARAMNAME);
            if (geolocalisationFieldString.isEmpty()) {
                this.geolocalisationField = null;
            } else {
                boolean done = false;
                try {
                    CorpusField corpusField;
                    FieldKey fieldKey = FieldKey.parse(geolocalisationFieldString);
                    if (fieldKey.isProp() && (corpusField = corpusMetadata.getCorpusField(fieldKey)) != null && corpusField.isType("geopoint")) {
                        done = true;
                        this.geolocalisationField = corpusField;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (!done) {
                    throw BdfErrors.wrongParameterValue(GEOLOCALISATIONFIELD_PARAMNAME, geolocalisationFieldString);
                }
            }
        }
    }

    private boolean setOptions(CorpusMetadataEditor corpusMetadataEditor, CorpusField corpusField) throws ErrorMessageException {
        OptionEngine optionEngine = new OptionEngine(corpusMetadataEditor, corpusField);
        return optionEngine.run();
    }

    private boolean setLangOption(CorpusMetadataEditor corpusMetadataEditor, CorpusField corpusField) throws ErrorMessageException {
        OptionEngine optionEngine = new OptionEngine(corpusMetadataEditor, corpusField);
        return optionEngine.runLang();
    }

    private class OptionEngine {
        private final CorpusMetadataEditor corpusMetadataEditor;
        private final CorpusField corpusField;
        private boolean oneDone = false;

        private OptionEngine(CorpusMetadataEditor corpusMetadataEditor, CorpusField corpusField) {
            this.corpusMetadataEditor = corpusMetadataEditor;
            this.corpusField = corpusField;
        }

        private boolean run() throws ErrorMessageException {
            this.setDisplay();
            this.setSubfieldDisplay();
            this.setOption("defaultSphereKey", FieldOptionsCommand.DEFAULTSPHERE_SUFFIX);
            this.setOption("currencyArray", FieldOptionsCommand.CURRENCIES_SUFFIX);
            this.setOption("addressFieldArray", FieldOptionsCommand.ADDRESSFIELDARRAY_SUFFIX);
            this.setOption("baseUrl", FieldOptionsCommand.BASEURL_SUFFIX);
            return this.oneDone;
        }

        private boolean runLang() throws ErrorMessageException {
            String langScope;
            String param = FieldOptionsCommand.this.requestHandler.getTrimedParameter(this.corpusField.getFieldString() + FieldOptionsCommand.LANGSCOPE_SUFFIX);
            Lang[] langArray = null;
            switch (param) {
                case "all": {
                    langScope = FieldOptionsCommand.ALL_LANGSCOPE;
                    break;
                }
                case "config": {
                    langScope = FieldOptionsCommand.CONFIG_LANGSCOPE;
                    break;
                }
                case "mul": {
                    langScope = FieldOptionsCommand.LIST_LANGSCOPE;
                    langArray = MULTILANG_ARRAY;
                    break;
                }
                case "zxx": {
                    langScope = FieldOptionsCommand.LIST_LANGSCOPE;
                    langArray = NOLINGUISTICCONTENT_ARRAY;
                    break;
                }
                case "list": {
                    langScope = FieldOptionsCommand.LIST_LANGSCOPE;
                    langArray = (Lang[])this.getOptionObject("langArray", FieldOptionsCommand.LANGS_SUFFIX);
                    if (langArray != null) break;
                    langScope = FieldOptionsCommand.CONFIG_LANGSCOPE;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (langScope.equals(CorpusMetadataUtils.getDefaultLangScope(this.corpusField.getFieldKey()))) {
                langScope = null;
            }
            try {
                boolean done1 = this.corpusMetadataEditor.setFieldOption(this.corpusField, "langScope", langScope);
                boolean done2 = this.corpusMetadataEditor.setFieldOption(this.corpusField, "langArray", langArray);
                if (done1 || done2) {
                    this.oneDone = true;
                }
            }
            catch (FieldOptionException foe) {
                throw new ImplementationException(foe);
            }
            return this.oneDone;
        }

        private void setDisplay() {
            String optionName = "infoDisplay";
            if (!FieldOptionUtils.testFieldOption(optionName, this.corpusField)) {
                return;
            }
            String value = null;
            if (FieldOptionsCommand.this.requestHandler.isTrue(this.corpusField.getFieldString() + FieldOptionsCommand.BLOCKDISPLAY_SUFFIX)) {
                value = "block";
            }
            try {
                boolean done = this.corpusMetadataEditor.setFieldOption(this.corpusField, optionName, value);
                if (done) {
                    this.oneDone = true;
                }
            }
            catch (FieldOptionException foe) {
                throw new ImplementationException(foe);
            }
        }

        private void setSubfieldDisplay() {
            String optionName = "subfieldDisplay";
            if (!FieldOptionUtils.testFieldOption(optionName, this.corpusField)) {
                return;
            }
            try {
                String value = FieldOptionsCommand.this.requestHandler.isTrue(this.corpusField.getFieldString() + FieldOptionsCommand.SUBFIELDDISPLAY_SUFFIX) ? "1" : null;
                boolean done = this.corpusMetadataEditor.setFieldOption(this.corpusField, optionName, value);
                if (done) {
                    this.oneDone = true;
                }
            }
            catch (FieldOptionException foe) {
                throw new ImplementationException(foe);
            }
        }

        private void setOption(String optionName, String paramSuffix) throws ErrorMessageException {
            if (!FieldOptionUtils.testFieldOption(optionName, this.corpusField)) {
                return;
            }
            Object optionObject = this.getOptionObject(optionName, paramSuffix);
            try {
                boolean done = this.corpusMetadataEditor.setFieldOption(this.corpusField, optionName, optionObject);
                if (done) {
                    this.oneDone = true;
                }
            }
            catch (FieldOptionException foe) {
                throw new ImplementationException(foe);
            }
        }

        private Object getOptionObject(String optionName, String paramSuffix) throws ErrorMessageException {
            String param = FieldOptionsCommand.this.requestHandler.getTrimedParameter(this.corpusField.getFieldString() + paramSuffix);
            try {
                return FieldOptionUtils.parseOptionValue(optionName, param);
            }
            catch (FieldOptionException foe) {
                return null;
            }
        }
    }
}

