/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.commands.album.AlbumCommandUtils;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.awt.ResizeInfo;
import net.mapeadores.util.images.ImageResizing;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ToolResizeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ToolResize";
    public static final String TMPFILE_PARAMNAME = "tmpfile";
    public static final String WIDTH_PARAMNAME = "width";
    public static final String HEIGHT_PARAMNAME = "height";
    private Album album;
    private File tmpFile;
    private Illustration illustration;
    private int width;
    private int height;
    private String extension;

    public ToolResizeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        File newTmpFile = AlbumCommandUtils.getTmpFile(this.bdfServer, this.extension);
        ResizeInfo resizeInfo = ResizeInfo.newFixedDimInstance(this.width, this.height);
        try (InputStream is = this.getInputStream();){
            ImageResizing.resize(is, newTmpFile, resizeInfo, this.extension);
            AlbumCommandUtils.minimizeTmpFile(newTmpFile, this.album);
        }
        catch (IOException ioe) {
            throw BdfErrors.ioException(ioe);
        }
        this.putResultObject("obj.tmpfile", newTmpFile);
        this.putResultObject("obj.album", this.album);
        this.setDone("_ done.album.toolresize", newTmpFile.getName());
    }

    private InputStream getInputStream() throws IOException {
        if (this.tmpFile != null) {
            return new FileInputStream(this.tmpFile);
        }
        return this.illustration.getInputStream("_original");
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.album = this.requestHandler.getMandatoryAlbum();
        this.width = this.requestHandler.getMandatoryIntegerParameter(WIDTH_PARAMNAME);
        this.height = this.requestHandler.getMandatoryIntegerParameter(HEIGHT_PARAMNAME);
        String tmpFileName = this.requestHandler.getTrimedParameter(TMPFILE_PARAMNAME);
        if (!tmpFileName.isEmpty() && !tmpFileName.equals("_ORIGINAL")) {
            File tmpDirectory = ConfigurationUtils.getTmpDirectory(this.bdfServer);
            this.tmpFile = new File(tmpDirectory, tmpFileName);
            if (!this.tmpFile.exists()) {
                throw BdfErrors.error("_ error.unknown.tmpfile", tmpFileName);
            }
            this.extension = AlbumUtils.getExtension(this.tmpFile);
        } else {
            this.illustration = (Illustration)this.requestHandler.getMandatorySubsetItem(this.album);
            this.extension = this.illustration.getFormatType();
        }
    }
}

