/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation.analytique;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.CustomLigneDef;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.Operation;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeDef;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;

public class AnalytiqueRecapTableEngine
extends TableEngine {
    private final AnalytiqueRecap analytiqueRecap;
    private final OdTableDef odTableDef;
    private final boolean ignoreEmpty;
    private final String title;

    public AnalytiqueRecapTableEngine(AnalytiqueRecap analytiqueRecap, ScarabeLocalisation scarabeLocalisation) {
        super(scarabeLocalisation);
        this.analytiqueRecap = analytiqueRecap;
        int maxLevel = AnalytiqueRecapTableEngine.getMaxLevel(analytiqueRecap, 0);
        int columnCount = (maxLevel + 1) * 2;
        OdTableDefBuilder odTableDefBuilder = new OdTableDefBuilder("");
        for (int i = 0; i < columnCount; ++i) {
            odTableDefBuilder.addStandard();
        }
        this.odTableDef = odTableDefBuilder.toOdTableDef();
        this.ignoreEmpty = analytiqueRecap.getAnalytiqueParameters().getMode() == 1;
        this.title = FichothequeUtils.getTitle((Subset)analytiqueRecap.getAnalytiqueParameters().getAnalytiqueSubset().getSubset(), (Lang)scarabeLocalisation.getWorkingLang());
    }

    @Override
    public OdTableDef getOdTableDef() {
        return this.odTableDef;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void writeHead(ScarabeTableWriter tableWriter) {
    }

    @Override
    public void writeBody(ScarabeTableWriter tableWriter) {
        if (this.analytiqueRecap.isRoot() && this.analytiqueRecap.getAnalytiqueParameters().hideRootRecap()) {
            for (AnalytiqueRecap subRecap : this.analytiqueRecap.getSubRecapList()) {
                this.printAnalytiqueRecap(tableWriter, subRecap, 0);
            }
        } else {
            this.printAnalytiqueRecap(tableWriter, this.analytiqueRecap, 0);
        }
    }

    private void printAnalytiqueRecap(ScarabeTableWriter tableWriter, AnalytiqueRecap analytiqueRecap, int level) {
        Lang workingLang = this.getScarabeLocalisation().getWorkingLang();
        Currencies currencies = analytiqueRecap.getCurrencies();
        if (this.ignoreEmpty && analytiqueRecap.isEmpty()) {
            return;
        }
        if (!analytiqueRecap.isRoot()) {
            String libelle = ScarabeUtils.getLibelle(analytiqueRecap.getRecapObject(), workingLang);
            tableWriter.startRow((short)105);
            tableWriter.addNullCell(level * 2);
            tableWriter.addStringCell(libelle, 2);
            tableWriter.endRow();
        }
        for (Operation operation : analytiqueRecap.getOperationList()) {
            OperationDef operationDef = operation.getOperationDef();
            MoneyByCurrency moneyByCurrency = operation.getMoneyByCurrency();
            if (moneyByCurrency.isEmpty()) continue;
            AnalytiqueRecapTableEngine.startRow(tableWriter, level);
            if (!operationDef.getTitleLabels().isEmpty()) {
                tableWriter.addStringCell(operationDef.getTitle(workingLang), 1, true);
            } else if (operationDef instanceof SoldeDef) {
                tableWriter.addMessageCell("_ label.scarabe.solde", 1, true);
            } else if (operationDef instanceof CustomLigneDef) {
                tableWriter.addMessageCell(AnalytiqueUtils.getLibelleKey(operationDef.getName()), 1, true);
            } else {
                tableWriter.addStringCell(operationDef.getName(), 1, true);
            }
            this.addRecapCellAndRow(tableWriter, moneyByCurrency, currencies, level);
            tableWriter.endRow();
        }
        List<AnalytiqueRecap> subRecapList = analytiqueRecap.getSubRecapList();
        if (!subRecapList.isEmpty()) {
            ++level;
            for (AnalytiqueRecap subRecap : subRecapList) {
                this.printAnalytiqueRecap(tableWriter, subRecap, level);
            }
        }
    }

    private void addRecapCellAndRow(ScarabeTableWriter tableWriter, MoneyByCurrency recapMoneyByCurrency, Currencies currencies, int currentLevel) {
        int length = currencies.size();
        boolean next = false;
        for (int i = 0; i < length; ++i) {
            if (!recapMoneyByCurrency.withMoney(i)) continue;
            if (next) {
                tableWriter.endRow();
                AnalytiqueRecapTableEngine.startRow(tableWriter, currentLevel);
                tableWriter.addNullCell(1);
            } else {
                next = true;
            }
            tableWriter.addMoneyCell(recapMoneyByCurrency.getMoneyLong(i), (ExtendedCurrency)currencies.get(i));
        }
    }

    private static void startRow(ScarabeTableWriter tableWriter, int currentLevel) {
        tableWriter.startRow();
        tableWriter.addNullCell(currentLevel * 2);
    }

    private static int getMaxLevel(AnalytiqueRecap analytiqueRecap, int level) {
        List<AnalytiqueRecap> subRecapList = analytiqueRecap.getSubRecapList();
        if (!subRecapList.isEmpty()) {
            int max = level + 1;
            for (AnalytiqueRecap subRecap : subRecapList) {
                max = Math.max(max, AnalytiqueRecapTableEngine.getMaxLevel(subRecap, level + 1));
            }
            return max;
        }
        return level;
    }
}

