/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import java.util.Collections;
import java.util.Set;
import net.mapeadores.util.money.ExtendedCurrency;

public class AnalytiqueParametersBuilder {
    private static final Set<Integer> EMPTY_SET = Collections.emptySet();
    private final AnalytiqueSubset analytiqueSubset;
    private short mode = 0;
    private ExtendedCurrency conversionCurrency;
    private Set<Integer> excludeIdSet = EMPTY_SET;
    private Set<Integer> includeIdSet = EMPTY_SET;
    private short filter = 0;
    private boolean detailWithRecap;
    private boolean hideRootRecap;

    public AnalytiqueParametersBuilder(AnalytiqueSubset analytiqueSubset) {
        this.analytiqueSubset = analytiqueSubset;
    }

    public AnalytiqueParametersBuilder setMode(short mode) {
        this.mode = mode;
        return this;
    }

    public AnalytiqueParametersBuilder setConversionCurrency(ExtendedCurrency conversionCurrency) {
        this.conversionCurrency = conversionCurrency;
        return this;
    }

    public AnalytiqueParametersBuilder setExcludeIdSet(Set<Integer> excludeIdSet) {
        this.excludeIdSet = excludeIdSet == null ? EMPTY_SET : excludeIdSet;
        return this;
    }

    public AnalytiqueParametersBuilder setIncludeIdSet(Set<Integer> includeIdSet) {
        this.includeIdSet = includeIdSet == null ? EMPTY_SET : includeIdSet;
        return this;
    }

    public AnalytiqueParametersBuilder setFilter(short filter) {
        this.filter = filter;
        return this;
    }

    public AnalytiqueParametersBuilder setDetailWithRecap(boolean detailWithRecap) {
        this.detailWithRecap = detailWithRecap;
        return this;
    }

    public AnalytiqueParametersBuilder setHideRootRecap(boolean hideRootRecap) {
        this.hideRootRecap = hideRootRecap;
        return this;
    }

    public AnalytiqueParameters toAnalytiqueParameters() {
        return new InternalAnalytiqueParameters(this.analytiqueSubset, this.mode, this.conversionCurrency, this.excludeIdSet, this.includeIdSet, this.filter, this.detailWithRecap, this.hideRootRecap);
    }

    public static AnalytiqueParametersBuilder init(AnalytiqueSubset analytiqueSubset) {
        return new AnalytiqueParametersBuilder(analytiqueSubset);
    }

    private static class InternalAnalytiqueParameters
    implements AnalytiqueParameters {
        private final AnalytiqueSubset analytiqueSubset;
        private final short mode;
        private final ExtendedCurrency conversionCurrency;
        private final Set<Integer> excludeIdSet;
        private final Set<Integer> includeIdSet;
        private final short filter;
        private final boolean detailWithRecap;
        private final boolean hideRootRecap;

        private InternalAnalytiqueParameters(AnalytiqueSubset analytiqueSubset, short mode, ExtendedCurrency conversionCurrency, Set<Integer> excludeIdSet, Set<Integer> includeIdSet, short filter, boolean detailWithRecap, boolean hideRootRecap) {
            this.analytiqueSubset = analytiqueSubset;
            this.mode = mode;
            this.conversionCurrency = conversionCurrency;
            this.excludeIdSet = excludeIdSet;
            this.includeIdSet = includeIdSet;
            this.filter = filter;
            this.detailWithRecap = detailWithRecap;
            this.hideRootRecap = hideRootRecap;
        }

        @Override
        public AnalytiqueSubset getAnalytiqueSubset() {
            return this.analytiqueSubset;
        }

        @Override
        public short getMode() {
            return this.mode;
        }

        @Override
        public ExtendedCurrency getConversionCurrency() {
            return this.conversionCurrency;
        }

        @Override
        public Set<Integer> getExcludeIdSet() {
            return this.excludeIdSet;
        }

        @Override
        public Set<Integer> getIncludeIdSet() {
            return this.includeIdSet;
        }

        @Override
        public short getRowFilter() {
            return this.filter;
        }

        @Override
        public boolean isDetailWithRecap() {
            return this.detailWithRecap;
        }

        @Override
        public boolean hideRootRecap() {
            return this.hideRootRecap;
        }
    }
}

