/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeOperand;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.text.Labels;

public class AgregatDefBuilder
extends DefBuilder {
    public static final short DONE = 0;
    public static final short NO_CORPUS_SUBSET_ERROR = 1;
    public static final short NO_SATELLITE_CORPUS_ERROR = 2;
    public static final short UNKNOWN_FIELD_ERROR = 3;
    public static final short NO_MONTANT_FIELD_ERROR = 4;
    private final Subset subset;
    private final short type;
    private final String name;
    private final IncludeKey includeKey;
    private final List<CorpusField> mainList;
    private final Map<SubsetKey, CorpusInfo> parentageMap = new LinkedHashMap<SubsetKey, CorpusInfo>();
    private final Map<SubsetKey, CorpusInfo> junctionMap = new LinkedHashMap<SubsetKey, CorpusInfo>();
    private short recursiveType = 1;

    public AgregatDefBuilder(short type, Subset subset, String name, IncludeKey includeKey) {
        if (type != 1 && includeKey == null) {
            throw new IllegalArgumentException("includeKey is null");
        }
        this.type = type;
        this.name = name;
        this.includeKey = includeKey;
        this.mainList = subset instanceof Corpus ? new ArrayList<CorpusField>() : null;
        this.subset = subset;
    }

    public AgregatDefBuilder addMainList(List<CorpusField> list) {
        if (this.mainList != null) {
            this.mainList.addAll(list);
        }
        return this;
    }

    public AgregatDefBuilder addParentageDef(Corpus corpus, List<CorpusField> list, List<SoldeOperand> variationList) {
        CorpusInfo corpusInfo = this.parentageMap.get(corpus.getSubsetKey());
        if (corpusInfo == null) {
            corpusInfo = new CorpusInfo(corpus, null, variationList);
            this.parentageMap.put(corpus.getSubsetKey(), corpusInfo);
        }
        corpusInfo.addList(list);
        return this;
    }

    public AgregatDefBuilder addJunctionDef(Corpus corpus, IncludeKey junctionIncludeKey, List<CorpusField> list, List<SoldeOperand> variationList) {
        CorpusInfo corpusInfo = this.junctionMap.get(corpus.getSubsetKey());
        if (corpusInfo == null) {
            corpusInfo = new CorpusInfo(corpus, junctionIncludeKey, variationList);
            this.junctionMap.put(corpus.getSubsetKey(), corpusInfo);
        }
        corpusInfo.addList(list);
        return this;
    }

    public AgregatDefBuilder setRecursiveType(short recursiveType) {
        this.recursiveType = recursiveType;
        return this;
    }

    public AgregatDef toAgregatDef() {
        List mainCorpusFieldList = this.mainList != null ? CorpusMetadataUtils.wrap((CorpusField[])this.mainList.toArray(new CorpusField[this.mainList.size()])) : CorpusMetadataUtils.EMPTY_CORPUSFIELDLIST;
        int parentageSize = this.parentageMap.size();
        AgregatDef.ParentageDef[] parentageArray = new AgregatDef.ParentageDef[parentageSize];
        int p = 0;
        for (CorpusInfo corpusInfo : this.parentageMap.values()) {
            parentageArray[p] = corpusInfo.toParentageDef();
            ++p;
        }
        int junctionSize = this.junctionMap.size();
        AgregatDef.JunctionDef[] junctionArray = new AgregatDef.JunctionDef[junctionSize];
        p = 0;
        for (CorpusInfo corpusInfo : this.junctionMap.values()) {
            junctionArray[p] = corpusInfo.toJunctionDef();
            ++p;
        }
        List<AgregatDef.ParentageDef> parentageDefList = AnalytiqueUtils.wrap(parentageArray);
        List<AgregatDef.JunctionDef> junctionDefList = AnalytiqueUtils.wrap(junctionArray);
        Labels titleLabels = this.toLabels();
        Attributes attributes = this.toAttributes();
        InternalAgregatDef agregatDef = new InternalAgregatDef(this.type, this.name, this.includeKey, mainCorpusFieldList, parentageDefList, junctionDefList, this.recursiveType, titleLabels, attributes);
        return agregatDef;
    }

    public static AgregatDefBuilder init(short type, Subset subset, String name, IncludeKey includeKey) {
        return new AgregatDefBuilder(type, subset, name, includeKey);
    }

    private static class CorpusInfo {
        private final Corpus corpus;
        private final IncludeKey junctionIncludeKey;
        private List<CorpusField> corpusFieldList;
        private final List<SoldeOperand> variationList;

        private CorpusInfo(Corpus corpus, IncludeKey junctionIncludeKey, List<SoldeOperand> variationList) {
            this.corpus = corpus;
            this.junctionIncludeKey = junctionIncludeKey;
            this.variationList = variationList;
        }

        private void addList(List<CorpusField> list) {
            if (this.corpusFieldList == null) {
                this.corpusFieldList = list;
            } else {
                this.corpusFieldList.addAll(list);
            }
        }

        private AgregatDef.ParentageDef toParentageDef() {
            List finalCorpusFieldList = this.corpusFieldList != null ? CorpusMetadataUtils.wrap((CorpusField[])this.corpusFieldList.toArray(new CorpusField[this.corpusFieldList.size()])) : CorpusMetadataUtils.EMPTY_CORPUSFIELDLIST;
            return new InternalParentageDef(this.corpus, finalCorpusFieldList, this.variationList);
        }

        private AgregatDef.JunctionDef toJunctionDef() {
            List finalCorpusFieldList = this.corpusFieldList != null ? CorpusMetadataUtils.wrap((CorpusField[])this.corpusFieldList.toArray(new CorpusField[this.corpusFieldList.size()])) : CorpusMetadataUtils.EMPTY_CORPUSFIELDLIST;
            return new InternalJunctionDef(this.corpus, this.junctionIncludeKey, finalCorpusFieldList, this.variationList);
        }
    }

    private static class InternalAgregatDef
    implements AgregatDef {
        private final short type;
        private final String name;
        private final IncludeKey includeKey;
        private final short recursiveType;
        private final List<CorpusField> mainCorpusFieldList;
        private final List<AgregatDef.ParentageDef> parentageDefList;
        private final List<AgregatDef.JunctionDef> junctionDefList;
        private final Labels titleLabels;
        private final Attributes attributes;

        private InternalAgregatDef(short type, String name, IncludeKey includeKey, List<CorpusField> mainCorpusFieldList, List<AgregatDef.ParentageDef> parentageDefList, List<AgregatDef.JunctionDef> junctionDefList, short recursiveType, Labels titleLabels, Attributes attributes) {
            this.type = type;
            this.name = name;
            this.includeKey = includeKey;
            this.mainCorpusFieldList = mainCorpusFieldList;
            this.parentageDefList = parentageDefList;
            this.junctionDefList = junctionDefList;
            this.recursiveType = recursiveType;
            this.titleLabels = titleLabels;
            this.attributes = attributes;
        }

        @Override
        public short getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Labels getTitleLabels() {
            return this.titleLabels;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public IncludeKey getIncludeKey() {
            return this.includeKey;
        }

        @Override
        public List<CorpusField> getCorpusFieldList() {
            return this.mainCorpusFieldList;
        }

        @Override
        public List<AgregatDef.ParentageDef> getParentageDefList() {
            return this.parentageDefList;
        }

        @Override
        public List<AgregatDef.JunctionDef> getJunctionDefList() {
            return this.junctionDefList;
        }

        @Override
        public short getRecursiveType() {
            return this.recursiveType;
        }
    }

    private static class InternalJunctionDef
    implements AgregatDef.JunctionDef {
        private final Corpus corpus;
        private final IncludeKey includeKey;
        private final List<CorpusField> corpusFieldList;
        private final List<SoldeOperand> variationList;

        private InternalJunctionDef(Corpus corpus, IncludeKey includeKey, List<CorpusField> corpusFieldList, List<SoldeOperand> variationList) {
            this.corpus = corpus;
            this.includeKey = includeKey;
            this.corpusFieldList = corpusFieldList;
            this.variationList = variationList;
        }

        @Override
        public Corpus getCorpus() {
            return this.corpus;
        }

        @Override
        public IncludeKey getIncludeKey() {
            return this.includeKey;
        }

        @Override
        public List<CorpusField> getCorpusFieldList() {
            return this.corpusFieldList;
        }

        @Override
        public List<SoldeOperand> getVariationOperandList() {
            return this.variationList;
        }
    }

    private static class InternalParentageDef
    implements AgregatDef.ParentageDef {
        private final Corpus corpus;
        private final List<CorpusField> corpusFieldList;
        private final List<SoldeOperand> variationList;

        private InternalParentageDef(Corpus corpus, List<CorpusField> corpusFieldList, List<SoldeOperand> variationList) {
            this.corpus = corpus;
            this.corpusFieldList = corpusFieldList;
            this.variationList = variationList;
        }

        @Override
        public Corpus getCorpus() {
            return this.corpus;
        }

        @Override
        public List<CorpusField> getCorpusFieldList() {
            return this.corpusFieldList;
        }

        @Override
        public List<SoldeOperand> getVariationOperandList() {
            return this.variationList;
        }
    }
}

