/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeSpace;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDefManager;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Banques;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.LigneHolder;
import fr.exemole.bdfext.scarabe.api.core.LigneKey;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.api.cours.CoursManager;
import fr.exemole.bdfext.scarabe.tools.Comparators;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueEngine;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfext.scarabe.tools.core.AvenirBuilder;
import fr.exemole.bdfext.scarabe.tools.core.BanquesBuilder;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfext.scarabe.tools.core.DesherenceTest;
import fr.exemole.bdfext.scarabe.tools.core.MouvementBuilder;
import fr.exemole.bdfext.scarabe.tools.cours.CoursManagerBuilder;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import java.time.LocalDate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.CurrenciesUtils;
import net.mapeadores.util.money.ExtendedCurrency;

public class RecapitulatifBuilder {
    private RecapitulatifBuilder() {
    }

    public static Recapitulatif recapitule(BdfServer bdfServer, ScarabeContext scarabeContext) {
        InternalRecapitulatif recapitulatif = new InternalRecapitulatif();
        recapitulatif.init(bdfServer, scarabeContext);
        return recapitulatif;
    }

    private static class InternalRecapitulatif
    implements Recapitulatif {
        private final LigneHolder ligneHolder = new InternalLigneHolder();
        private Currencies currencies;
        private final SortedMap<Integer, Mouvement> errorMouvementMap = new TreeMap<Integer, Mouvement>();
        private final SortedMap<Integer, Mouvement> resteWarningMouvementMap = new TreeMap<Integer, Mouvement>();
        private final SortedMap<Integer, AnneeImpl> anneeMap = new TreeMap<Integer, AnneeImpl>();
        private final Map<SubsetKey, AnalytiqueSubset> analytiqueSubsetMap = new HashMap<SubsetKey, AnalytiqueSubset>();
        private List<Recapitulatif.Annee> anneeList;
        private Banques banques;
        private List<Mouvement> errorMouvementList;
        private List<Mouvement> resteWarningMouvementList;
        private List<AnalytiqueSubset> errorAnalytiqueSubsetList;
        private List<AnalytiqueSubset> analytiqueSubsetList;
        private final Map<LigneKey, Ligne> ligneMap = new HashMap<LigneKey, Ligne>();
        private final Map<LigneKey, Avenir> avenirMap = new HashMap<LigneKey, Avenir>();
        private Message globalErrorMessage;
        private List<Ligne> avanceNonSoldeeList;
        private List<Avenir> avenirList;
        private List<Avenir> pastDateAvenirList;
        private List<Avenir> errorAvenirList;
        private List<FicheMeta> desherenceList;
        private CoursManager coursManager;

        private InternalRecapitulatif() {
        }

        private void init(BdfServer bdfServer, ScarabeContext scarabeContext) {
            AliasHolder coreAliasHolder = scarabeContext.getCoreAliasHolder();
            boolean done = this.initCurrencyHolder(coreAliasHolder);
            if (!done) {
                this.anneeList = AnalytiqueUtils.EMPTY_ANNEELIST;
                this.errorMouvementList = CoreUtils.EMPTY_MOUVEMENTLIST;
                this.resteWarningMouvementList = CoreUtils.EMPTY_MOUVEMENTLIST;
                this.errorAnalytiqueSubsetList = AnalytiqueUtils.EMPTY_ANALYTIQUESUBSETLIST;
                this.analytiqueSubsetList = AnalytiqueUtils.EMPTY_ANALYTIQUESUBSETLIST;
                this.banques = BanquesBuilder.EMPTY_BANQUES;
                return;
            }
            this.banques = BanquesBuilder.init(coreAliasHolder);
            this.avanceNonSoldeeList = new ArrayList<Ligne>();
            Corpus mouvementCorpus = coreAliasHolder.getCorpus("mouvement");
            FichePointeur mouvementPointeur = PointeurFactory.newFichePointeur((Corpus)mouvementCorpus);
            for (FicheMeta ficheMeta : mouvementCorpus.getFicheMetaList()) {
                mouvementPointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
                Mouvement mouvement = MouvementBuilder.build(mouvementPointeur, scarabeContext, bdfServer.getFichothequeQuestioner(), this.banques, this.currencies);
                this.addMouvement(mouvement);
            }
            ArrayList<Avenir> tempAvenirList = new ArrayList<Avenir>();
            ArrayList<Avenir> tempErrorAvenirList = new ArrayList<Avenir>();
            ArrayList<Avenir> tempPastDateWarningAvenirList = new ArrayList<Avenir>();
            Corpus avanceCorpus = coreAliasHolder.getCorpus("avance");
            Corpus depenseCorpus = coreAliasHolder.getCorpus("depense");
            Corpus apportCorpus = coreAliasHolder.getCorpus("apport");
            ArrayList<Object> tempDesherenceList = new ArrayList<Object>();
            FichePointeur depensePointeur = PointeurFactory.newFichePointeur((Corpus)depenseCorpus);
            LocalDate currentDate = LocalDate.now();
            CorpusField dateprevueField = coreAliasHolder.getCorpusField("depense_dateprevue");
            for (Object ficheMeta : depenseCorpus.getFicheMetaList()) {
                Avenir avenir;
                depensePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
                short state = DesherenceTest.getDepenseDesherenceState(depensePointeur, mouvementCorpus, avanceCorpus, dateprevueField);
                if (state == 4) {
                    tempDesherenceList.add(ficheMeta);
                    continue;
                }
                if (state != 3 || (avenir = AvenirBuilder.init(depensePointeur, scarabeContext, this.currencies, dateprevueField, bdfServer.getFichothequeQuestioner())) == null) continue;
                if (avenir.hasError()) {
                    tempErrorAvenirList.add(avenir);
                    continue;
                }
                if (avenir.getDatePrevue().isBefore(currentDate)) {
                    tempPastDateWarningAvenirList.add(avenir);
                }
                LigneKey ligneKey = LigneKey.get("depense", ficheMeta.getId());
                tempAvenirList.add(avenir);
                this.avenirMap.put(ligneKey, avenir);
            }
            FichePointeur apportPointeur = PointeurFactory.newFichePointeur((Corpus)apportCorpus);
            for (FicheMeta ficheMeta : apportCorpus.getFicheMetaList()) {
                apportPointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
                short state = DesherenceTest.getApportDesherenceState(apportPointeur, mouvementCorpus);
                if (state != 4) continue;
                tempDesherenceList.add(ficheMeta);
            }
            FichePointeur avancePointeur = PointeurFactory.newFichePointeur((Corpus)avanceCorpus);
            for (FicheMeta ficheMeta : avanceCorpus.getFicheMetaList()) {
                avancePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
                short state = DesherenceTest.getAvanceDesherenceState(avancePointeur, mouvementCorpus);
                if (state != 4) continue;
                tempDesherenceList.add(ficheMeta);
            }
            Recapitulatif.Annee[] anneeArray = new Recapitulatif.Annee[this.anneeMap.size()];
            int p = 0;
            for (AnneeImpl annee : this.anneeMap.values()) {
                annee.endInit();
                anneeArray[p] = annee;
                ++p;
            }
            this.anneeList = AnalytiqueUtils.wrap(anneeArray);
            this.errorMouvementList = CoreUtils.toMouvementList(this.errorMouvementMap.values());
            this.resteWarningMouvementList = CoreUtils.toMouvementList(this.resteWarningMouvementMap.values());
            Collections.sort(tempAvenirList, Comparators.AVENIR_DATE);
            Collections.sort(tempPastDateWarningAvenirList, Comparators.AVENIR_DATE);
            this.avanceNonSoldeeList = CoreUtils.toLigneList(this.avanceNonSoldeeList);
            this.avenirList = CoreUtils.toAvenirList(tempAvenirList);
            this.pastDateAvenirList = CoreUtils.toAvenirList(tempPastDateWarningAvenirList);
            this.errorAvenirList = CoreUtils.toAvenirList(tempErrorAvenirList);
            this.desherenceList = CorpusUtils.wrap((FicheMeta[])tempDesherenceList.toArray(new FicheMeta[tempDesherenceList.size()]));
            PrerequestDefManager prerequestDefManager = ConfigurationUtils.getPrerequestDefManager(scarabeContext);
            this.initAnalytique(bdfServer, coreAliasHolder, prerequestDefManager);
            AliasHolder coursAliasHolder = scarabeContext.getCoursAliasHolder();
            if (coursAliasHolder != null) {
                this.coursManager = CoursManagerBuilder.build(coursAliasHolder);
            }
        }

        private void initAnalytique(BdfServer bdfServer, AliasHolder coreAliasHolder, PrerequestDefManager prerequestDefManager) {
            Fichotheque fichotheque = bdfServer.getFichotheque();
            ArrayList<Subset> subsetList = new ArrayList<Subset>();
            this.checkNodeList(fichotheque, bdfServer.getTreeManager().getSubsetTree((short)2).getNodeList(), subsetList);
            this.checkNodeList(fichotheque, bdfServer.getTreeManager().getSubsetTree((short)1).getNodeList(), subsetList);
            ArrayList<AnalytiqueSubset> tmpErrorList = new ArrayList<AnalytiqueSubset>();
            ArrayList<AnalytiqueSubset> tmpList = new ArrayList<AnalytiqueSubset>();
            AnalytiqueEngine analytiqueEngine = new AnalytiqueEngine(coreAliasHolder, this.ligneHolder, this.currencies, prerequestDefManager);
            for (Subset subset : subsetList) {
                AnalytiqueSubset analytiqueSubset = analytiqueEngine.build(subset);
                if (analytiqueSubset.hasError()) {
                    tmpErrorList.add(analytiqueSubset);
                    continue;
                }
                tmpList.add(analytiqueSubset);
                this.analytiqueSubsetMap.put(analytiqueSubset.getSubsetKey(), analytiqueSubset);
            }
            this.errorAnalytiqueSubsetList = AnalytiqueUtils.wrap(tmpErrorList.toArray(new AnalytiqueSubset[tmpErrorList.size()]));
            this.analytiqueSubsetList = AnalytiqueUtils.wrap(tmpList.toArray(new AnalytiqueSubset[tmpList.size()]));
        }

        private void checkNodeList(Fichotheque fichotheque, List<SubsetTree.Node> nodeList, List<Subset> subsetList) {
            for (SubsetTree.Node node : nodeList) {
                if (node instanceof SubsetNode) {
                    SubsetNode subsetNode = (SubsetNode)node;
                    Subset subset = fichotheque.getSubset(subsetNode.getSubsetKey());
                    if (!this.isAnalytique(subset)) continue;
                    subsetList.add(subset);
                    continue;
                }
                if (!(node instanceof GroupNode)) continue;
                this.checkNodeList(fichotheque, ((GroupNode)node).getSubnodeList(), subsetList);
            }
        }

        private boolean isAnalytique(Subset subset) {
            if (subset == null) {
                return false;
            }
            return ScarabeSpace.isAnalytiqueKey(subset.getMetadata());
        }

        @Override
        public LigneHolder getLigneHolder() {
            return this.ligneHolder;
        }

        @Override
        public Currencies getCurrencies() {
            return this.currencies;
        }

        @Override
        public Banques getBanques() {
            return this.banques;
        }

        @Override
        public List<Recapitulatif.Annee> getAnneeList() {
            return this.anneeList;
        }

        @Override
        public boolean hasGlobalErrors() {
            return this.globalErrorMessage != null;
        }

        @Override
        public Message getGlobalErrorMessage() {
            return this.globalErrorMessage;
        }

        @Override
        public boolean hasErrors() {
            if (this.banques.isWithErrors()) {
                return true;
            }
            if (!this.errorMouvementMap.isEmpty()) {
                return true;
            }
            if (!this.errorAvenirList.isEmpty()) {
                return true;
            }
            return !this.desherenceList.isEmpty();
        }

        @Override
        public List<AnalytiqueSubset> getErrorAnalytiqueSubsetList() {
            return this.errorAnalytiqueSubsetList;
        }

        @Override
        public List<Mouvement> getErrorMouvementList() {
            return this.errorMouvementList;
        }

        @Override
        public List<Mouvement> getResteWarningMouvementList() {
            return this.resteWarningMouvementList;
        }

        @Override
        public List<AnalytiqueSubset> getAnalytiqueSubsetList() {
            return this.analytiqueSubsetList;
        }

        @Override
        public AnalytiqueSubset getAnalytiqueSubset(SubsetKey subsetKey) {
            return this.analytiqueSubsetMap.get(subsetKey);
        }

        @Override
        public List<Ligne> getAvanceNonSoldeeList() {
            return this.avanceNonSoldeeList;
        }

        @Override
        public List<Avenir> getErrorAvenirList() {
            return this.errorAvenirList;
        }

        @Override
        public List<Avenir> getPastDateWarningAvenirList() {
            return this.pastDateAvenirList;
        }

        @Override
        public List<Avenir> getAvenirList() {
            return this.avenirList;
        }

        @Override
        public List<FicheMeta> getDesherenceList() {
            return this.desherenceList;
        }

        @Override
        public CoursManager getCoursManager() {
            return this.coursManager;
        }

        private void putErrorMouvement(Mouvement mouvement) {
            List<Message> errorMessageList;
            int errorLength;
            if (mouvement.hasError() && (errorLength = (errorMessageList = mouvement.getErrorMessageList()).size()) == 1 && !mouvement.withLigneError() && errorMessageList.get(0).getMessageKey().equals("_ error.unsupported.scarabe.witherrors_banque")) {
                return;
            }
            this.errorMouvementMap.put(mouvement.getId(), mouvement);
        }

        private void addMouvement(Mouvement mouvement) {
            if (mouvement.hasError() || mouvement.withLigneError()) {
                this.putErrorMouvement(mouvement);
                return;
            }
            this.putLignes(mouvement.getAvanceList());
            this.putLignes(mouvement.getDepenseList());
            this.putLignes(mouvement.getApportList());
            this.putLignes(mouvement.getSoldeAvanceList());
            if (mouvement.getResteMoneyLong() != 0L) {
                this.resteWarningMouvementMap.put(mouvement.getId(), mouvement);
            }
            AnneeImpl annee = this.getOrCreateAnnee(mouvement.getDate().getYear());
            annee.addMouvement(mouvement);
        }

        private void putLignes(List<Ligne> list) {
            for (Ligne ligne : list) {
                LigneKey ligneKey = ligne.getLigneKey();
                if (this.ligneMap.containsKey(ligneKey)) {
                    throw new IllegalStateException("Doublon pour " + ligneKey.toString());
                }
                if (CoreUtils.isAvanceNonSoldee(ligne)) {
                    this.avanceNonSoldeeList.add(ligne);
                }
                this.ligneMap.put(ligneKey, ligne);
            }
        }

        private AnneeImpl getOrCreateAnnee(int annee) {
            AnneeImpl anneeObject = (AnneeImpl)this.anneeMap.get(annee);
            if (anneeObject == null) {
                anneeObject = new AnneeImpl(annee);
                this.anneeMap.put(annee, anneeObject);
            }
            return anneeObject;
        }

        private boolean initCurrencyHolder(AliasHolder coreAliasHolder) {
            CorpusField reportField = coreAliasHolder.getCorpusField("banque_montantreport");
            Currencies currencies = reportField.getCurrencies();
            if (currencies == null) {
                this.globalErrorMessage = LocalisationUtils.toMessage((String)"_ error.empty.scarabe.currency");
                this.currencies = CurrenciesUtils.EMPTY_CURRENCIES;
                return false;
            }
            HashMap<ExtendedCurrency, Integer> indexMap = new HashMap<ExtendedCurrency, Integer>();
            ArrayList<ExtendedCurrency> currencyList = new ArrayList<ExtendedCurrency>();
            for (ExtendedCurrency currency : currencies) {
                if (indexMap.containsKey(currency)) continue;
                int size = currencyList.size();
                currencyList.add(currency);
                indexMap.put(currency, size);
            }
            ExtendedCurrency[] array = currencyList.toArray(new ExtendedCurrency[currencyList.size()]);
            this.currencies = new InternalCurrencies(indexMap, array);
            return true;
        }

        private class InternalLigneHolder
        implements LigneHolder {
            private InternalLigneHolder() {
            }

            @Override
            public Ligne getLigne(LigneKey ligneKey) {
                return (Ligne)InternalRecapitulatif.this.ligneMap.get(ligneKey);
            }

            @Override
            public Avenir getAvenir(LigneKey ligneKey) {
                return (Avenir)InternalRecapitulatif.this.avenirMap.get(ligneKey);
            }
        }
    }

    private static class InternalCurrencies
    extends AbstractList<ExtendedCurrency>
    implements Currencies {
        private final Map<ExtendedCurrency, Integer> indexMap;
        private final ExtendedCurrency[] currencyArray;

        private InternalCurrencies(Map<ExtendedCurrency, Integer> indexMap, ExtendedCurrency[] currencyArray) {
            this.indexMap = indexMap;
            this.currencyArray = currencyArray;
        }

        @Override
        public int size() {
            return this.currencyArray.length;
        }

        @Override
        public ExtendedCurrency get(int i) {
            return this.currencyArray[i];
        }

        @Override
        public int indexOf(Object obj) {
            Integer itg = this.indexMap.get(obj);
            if (itg == null) {
                return -1;
            }
            return itg;
        }
    }

    private static class JourImpl
    implements Recapitulatif.Jour {
        private final LocalDate date;
        private final int jour;
        private final List<Mouvement> mouvementList = new ArrayList<Mouvement>();
        private final List<Mouvement> unmodifiableList = Collections.unmodifiableList(this.mouvementList);

        private JourImpl(LocalDate date, int jour) {
            this.date = date;
            this.jour = jour;
        }

        private void addMouvement(Mouvement mouvement) {
            this.mouvementList.add(mouvement);
        }

        @Override
        public int getJour() {
            return this.jour;
        }

        @Override
        public LocalDate getMatchingDate() {
            return this.date;
        }

        @Override
        public List<Mouvement> getMouvementList() {
            return this.unmodifiableList;
        }

        private void endInit() {
        }
    }

    private static class MoisImpl
    implements Recapitulatif.Mois {
        private final FuzzyDate date;
        private final int mois;
        private final SortedMap<Integer, JourImpl> jourMap = new TreeMap<Integer, JourImpl>();
        private List<Recapitulatif.Jour> jourList;

        private MoisImpl(FuzzyDate date, int mois) {
            this.date = date;
            this.mois = mois;
        }

        @Override
        public int getMois() {
            return this.mois;
        }

        @Override
        public FuzzyDate getMatchingDate() {
            return this.date;
        }

        @Override
        public List<Recapitulatif.Jour> getJourList() {
            return this.jourList;
        }

        private void addMouvement(Mouvement mouvement) {
            JourImpl jour = this.getOrCreateJour(mouvement.getDate());
            jour.addMouvement(mouvement);
        }

        private JourImpl getOrCreateJour(LocalDate date) {
            int jour = date.getDayOfMonth();
            JourImpl jourObject = (JourImpl)this.jourMap.get(jour);
            if (jourObject == null) {
                jourObject = new JourImpl(date, jour);
                this.jourMap.put(jour, jourObject);
            }
            return jourObject;
        }

        private void endInit() {
            Recapitulatif.Jour[] jourArray = new Recapitulatif.Jour[this.jourMap.size()];
            int p = 0;
            for (JourImpl jour : this.jourMap.values()) {
                jour.endInit();
                jourArray[p] = jour;
                ++p;
            }
            this.jourList = AnalytiqueUtils.wrap(jourArray);
        }
    }

    private static class AnneeImpl
    implements Recapitulatif.Annee {
        private final int annee;
        private final SortedMap<Integer, MoisImpl> moisMap = new TreeMap<Integer, MoisImpl>();
        private List<Recapitulatif.Mois> moisList;

        private AnneeImpl(int annee) {
            this.annee = annee;
        }

        @Override
        public int getAnnee() {
            return this.annee;
        }

        @Override
        public List<Recapitulatif.Mois> getMoisList() {
            return this.moisList;
        }

        private void addMouvement(Mouvement mouvement) {
            MoisImpl mois = this.getOrCreateMois(mouvement.getDate());
            mois.addMouvement(mouvement);
        }

        private MoisImpl getOrCreateMois(LocalDate date) {
            int monthValue = date.getMonthValue();
            MoisImpl moisObject = (MoisImpl)this.moisMap.get(monthValue);
            if (moisObject == null) {
                moisObject = new MoisImpl(FuzzyDate.fromMonth((int)date.getYear(), (int)monthValue), monthValue);
                this.moisMap.put(monthValue, moisObject);
            }
            return moisObject;
        }

        private void endInit() {
            Recapitulatif.Mois[] moisArray = new MoisImpl[this.moisMap.size()];
            int p = 0;
            for (MoisImpl mois : this.moisMap.values()) {
                mois.endInit();
                moisArray[p] = mois;
                ++p;
            }
            this.moisList = AnalytiqueUtils.wrap(moisArray);
        }
    }
}

