/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.multiidselection.commands;

import fr.exemole.bdfext.multiidselection.FormValues;
import fr.exemole.bdfext.multiidselection.MultiIdSelection;
import fr.exemole.bdfext.multiidselection.MultiIdSelectionHistory;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.Range;
import net.mapeadores.util.primitives.RangeUtils;
import net.mapeadores.util.primitives.Ranges;
import net.mapeadores.util.request.RequestMap;

public class MultiIdSelectionCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "multiidselection";
    public static final String RANGE_SUFFIX = "|range";
    public static final String START_SUFFIX = "|start";
    private Map<SubsetKey, SelectionInfo> selectionInfoMap;
    private FormValues formValues;

    public MultiIdSelectionCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public boolean needSynchronisation() {
        return false;
    }

    protected void doCommand() throws ErrorMessageException {
        Fiches fiches = this.select();
        this.bdfServer.getSelectionManager().setCustomSelectedFiches(this.bdfUser, fiches);
        this.formValues.saveCurrent(this.bdfUser);
        try (EditSession session = this.bdfServer.initEditSession(this.bdfUser, MultiIdSelection.DOMAIN, COMMANDNAME);){
            MultiIdSelectionHistory.save(session.getBdfServerEditor(), fiches);
        }
    }

    protected void checkParameters() throws ErrorMessageException {
        this.selectionInfoMap = new HashMap<SubsetKey, SelectionInfo>();
        this.formValues = new FormValues();
        for (String paramName : this.requestHandler.getParameterNameSet()) {
            int idx = paramName.indexOf(124);
            if (idx == -1) continue;
            try {
                SubsetKey corpusKey = SubsetKey.parse((short)1, (String)paramName.substring(0, idx));
                String paramValue = this.requestHandler.getTrimedParameter(paramName).trim();
                this.formValues.add(paramName, paramValue);
                if (paramValue.isEmpty()) continue;
                String suffix = paramName.substring(idx);
                SelectionInfo selectionInfo = MultiIdSelectionCommand.getSelectionInfo(this.selectionInfoMap, corpusKey);
                if (suffix.equals(START_SUFFIX)) {
                    int start = 0;
                    try {
                        start = Integer.parseInt(paramValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (start < 1) {
                        throw BdfErrors.error((String)"_ error.wrong.value", (Object[])new Object[]{paramValue});
                    }
                    selectionInfo.setStart(start);
                    continue;
                }
                if (!suffix.equals(RANGE_SUFFIX)) continue;
                Ranges ranges = RangeUtils.positiveRangeParse((String)paramValue);
                selectionInfo.setRanges(ranges);
            }
            catch (ParseException parseException) {}
        }
    }

    private static SelectionInfo getSelectionInfo(Map<SubsetKey, SelectionInfo> selectionInfoMap, SubsetKey subsetKey) {
        SelectionInfo selectionInfo = selectionInfoMap.get(subsetKey);
        if (selectionInfo == null) {
            selectionInfo = new SelectionInfo();
            selectionInfoMap.put(subsetKey, selectionInfo);
        }
        return selectionInfo;
    }

    private Fiches select() {
        FichesBuilder fichesBuilder = FichesBuilder.build((String)"creationdate-desc").initSubsetKeyOrder(TreeUtils.getCorpusKeyList((BdfServer)this.bdfServer));
        for (Map.Entry<SubsetKey, SelectionInfo> entry : this.selectionInfoMap.entrySet()) {
            Corpus corpus = (Corpus)this.fichotheque.getSubset(entry.getKey());
            if (corpus == null) continue;
            Ranges ranges = entry.getValue().toCompleteRange();
            for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
                if (!ranges.contains(ficheMeta.getId())) continue;
                fichesBuilder.add(ficheMeta);
            }
        }
        return fichesBuilder.toFiches();
    }

    private static class SelectionInfo {
        private int start = 0;
        private Ranges ranges;

        private SelectionInfo() {
        }

        private void setStart(int start) {
            this.start = start;
        }

        private void setRanges(Ranges ranges) {
            this.ranges = ranges;
        }

        private Ranges toCompleteRange() {
            if (this.ranges == null) {
                if (this.start == 0) {
                    return null;
                }
                Range range = new Range(this.start, Integer.MAX_VALUE);
                Ranges completeRanges = new Ranges();
                completeRanges.addRange(range);
                return completeRanges;
            }
            if (this.start > 0) {
                Range range = new Range(this.start, Integer.MAX_VALUE);
                this.ranges.addRange(range);
            }
            return this.ranges;
        }
    }
}

