/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation.builders;

import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.tools.ventilation.VentilationBuilderUtils;
import net.desmodo.atlas.ventilation.UnsupportedVentilationRootException;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.desmodo.atlas.ventilation.builders.DefaultVentilation;

public class GrilleVentilationBuilder {
    private GrilleVentilationBuilder() {
    }

    public static Ventilation toVentilation(VentilationParameters ventilationParameters, Term grilleOrContexte) throws UnsupportedVentilationRootException {
        DefaultVentilation ventilation = DefaultVentilation.createVentilationByGrilleOrContexte(ventilationParameters, grilleOrContexte);
        Term ventilationRoot = ventilationParameters.getVentilationRoot();
        if (ventilationRoot != null) {
            if (ventilationRoot instanceof Descripteur) {
                Descripteur descripteur = (Descripteur)ventilationRoot;
                VentilationBuilderUtils.addLiaisonsNaturelles(descripteur, ventilation);
            } else if (ventilationRoot instanceof Contexte) {
                Contexte contexte = (Contexte)ventilationRoot;
                VentilationBuilderUtils.addLiaisonsNaturelles(contexte, ventilation);
            } else {
                throw new UnsupportedVentilationRootException("ventilation:grille: or ventilation:contexte supports only Contexte or Descripteur as VentilationRoot", GrilleVentilationBuilder.class.getName());
            }
        }
        ventilation.endInit();
        return ventilation;
    }
}

