/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation;

import java.awt.Color;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.StructureUtils;

public class ColorStyle {
    public static final ColorStyle COMPLETE_COLORSTYLE = new ColorStyle("ventilation:complete", Color.RED);
    public static final ColorStyle BYFAMILLE_COLORSTYLE = new ColorStyle("ventilation:byfamille", Color.GRAY);
    private final Color color;
    private final String name;

    private ColorStyle(String name, Color color) {
        this.name = name;
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public static ColorStyle fromGrille(Grille grille) {
        Color color = AtlasAttributes.getColor(grille);
        String name = ColorStyle.getStyleName(grille);
        return new ColorStyle(name, color);
    }

    public static ColorStyle fromContexte(Contexte contexte) {
        Color color = AtlasAttributes.getColor(contexte);
        String name = ColorStyle.getStyleName(contexte);
        return new ColorStyle(name, color);
    }

    public static ColorStyle fromActiveContexte(Contexte contexte) {
        Color color = StructureUtils.getParentColor(contexte);
        String name = ColorStyle.getStyleName(contexte);
        return new ColorStyle(name, color);
    }

    public static String getStyleName(Grille grille) {
        return "ventilation:" + AtlasURI.toURIString(grille);
    }

    public static String getStyleName(Contexte contexte) {
        return "ventilation:" + AtlasURI.toURIString(contexte);
    }
}

