/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tools.ventilation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.liens.Lien;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.tools.ventilation.VentilationUtils;
import net.desmodo.atlas.ventilation.ColorStyle;
import net.desmodo.atlas.ventilation.LiaisonFilter;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.SecteurList;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.desmodo.atlas.ventilation.builders.SecteurBuilder;

public class VentilationBuilder {
    private final VentilationParameters ventilationParameters;
    private final List<SecteurBuilder> secteurBuilderList = new ArrayList<SecteurBuilder>();
    private final Map<Integer, SecteurBuilder> secteurBuilderMap = new HashMap<Integer, SecteurBuilder>();
    private final Atlas atlas;
    private final VentilationName ventilationName;
    private final Term root;
    private final LiaisonFilter liaisonFilter;
    private ColorStyle colorStyle = ColorStyle.COMPLETE_COLORSTYLE;
    private boolean ignoreEmpty = false;
    private int currentCode = 1;

    public VentilationBuilder(VentilationParameters ventilationParameters) {
        this.ventilationParameters = ventilationParameters;
        this.ignoreEmpty = ventilationParameters.getSessionConf().getBoolean("ignore.empty.secteur");
        this.atlas = ventilationParameters.getAtlas();
        this.ventilationName = ventilationParameters.getVentilationName();
        this.root = ventilationParameters.getVentilationRoot();
        this.liaisonFilter = ventilationParameters.getLiaisonFilter();
    }

    public void setColorStyle(ColorStyle colorStyle) {
        this.colorStyle = colorStyle;
    }

    public VentilationParameters getVentilationParameters() {
        return this.ventilationParameters;
    }

    public Atlas getAtlas() {
        return this.atlas;
    }

    public VentilationName getVentilationName() {
        return this.ventilationName;
    }

    public Term getRoot() {
        return this.root;
    }

    public void addSecteurBuilder(SecteurBuilder secteurBuilder) {
        this.secteurBuilderList.add(secteurBuilder);
        this.putInMap(secteurBuilder);
    }

    private void putInMap(SecteurBuilder secteurBuilder) {
        this.secteurBuilderMap.put(secteurBuilder.getTerm().getCode(), secteurBuilder);
        int childCount = secteurBuilder.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.putInMap(secteurBuilder.getChild(i));
        }
    }

    public boolean createLiaison(Lien lien, Term termeLiaison, Term termeSecteur) {
        return this.createLiaison(lien, termeLiaison, termeSecteur, -1, VentilationUtils.getLiaisonPosition(lien, termeLiaison));
    }

    public boolean createLiaison(Lien lien, Term termeLiaison, Term termeSecteur, int indexInLien) {
        return this.createLiaison(lien, termeLiaison, termeSecteur, indexInLien, VentilationUtils.getLiaisonPosition(lien, termeLiaison));
    }

    public boolean createLiaison(Lien lien, Term termeLiaison, Term termeSecteur, int indexInLien, short position) {
        SecteurBuilder secteurBuilder = this.secteurBuilderMap.get(termeSecteur.getCode());
        if (secteurBuilder == null) {
            return false;
        }
        boolean done = secteurBuilder.addLiaison(this.liaisonFilter, lien, termeLiaison, position, indexInLien, this.currentCode);
        if (done) {
            ++this.currentCode;
        }
        return done;
    }

    public void createLiaisonsFromLienHierarchiqueGroup(LienHierarchiqueGroup lhg, Term termeSecteur) {
        SecteurBuilder secteurBuilder = this.secteurBuilderMap.get(termeSecteur.getCode());
        if (secteurBuilder == null) {
            return;
        }
        int lhCount = lhg.getLienHierarchiqueCount();
        for (int i = 0; i < lhCount; ++i) {
            LienHierarchique lh = lhg.getLienHierarchique(i);
            boolean done = secteurBuilder.addLiaison(this.liaisonFilter, lh, lh.getDescripteurFils(), (short)1, i, this.currentCode);
            if (!done) continue;
            ++this.currentCode;
        }
    }

    public Ventilation toVentilation() {
        InternalVentilation ventilation = new InternalVentilation(this.atlas, this.ventilationName, this.root, this.colorStyle);
        ArrayList<Secteur> resultList = new ArrayList<Secteur>();
        int index = 0;
        for (SecteurBuilder secteurBuilder : this.secteurBuilderList) {
            Secteur secteur = secteurBuilder.toSecteur(ventilation, index, this.ignoreEmpty);
            if (secteur == null) continue;
            resultList.add(secteur);
            ++index;
        }
        ventilation.secteurList = VentilationUtils.toSecteurList(resultList);
        return ventilation;
    }

    public int createCode() {
        int code = this.currentCode++;
        return code;
    }

    public ColorStyle getColorStyle(Contexte contexte) {
        return ColorStyle.fromContexte(contexte);
    }

    public ColorStyle getColorStyle(Grille grille) {
        return ColorStyle.fromGrille(grille);
    }

    private static class InternalVentilation
    implements Ventilation {
        private final Atlas atlas;
        private final VentilationName ventilationName;
        private final Term root;
        private final ColorStyle colorStyle;
        private SecteurList secteurList;

        private InternalVentilation(Atlas atlas, VentilationName ventilationName, Term root, ColorStyle colorStyle) {
            this.atlas = atlas;
            this.ventilationName = ventilationName;
            this.root = root;
            this.colorStyle = colorStyle;
        }

        @Override
        public SecteurList getFirstLevelSecteurList() {
            return this.secteurList;
        }

        @Override
        public Atlas getSource() {
            return this.atlas;
        }

        @Override
        public Term getRoot() {
            return this.root;
        }

        @Override
        public ColorStyle getColorStyle() {
            return this.colorStyle;
        }

        @Override
        public VentilationName getVentilationName() {
            return this.ventilationName;
        }
    }
}

