/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.json.producers;

import java.io.IOException;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.json.api.FamilleSelection;
import net.desmodo.atlas.json.api.FieldFilter;
import net.desmodo.atlas.json.producers.AbstractJsonProducer;
import net.desmodo.atlas.json.producers.AtlasJsonUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.SubstringPosition;
import net.mapeadores.util.text.lexie.LexieDistribution;
import net.mapeadores.util.text.lexie.LexieDistributionBuilder;
import net.mapeadores.util.text.lexie.LexieSource;
import net.mapeadores.util.text.lexie.Occurrence;
import net.mapeadores.util.text.lexie.ParsedLexieSource;
import net.mapeadores.util.text.lexie.TextLexieUnit;

public class LexieDistributionJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final Lang lang;
    private final FamilleSelection familleSelection;
    private final FieldFilter descripteurFieldFilter;
    private final LexieDistribution lexieDistribution;

    public LexieDistributionJsonProducer(Atlas atlas, Lang lang, FamilleSelection familleSelection, FieldFilter descripteurFieldFilter) {
        this.atlas = atlas;
        this.lang = lang;
        this.familleSelection = familleSelection;
        this.descripteurFieldFilter = descripteurFieldFilter;
        this.lexieDistribution = LexieDistributionJsonProducer.buildLexieDistribution(atlas, lang, familleSelection);
    }

    public void writeJson(Appendable appendable) throws IOException {
        int sourceCount;
        JSONWriter jsonWriter = new JSONWriter(appendable);
        jsonWriter.object();
        jsonWriter.key("lexiedistribution");
        jsonWriter.object();
        jsonWriter.key("lang");
        jsonWriter.value((Object)this.lang.getRootLang());
        int lexieCount = this.lexieDistribution.getLexieUnitCount();
        if (lexieCount > 0) {
            jsonWriter.key("lexieArray");
            jsonWriter.array();
            for (int i = 0; i < lexieCount; ++i) {
                TextLexieUnit lexieUnit = this.lexieDistribution.getLexieUnit(i);
                jsonWriter.object();
                jsonWriter.key("id");
                jsonWriter.value((Object)lexieUnit.getLexieId());
                jsonWriter.key("value");
                jsonWriter.value((Object)lexieUnit.getCanonicalLexie());
                int occurrenceCount = lexieUnit.getOccurrenceCount();
                jsonWriter.key("codeArray");
                jsonWriter.array();
                for (int j = 0; j < occurrenceCount; ++j) {
                    jsonWriter.value((long)Integer.parseInt(lexieUnit.getOccurrence(j).getParsedLexieSource().getLexieSource().getSourceId()));
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
        if ((sourceCount = this.lexieDistribution.getParserLexieSourceCount()) > 0) {
            jsonWriter.key("sourceMap");
            jsonWriter.object();
            for (int i = 0; i < sourceCount; ++i) {
                ParsedLexieSource parsedLexieSource = this.lexieDistribution.getParsedLexieSourceByIndex(i);
                Descripteur descripteur = (Descripteur)parsedLexieSource.getLexieSource().getSourceObject();
                jsonWriter.key("code_" + descripteur.getCode());
                jsonWriter.object();
                jsonWriter.key("descripteur");
                AtlasJsonUtils.descripteurObject(jsonWriter, descripteur, this.descripteurFieldFilter);
                jsonWriter.key("text");
                this.appendText(jsonWriter, parsedLexieSource);
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private void appendText(JSONWriter jsonWriter, ParsedLexieSource parsedLexieSource) throws IOException {
        jsonWriter.array();
        String text = parsedLexieSource.getLexieSource().getSourceText();
        int size = parsedLexieSource.getOccurrenceCount();
        if (size == 0) {
            jsonWriter.value((Object)text);
        } else {
            Occurrence currentOccurence = parsedLexieSource.getOccurrence(0);
            int currentOccurenceIndex = 0;
            SubstringPosition substringPosition = currentOccurence.getSubstringPosition();
            int startLexieIndex = substringPosition.getBeginIndex();
            int endLexieIndex = substringPosition.getEndIndex();
            if (startLexieIndex > 0) {
                jsonWriter.value((Object)text.substring(0, startLexieIndex));
            }
            while (true) {
                jsonWriter.object();
                jsonWriter.key("lexie");
                jsonWriter.value((Object)currentOccurence.getLexieUnit().getLexieId());
                jsonWriter.key("position");
                jsonWriter.value((long)currentOccurence.getOccurrencePosition());
                jsonWriter.key("value");
                jsonWriter.value((Object)text.substring(startLexieIndex, endLexieIndex + 1));
                jsonWriter.endObject();
                if (++currentOccurenceIndex >= size) break;
                currentOccurence = parsedLexieSource.getOccurrence(currentOccurenceIndex);
                substringPosition = currentOccurence.getSubstringPosition();
                startLexieIndex = substringPosition.getBeginIndex();
                if (startLexieIndex > endLexieIndex + 1) {
                    jsonWriter.value((Object)text.substring(endLexieIndex + 1, startLexieIndex));
                }
                endLexieIndex = substringPosition.getEndIndex();
            }
            if (endLexieIndex < text.length() - 1) {
                jsonWriter.value((Object)text.substring(endLexieIndex + 1));
            }
        }
        jsonWriter.endArray();
    }

    private static LexieDistribution buildLexieDistribution(Atlas atlas, Lang lang, FamilleSelection familleSelection) {
        LexieDistributionBuilder lexieDistributionBuilder = new LexieDistributionBuilder(lang);
        if (familleSelection.isWithSansfamille()) {
            Contexte sansfamille = StructureUtils.getSansfamilleContexte(atlas.getStructure());
            LexieDistributionJsonProducer.addDescripteurList(lexieDistributionBuilder, lang, sansfamille, false);
        }
        int familleCount = familleSelection.getFamilleCount();
        for (int i = 0; i < familleCount; ++i) {
            LexieDistributionJsonProducer.addDescripteurList(lexieDistributionBuilder, lang, familleSelection.getFamille(i), familleSelection.isRecursive(i));
        }
        return lexieDistributionBuilder.toLexieDistribution();
    }

    private static void addDescripteurList(LexieDistributionBuilder lexieDistributionBuilder, Lang lang, Contexte famille, boolean recursive) {
        DescripteurList infamilleDescripteurList = famille.getAtlas().getDescripteurs().getInFamilleDescripteurList(famille);
        int descripteurCount = infamilleDescripteurList.getDescripteurCount();
        for (int i = 0; i < descripteurCount; ++i) {
            Descripteur descripteur = infamilleDescripteurList.getDescripteur(i);
            Label libelle = descripteur.getLabels().getLangPartCheckedLabel(lang);
            if (libelle == null) continue;
            LexieSource lexieSource = new LexieSource(libelle.getLabelString(), (Object)descripteur, String.valueOf(descripteur.getCode()));
            lexieDistributionBuilder.addLexieSource(lexieSource);
        }
        if (recursive) {
            ContexteList contexteList = famille.getChildren();
            int childrenCount = contexteList.getContexteCount();
            for (int i = 0; i < childrenCount; ++i) {
                Contexte contexte = contexteList.getContexte(i);
                LexieDistributionJsonProducer.addDescripteurList(lexieDistributionBuilder, lang, contexte, true);
            }
        }
    }
}

