/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfDescripteur;
import fr.exemole.bdfext.desmoservice.atlas.BdfLienHierarchiqueGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.event.LiensListener;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienHierarchiqueList;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensUtils;
import net.desmodo.atlas.structure.Contexte;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;

class BdfLiens
implements Liens {
    private final BdfAtlas bdfAtlas;
    private final Map<Integer, InternalLienLists> lienListsMap = new HashMap<Integer, InternalLienLists>();

    BdfLiens(BdfAtlas bdfAtlas) {
        this.bdfAtlas = bdfAtlas;
    }

    @Override
    public Atlas getAtlas() {
        return this.bdfAtlas;
    }

    @Override
    public void addLiensListener(LiensListener liensListener) {
    }

    @Override
    public void removeLiensListener(LiensListener liensListener) {
    }

    @Override
    public LienStructurelList getLienStructurelList() {
        return LiensUtils.EMPTY_LIENSTRUCTUREL_LIST;
    }

    @Override
    public LienHierarchiqueGroupList getLienHierarchiqueGroupList() {
        ArrayList<BdfLienHierarchiqueGroup> resultList = new ArrayList<BdfLienHierarchiqueGroup>();
        for (FicheMeta ficheMeta : this.bdfAtlas.lienhierarchiqueCorpus.getFicheMetaList()) {
            BdfLienHierarchiqueGroup lienHierarchiqueGroup = BdfLienHierarchiqueGroup.build(this.bdfAtlas, (SubsetItem)ficheMeta);
            if (lienHierarchiqueGroup == null) continue;
            resultList.add(lienHierarchiqueGroup);
        }
        return new InternalLienHierarchiqueGroupList(resultList);
    }

    @Override
    public LienSymetriqueList getLienSymetriqueList() {
        return LiensUtils.EMPTY_LIENSYMETRIQUE_LIST;
    }

    @Override
    public int getLienCount(Term term) {
        return 0;
    }

    @Override
    public synchronized Liens.LienLists getLienLists(Descripteur descripteur) {
        InternalLienLists lienLists = this.lienListsMap.get(descripteur.getCode());
        if (lienLists != null) {
            return lienLists;
        }
        ArrayList<BdfLienHierarchiqueGroup> lhgList = new ArrayList<BdfLienHierarchiqueGroup>();
        ArrayList<LienHierarchique> lhList = new ArrayList<LienHierarchique>();
        BdfDescripteur bdfDescripteur = (BdfDescripteur)descripteur;
        Motcle descripteurMotcle = bdfDescripteur.getMotcle();
        Junctions lhJunctions = this.bdfAtlas.fichotheque.getJunctions((SubsetItem)descripteurMotcle, (Subset)this.bdfAtlas.lienhierarchiqueCorpus);
        for (Junctions.Entry entry : lhJunctions.getEntryList()) {
            BdfLienHierarchiqueGroup lhg = BdfLienHierarchiqueGroup.build(this.bdfAtlas, entry.getSubsetItem());
            if (lhg == null) continue;
            if (lhg.getDescripteurPere().equals(descripteur)) {
                lhgList.add(lhg);
                continue;
            }
            int lhCount = lhg.getLienHierarchiqueCount();
            for (int j = 0; j < lhCount; ++j) {
                LienHierarchique lh = lhg.getLienHierarchique(j);
                if (!lh.getDescripteurFils().equals(descripteur)) continue;
                lhList.add(lh);
            }
        }
        lienLists = new InternalLienLists();
        this.lienListsMap.put(descripteur.getCode(), lienLists);
        lienLists.lienHierarchiqueGroupList = new InternalLienHierarchiqueGroupList(lhgList);
        lienLists.lienHierarchiqueList = new InternalLienHierarchiqueList(lhList);
        return lienLists;
    }

    @Override
    public LienStructurelList getLienStructurelList(Contexte contexte) {
        return LiensUtils.EMPTY_LIENSTRUCTUREL_LIST;
    }

    @Override
    public Liens.LienLists getLienLists(Descripteur descripteur1, Descripteur descripteur2) {
        return null;
    }

    private static class InternalLienHierarchiqueGroupList
    implements LienHierarchiqueGroupList {
        private List<LienHierarchiqueGroup> list = new ArrayList<LienHierarchiqueGroup>();

        private InternalLienHierarchiqueGroupList(List<LienHierarchiqueGroup> list) {
            this.list = list;
        }

        @Override
        public int getLienHierarchiqueGroupCount() {
            return this.list.size();
        }

        @Override
        public LienHierarchiqueGroup getLienHierarchiqueGroup(int i) {
            return this.list.get(i);
        }
    }

    private class InternalLienLists
    implements Liens.LienLists {
        private LienStructurelList lienStructurelList = null;
        private LienHierarchiqueGroupList lienHierarchiqueGroupList = null;
        private LienHierarchiqueList lienHierarchiqueList = null;
        private LienSymetriqueList lienSymetriqueList = null;

        private InternalLienLists() {
        }

        @Override
        public LienHierarchiqueList getLienHierarchiqueList() {
            if (this.lienHierarchiqueList == null) {
                return LiensUtils.EMPTY_LIENHIERARCHIQUE_LIST;
            }
            return this.lienHierarchiqueList;
        }

        @Override
        public LienSymetriqueList getLienSymetriqueList() {
            if (this.lienSymetriqueList == null) {
                return LiensUtils.EMPTY_LIENSYMETRIQUE_LIST;
            }
            return this.lienSymetriqueList;
        }

        @Override
        public LienHierarchiqueGroupList getLienHierarchiqueGroupList() {
            if (this.lienHierarchiqueGroupList == null) {
                return LiensUtils.EMPTY_LIENHIERARCHIQUEGROUP_LIST;
            }
            return this.lienHierarchiqueGroupList;
        }

        @Override
        public LienStructurelList getLienStructurelList() {
            if (this.lienStructurelList == null) {
                return LiensUtils.EMPTY_LIENSTRUCTUREL_LIST;
            }
            return this.lienStructurelList;
        }

        private int getLienCount() {
            int count = 0;
            if (this.lienStructurelList != null) {
                count += this.lienStructurelList.getLienStructurelCount();
            }
            if (this.lienSymetriqueList != null) {
                count += this.lienSymetriqueList.getLienSymetriqueCount();
            }
            if (this.lienHierarchiqueList != null) {
                count += this.lienHierarchiqueList.getLienHierarchiqueCount();
            }
            if (this.lienHierarchiqueGroupList != null) {
                count += this.lienHierarchiqueGroupList.getLienHierarchiqueGroupCount();
            }
            return count;
        }
    }

    private static class InternalLienHierarchiqueList
    implements LienHierarchiqueList {
        private List<LienHierarchique> list = new ArrayList<LienHierarchique>();

        private InternalLienHierarchiqueList(List<LienHierarchique> list) {
            this.list = list;
        }

        @Override
        public int getLienHierarchiqueCount() {
            return this.list.size();
        }

        @Override
        public LienHierarchique getLienHierarchique(int i) {
            return this.list.get(i);
        }
    }
}

