/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import java.util.Collections;
import java.util.List;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Tie;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.JunctionUtils;

public final class BdfAtlasUtils {
    public static final JunctionChange FILSREMOVE_JUNCTIONCHANGE = new FilsRemoveJunctionChange();

    private BdfAtlasUtils() {
    }

    public static int getTermCode(Motcle motcle, short termeType) {
        return motcle.getId() * 10 + termeType;
    }

    public static int getTermCode(int idsusbet, short termeType) {
        return idsusbet * 10 + termeType;
    }

    public static short getTypeFromTermCode(int code) {
        if (code <= 1) {
            return -1;
        }
        int reste = code % 10;
        if (reste == 0 || reste == 9) {
            return -1;
        }
        return (short)reste;
    }

    public static int getIdFromTermCode(int code) {
        return code / 10;
    }

    public static boolean isFamilleJunction(Junction junction) {
        for (Tie tie : junction.getTieList()) {
            if (!tie.getMode().equals("")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFamilleJunction(Junctions junctions) {
        for (Junctions.Entry entry : junctions.getEntryList()) {
            if (!BdfAtlasUtils.isFamilleJunction(entry.getJunction())) continue;
            return true;
        }
        return false;
    }

    private static class FilsRemoveJunctionChange
    implements JunctionChange {
        private final List<String> removedModeList = Collections.singletonList("fils");

        private FilsRemoveJunctionChange() {
        }

        public List<String> getRemovedModeList() {
            return this.removedModeList;
        }

        public List<Tie> getChangedTieList() {
            return JunctionUtils.EMPTY_TIELIST;
        }
    }
}

