/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.awt.Color;
import java.io.IOException;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasFilter;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.awt.ColorUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.LangFilter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class StructureXMLPart
extends XMLPart {
    private final AtlasFilter atlasFilter;
    private boolean oldCrtxml;

    public StructureXMLPart(XMLWriter xmlWriter, AtlasFilter atlasFilter) {
        super(xmlWriter);
        this.atlasFilter = atlasFilter;
    }

    public void setOldCrtxml(boolean oldCrtxml) {
        this.oldCrtxml = oldCrtxml;
    }

    public void addStructure(Structure structure) throws IOException {
        this.openTag("structure");
        GrilleList grilleList = structure.getGrilleList();
        int grilleCount = grilleList.getGrilleCount();
        for (int i = 0; i < grilleCount; ++i) {
            this.addGrille(grilleList.getGrille(i));
        }
        Grille familles = structure.getGrilleDesFamilles();
        if (familles.getFirstLevelContexteList().getContexteCount() > 0) {
            this.addGrille(familles);
        }
        this.closeTag("structure");
    }

    private void addGrille(Grille grille) throws IOException {
        String tagName;
        String grilleName = grille.getGrilleName();
        if (grilleName.length() == 0) {
            tagName = "familles";
            this.openTag(tagName);
        } else {
            tagName = "grille";
            this.startOpenTag(tagName);
            if (this.oldCrtxml) {
                this.addAttribute("grl", grilleName);
                this.addAttribute("nomgrille", grilleName);
            } else {
                this.addAttribute("name", grilleName);
            }
            this.endOpenTag();
            XMLUtils.addLibElements((XMLWriter)this, (Labels)grille.getLabels(), (LangFilter)this.atlasFilter.getLangFilter());
            if (!this.oldCrtxml) {
                AttributeUtils.addAttributes((XMLWriter)this, (Attributes)grille.getAttributes());
            } else {
                this.addSimpleElement("color", ColorUtils.toHexFormat((Color)AtlasAttributes.getColor(grille)));
            }
        }
        ContexteList liste = grille.getFirstLevelContexteList();
        int contexteCount = liste.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            this.addContexte(liste.getContexte(i));
        }
        this.closeTag(tagName);
    }

    private void addContexte(Contexte contexte) throws IOException {
        this.startOpenTag("contexte");
        this.addAttribute("idctxt", contexte.getIdctxt());
        if (!contexte.isActive()) {
            this.addAttribute("active", "0");
        }
        this.endOpenTag();
        XMLUtils.addLibElements((XMLWriter)this, (Labels)contexte.getLabels(), (LangFilter)this.atlasFilter.getLangFilter());
        if (!this.oldCrtxml) {
            AttributeUtils.addAttributes((XMLWriter)this, (Attributes)contexte.getAttributes());
        } else {
            this.addSimpleElement("color", ColorUtils.toHexFormat((Color)AtlasAttributes.getColor(contexte)));
        }
        ContexteList liste = contexte.getChildren();
        int contexteCount = liste.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            this.addContexte(liste.getContexte(i));
        }
        this.closeTag("contexte");
    }
}

