/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation;

import java.text.ParseException;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.Term;

public final class VentilationName {
    public static final String VENTILATION_NAMESPACE = "ventilation";
    public static final String SCRIPT_NAMESPACE = "script";
    public static final VentilationName VENTILATION_NATURELLE = new VentilationName("ventilation", "naturelle", null);
    public static final VentilationName VENTILATION_COMPLETE = new VentilationName("ventilation", "complete", null);
    public static final VentilationName VENTILATION_BYFAMILLE = new VentilationName("ventilation", "byfamille", null);
    private final String nameSpace;
    private final String localName;
    private final Term term;
    private final String uriString;

    public VentilationName(String nameSpace, String localName, Term term) {
        this.nameSpace = nameSpace;
        this.localName = localName;
        this.term = term;
        this.uriString = VentilationName.toURI(nameSpace, localName, term);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int hashCode() {
        return this.uriString.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        VentilationName other = (VentilationName)obj;
        return other.uriString.equals(this.uriString);
    }

    public String toUriString() {
        return this.uriString;
    }

    public String toString() {
        return this.uriString;
    }

    public Term getTerm() {
        return this.term;
    }

    public static VentilationName parse(String s, Atlas atlas) throws ParseException {
        if (s.length() == 0) {
            throw new ParseException("s is empty", 0);
        }
        char carac = s.charAt(0);
        if (carac >= '0' && carac <= '9') {
            try {
                int code = Integer.parseInt(s);
                Term term = atlas.getTerm(code);
                if (term != null) {
                    return new VentilationName(VENTILATION_NAMESPACE, null, term);
                }
                throw new ParseException("Code unknown : code", 0);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Begining with number", 0);
            }
        }
        int idx = s.indexOf(58);
        if (idx == -1) {
            throw new ParseException("Missing :", s.length() - 1);
        }
        String nameSpace = s.substring(0, idx);
        String next = s.substring(idx + 1);
        if (next.length() == 0) {
            throw new ParseException("Missing localName", idx);
        }
        if (nameSpace.equals(VENTILATION_NAMESPACE)) {
            if (s.equals(VENTILATION_NATURELLE.toString())) {
                return VENTILATION_NATURELLE;
            }
            if (s.equals(VENTILATION_BYFAMILLE.toString())) {
                return VENTILATION_BYFAMILLE;
            }
            if (s.equals(VENTILATION_COMPLETE.toString())) {
                return VENTILATION_COMPLETE;
            }
            Term term = AtlasURI.parseURI(atlas, next);
            if (term != null) {
                return new VentilationName(VENTILATION_NAMESPACE, null, term);
            }
            throw new ParseException("Unknown atlas uri: " + next, idx);
        }
        int idx2 = next.indexOf(58);
        if (idx2 == -1) {
            return new VentilationName(nameSpace, next, null);
        }
        String localName = next.substring(0, idx2);
        if (localName.length() == 0) {
            throw new ParseException("Missing localName", idx2);
        }
        String termURI = next.substring(idx2 + 1);
        Term term = AtlasURI.parseURI(atlas, termURI);
        if (term != null) {
            return new VentilationName(nameSpace, localName, term);
        }
        throw new ParseException("Unknown atlas uri: " + termURI, idx2);
    }

    private static String toURI(String nameSpace, String localName, Term term) {
        StringBuilder buf = new StringBuilder();
        buf.append(nameSpace);
        if (localName != null) {
            buf.append(':');
            buf.append(localName);
        }
        if (term != null) {
            buf.append(':');
            buf.append(AtlasURI.toURIString(term));
        }
        return buf.toString();
    }
}

